from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_db_shortcuts = _Mock()

_passer = _Mock()

_printer = _Mock()

cast_bytes = _Mock()

empty_record = _Mock()

error = _Mock()

extract_dates = _Mock()

import_item = _Mock()

init_record = _Mock()

ioloop = _Mock()

iteritems = _Mock()

json = _Mock()

localhost = _Mock()

os = _Mock()

print_function = _Mock()

sys = _Mock()

time = _Mock()

util = _Mock()

zmq = _Mock()



class CBytes(_Mock):
  pass
  default_value = ''
  info_text = 'a bytes object'

class Dict(_Mock):
  pass
  info_text = 'any value'

class DottedObjectName(_Mock):
  pass
  info_text = 'a valid object identifier in Python'

class EngineConnector(_Mock):
  pass


class HasTraits(_Mock):
  pass


class HeartMonitor(_Mock):
  pass


class Hub(_Mock):
  pass


class HubFactory(_Mock):
  pass


class Instance(_Mock):
  pass
  info_text = 'any value'

class Integer(_Mock):
  pass
  default_value = 0
  info_text = 'an integer'

class RegistrationFactory(_Mock):
  pass


class SessionFactory(_Mock):
  pass


class Set(_Mock):
  pass
  info_text = 'any value'

class Tuple(_Mock):
  pass
  info_text = 'any value'

class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

class ZMQStream(_Mock):
  pass


class datetime(_Mock):
  pass


class unicode_type(_Mock):
  pass


