
[//000000001]: # (ftpd \- Tcl FTP Server Package)
[//000000002]: # (Generated from file 'ftpd\.man' by tcllib/doctools with format 'markdown')
[//000000003]: # (ftpd\(n\) 1\.3 tcllib "Tcl FTP Server Package")

<hr> [ <a href="../../../../toc.md">Main Table Of Contents</a> &#124; <a
href="../../../toc.md">Table Of Contents</a> &#124; <a
href="../../../../index.md">Keyword Index</a> &#124; <a
href="../../../../toc0.md">Categories</a> &#124; <a
href="../../../../toc1.md">Modules</a> &#124; <a
href="../../../../toc2.md">Applications</a> ] <hr>

# NAME

ftpd \- Tcl FTP server implementation

# <a name='toc'></a>Table Of Contents

  - [Table Of Contents](#toc)

  - [Synopsis](#synopsis)

  - [Description](#section1)

  - [COMMANDS](#section2)

  - [CALLBACKS](#section3)

  - [VARIABLES](#section4)

  - [Bugs, Ideas, Feedback](#section5)

  - [Keywords](#keywords)

  - [Category](#category)

# <a name='synopsis'></a>SYNOPSIS

package require Tcl 8\.3  
package require ftpd ?1\.3?  

[__::ftpd::server__ ?*myaddr*?](#1)  
[__::ftpd::config__ ?*option value*? ?*option value \.\.\.*?](#2)  
[*fsCmd* __append__ *path*](#3)  
[*fsCmd* __delete__ *path* *channel*](#4)  
[*fsCmd* __dlist__ *path* *style* *channel*](#5)  
[*fsCmd* __exists__ *path*](#6)  
[*fsCmd* __mkdir__ *path* *channel*](#7)  
[*fsCmd* __mtime__ *path* *channel*](#8)  
[*fsCmd* __permissions__ *path*](#9)  
[*fsCmd* __rename__ *path* *newpath* *channel*](#10)  
[*fsCmd* __retr__ *path*](#11)  
[*fsCmd* __rmdir__ *path* *channel*](#12)  
[*fsCmd* __size__ *path* *channel*](#13)  
[*fsCmd* __store__ *path*](#14)  

# <a name='description'></a>DESCRIPTION

The __ftpd__ package provides a simple Tcl\-only server library for the FTP
protocol as specified in RFC 959
\([http://www\.rfc\-editor\.org/rfc/rfc959\.txt](http://www\.rfc\-editor\.org/rfc/rfc959\.txt)\)\.
It works by listening on the standard FTP socket\. Most server errors are
returned as error messages with the appropriate code attached to them\. Since the
server code for the ftp daemon is executed in the event loop, it is possible
that a __bgerror__ will be thrown on the server if there are problems with
the code in the module\.

# <a name='section2'></a>COMMANDS

  - <a name='1'></a>__::ftpd::server__ ?*myaddr*?

    Open a listening socket to listen to and accept ftp connections\. myaddr is
    an optional argument\. *myaddr* is the domain\-style name or numerical IP
    address of the client\-side network interface to use for the connection\.

  - <a name='2'></a>__::ftpd::config__ ?*option value*? ?*option value \.\.\.*?

    The value is always the name of the command to call as the callback\. The
    option specifies which callback should be configured\. See section
    [CALLBACKS](#section3) for descriptions of the arguments and return
    values for each of the callbacks\.

      * \-authIpCmd *proc*

        Callback to authenticate new connections based on the ip\-address of the
        peer\.

      * \-authUsrCmd *proc*

        Callback to authenticate new connections based on the user logging in
        \(and the users password\)\.

      * \-authFileCmd *proc*

        Callback to accept or deny a users access to read and write to a
        specific path or file\.

      * \-logCmd *proc*

        Callback for log information generated by the FTP engine\.

      * \-fsCmd *proc*

        Callback to connect the engine to the filesystem it operates on\.

      * \-closeCmd *proc*

        Callback to be called when a connection is closed\. This allows the
        embedding application to perform its own cleanup operations\.

      * \-xferDoneCmd *proc*

        Callback for transfer completion notification\. In other words, it is
        called whenever a transfer of data to or from the client has completed\.

# <a name='section3'></a>CALLBACKS

  - __authIpCmd__ callback

    The authIpCmd receives the ip\-address of the peer attempting to connect to
    the ftp server as its argument\. It returns a 1 to allow users from the
    specified IP to attempt to login and a 0 to reject the login attempt from
    the specified IP\.

  - __authUsrCmd__ callback

    The authUsrCmd receives the username and password as its two arguments\. It
    returns a 1 to accept the attempted login to the ftpd and a 0 to reject the
    attempted login\.

  - __authFileCmd__ callback

    The authFileCmd receives the user \(that is currently logged in\), the path or
    filename that is about to be read or written, and __read__ or
    __write__ as its three arguments\. It returns a 1 to allow the path or
    filename to be read or written, and a 0 to reject the attempted read or
    write with a permissions error code\.

  - __logCmd__ callback

    The logCmd receives a severity and a message as its two arguments\. The
    severities used within the ftpd package are __note__, __debug__, and
    __error__\. The logCmd doesn't return anything\.

  - __fsCmd__ callback

    The fsCmd receives a subcommand, a filename or path, and optional additional
    arguments \(depending on the subcommand\)\.

    The subcommands supported by the fsCmd are:

      * <a name='3'></a>*fsCmd* __append__ *path*

        The append subcommand receives the filename to append to as its
        argument\. It returns a writable tcl channel as its return value\.

      * <a name='4'></a>*fsCmd* __delete__ *path* *channel*

        The delete subcommand receives the filename to delete, and a channel to
        write to as its two arguments\. The file specified is deleted and the
        appropriate ftp message is written to the channel that is passed as the
        second argument\. The delete subcommand returns nothing\.

      * <a name='5'></a>*fsCmd* __dlist__ *path* *style* *channel*

        The dlist subcommand receives the path that it should list the files
        that are in, the style in which the files should be listed which is
        either __nlst__ or __list__, and a channel to write to as its
        three arguments\. The files in the specified path are printed to the
        specified channel one per line\. If the style is __nlst__ only the
        name of the file is printed to the channel\. If the style is __list__
        then the file permissions, number of links to the file, the name of the
        user that owns the file, the name of the group that owns the file, the
        size \(in bytes\) of the file, the modify time of the file, and the
        filename are printed out to the channel in a formatted space separated
        format\. The __dlist__ subcommand returns nothing\.

      * <a name='6'></a>*fsCmd* __exists__ *path*

        The exists subcommand receives the name of a file to check the existence
        of as its only argument\. The exists subcommand returns a 1 if the path
        specified exists and the path is not a directory\.

      * <a name='7'></a>*fsCmd* __mkdir__ *path* *channel*

        The mkdir subcommand receives the path of a directory to create and a
        channel to write to as its two arguments\. The mkdir subcommand creates
        the specified directory if necessary and possible\. The mkdir subcommand
        then prints the appropriate success or failure message to the channel\.
        The mkdir subcommand returns nothing\.

      * <a name='8'></a>*fsCmd* __mtime__ *path* *channel*

        The mtime subcommand receives the path of a file to check the modify
        time on and a channel as its two arguments\. If the file exists the mtime
        is printed to the channel in the proper FTP format, otherwise an
        appropriate error message and code are printed to the channel\. The mtime
        subcommand returns nothing\.

      * <a name='9'></a>*fsCmd* __permissions__ *path*

        The permissions subcommand receives the path of a file to retrieve the
        permissions of\. The permissions subcommand returns the octal file
        permissions of the specified file\. The file is expected to exist\.

      * <a name='10'></a>*fsCmd* __rename__ *path* *newpath* *channel*

        The rename subcommand receives the path of the current file, the new
        file path, and a channel to write to as its three arguments\. The rename
        subcommand renames the current file to the new file path if the path to
        the new file exists, and then prints out the appropriate message to the
        channel\. If the new file path doesn't exist the appropriate error
        message is printed to the channel\. The rename subcommand returns
        nothing\.

      * <a name='11'></a>*fsCmd* __retr__ *path*

        The retr subcommand receives the path of a file to read as its only
        argument\. The retr subcommand returns a readable channel that the
        specified file can be read from\.

      * <a name='12'></a>*fsCmd* __rmdir__ *path* *channel*

        The rmdir subcommand receives the path of a directory to remove and a
        channel to write to as its two arguments\. The rmdir subcommand removes
        the specified directory \(if possible\) and prints the appropriate message
        to the channel \(which may be an error if the specified directory does
        not exist or is not empty\)\. The rmdir subcommand returns nothing\.

      * <a name='13'></a>*fsCmd* __size__ *path* *channel*

        The size subcommand receives the path of a file to get the size \(in
        bytes\) of and a channel to write to as its two arguments\. The size
        subcommand prints the appropriate code and the size of the file if the
        specified path is a file, otherwise an appropriate error code and
        message are printed to the channel\. The size subcommand returns nothing\.

      * <a name='14'></a>*fsCmd* __store__ *path*

        The store subcommand receives the path of a file to write as its only
        argument\. The store subcommand returns a writable channel\.

  - __closeCmd__

    The __closeCmd__ receives no arguments when it is invoked, and any
    return value it may generate is discarded\.

  - __xferDoneCmd__ sock sock2 file bytes filename err

    The __xferDoneCmd__ receives six arguments when invoked\. These are, in
    this order, the channel handle of the control socket for the connection, the
    channel handle of the data socket used for the transfer \(already closed\),
    the handle of the channel containing the transfered file, the number of
    bytes transfered, the path of the file which was transfered, and a \(possibly
    empty\) error message\. Any return value it may generate is discarded\.

# <a name='section4'></a>VARIABLES

  - __::ftpd::cwd__

    The current working directory for a session when someone first connects to
    the FTPD or when the __REIN__ ftp command is received\.

  - __::ftpd::contact__

    The e\-mail address of the person that is the contact for the ftp server\.
    This address is printed out as part of the response to the __FTP HELP__
    command\.

  - __::ftpd::port__

    The port that the ftp server should listen on\. If port is specified as zero,
    the operating system will allocate an unused port for use as a server
    socket; afterwards, the variable will contain the port number that was
    allocated\.

  - __::ftpd::welcome__

    The message that is printed out when the user first connects to the ftp
    server\.

  - __::ftpd::CurrentSocket__

    Accessible to all callbacks and all filesystem commands \(which are a special
    form of callback\) and contains the handle of the socket channel which was
    active when the callback was invoked\.

# <a name='section5'></a>Bugs, Ideas, Feedback

This document, and the package it describes, will undoubtedly contain bugs and
other problems\. Please report such in the category *ftpd* of the [Tcllib
Trackers](http://core\.tcl\.tk/tcllib/reportlist)\. Please also report any ideas
for enhancements you may have for either package and/or documentation\.

When proposing code changes, please provide *unified diffs*, i\.e the output of
__diff \-u__\.

Note further that *attachments* are strongly preferred over inlined patches\.
Attachments can be made by going to the __Edit__ form of the ticket
immediately after its creation, and then using the left\-most button in the
secondary navigation bar\.

# <a name='keywords'></a>KEYWORDS

[ftp](\.\./\.\./\.\./\.\./index\.md\#ftp), [ftpd](\.\./\.\./\.\./\.\./index\.md\#ftpd),
[ftpserver](\.\./\.\./\.\./\.\./index\.md\#ftpserver), [rfc
959](\.\./\.\./\.\./\.\./index\.md\#rfc\_959),
[services](\.\./\.\./\.\./\.\./index\.md\#services)

# <a name='category'></a>CATEGORY

Networking
