/*
 * basiclog.h - basic DataLog classes
 * $Id: basiclog.h 151 2004-06-05 15:15:18Z rdenisc $
 */

/***********************************************************************
 *  Copyright (C) 2002-2004 Remi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Public License  *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifndef __TCPREEN_BASICLOG_H

# define __TCPREEN_BASICLOG_H
# include "log.h"

# ifndef __cplusplus
#  error This is a C++ only header!
# else
/*
 * Base class for generic format (and possibly some others in the future)
 */
class GenericDataLog : public DataLog
{
	private:
		long incount, outcount;

	public:
		GenericDataLog (void) : DataLog (), incount (0), outcount (0)
		{
		}
		virtual ~GenericDataLog (void);

		void Connect (const char *server, const char *service,
				const char *client, const char *port);
		int WriteServerData (const void *data, int length, int oob);
		int WriteClientData (const void *data, int length, int oob);
		void ShutdownServer (void);
		void ShutdownClient (void);
};


/*
 * Base class for all basic log formats
 */
class BasicDataLog : public GenericDataLog
{
	private:
		int (*logwrite) (const void *, int, FILE *);

	public:
		BasicDataLog (int (*logfunc) (const void *, int, FILE *)) :
			GenericDataLog (), logwrite (logfunc)
		{
		}

		int WriteServerData (const void *data, int length, int oob);
		int WriteClientData (const void *data, int length, int oob);
};

/*
 * Makers for the above classes
 */
extern DataLog *CountDataLogMaker (void);
extern DataLog *CDataLogMaker (void);
extern DataLog *HexDataLogMaker (void);
extern DataLog *RawDataLogMaker (void);
extern DataLog *StrippedDataLogMaker (void);
extern DataLog *NullDataLogMaker (void);

# endif /* ifdef __cplusplus */
#endif /* ifndef __TCPREEN_BASICLOG_H */
