package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySnapshotGroup invokes the ecs.ModifySnapshotGroup API synchronously
func (client *Client) ModifySnapshotGroup(request *ModifySnapshotGroupRequest) (response *ModifySnapshotGroupResponse, err error) {
	response = CreateModifySnapshotGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySnapshotGroupWithChan invokes the ecs.ModifySnapshotGroup API asynchronously
func (client *Client) ModifySnapshotGroupWithChan(request *ModifySnapshotGroupRequest) (<-chan *ModifySnapshotGroupResponse, <-chan error) {
	responseChan := make(chan *ModifySnapshotGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySnapshotGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySnapshotGroupWithCallback invokes the ecs.ModifySnapshotGroup API asynchronously
func (client *Client) ModifySnapshotGroupWithCallback(request *ModifySnapshotGroupRequest, callback func(response *ModifySnapshotGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySnapshotGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifySnapshotGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySnapshotGroupRequest is the request struct for api ModifySnapshotGroup
type ModifySnapshotGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Description          string           `position:"Query" name:"Description"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	SnapshotGroupId      string           `position:"Query" name:"SnapshotGroupId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Name                 string           `position:"Query" name:"Name"`
}

// ModifySnapshotGroupResponse is the response struct for api ModifySnapshotGroup
type ModifySnapshotGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifySnapshotGroupRequest creates a request to invoke ModifySnapshotGroup API
func CreateModifySnapshotGroupRequest() (request *ModifySnapshotGroupRequest) {
	request = &ModifySnapshotGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "ModifySnapshotGroup", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifySnapshotGroupResponse creates a response to parse from ModifySnapshotGroup response
func CreateModifySnapshotGroupResponse() (response *ModifySnapshotGroupResponse) {
	response = &ModifySnapshotGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
