/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.EmptyGroupTitle;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.bib2gls.GroupTitle;
import com.dickimawbooks.bib2gls.OtherGroupTitle;
import com.dickimawbooks.bib2gls.SortComparator;
import com.dickimawbooks.bib2gls.SortSettings;
import java.util.Vector;

public class Bib2GlsEntryLetterComparator
extends SortComparator {
    protected int caseStyle;
    public static final int CASE = 0;
    public static final int TOLOWER = 1;
    public static final int UPPERLOWER = 2;
    public static final int LOWERUPPER = 3;

    public Bib2GlsEntryLetterComparator(Bib2Gls bib2Gls, Vector<Bib2GlsEntry> vector, SortSettings sortSettings, String string, String string2, String string3) {
        super(bib2Gls, vector, sortSettings, string, string2, string3);
        this.caseStyle = sortSettings.caseStyle();
        switch (this.caseStyle) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid caseStyle");
            }
        }
        this.caseStyle = this.caseStyle;
    }

    @Override
    protected String adjustSort(Bib2GlsEntry bib2GlsEntry, String string) {
        if (this.caseStyle == 1) {
            return string.toLowerCase();
        }
        return string;
    }

    @Override
    protected long getDefaultGroupId(Bib2GlsEntry bib2GlsEntry, int n, Object object) {
        String string = object.toString();
        if (n == -1 || string.isEmpty()) {
            return 0L;
        }
        if (Character.isAlphabetic(n)) {
            String string2 = new String(Character.toChars(n));
            String string3 = this.caseStyle == 0 ? string2 : string2.toUpperCase();
            int n2 = string3.codePointAt(0);
            if (this.caseStyle == 2 || this.caseStyle == 3) {
                n2 = Character.toLowerCase(n2);
            }
            return n2;
        }
        return n;
    }

    @Override
    protected GroupTitle createDefaultGroupTitle(int n, Object object, String string) {
        String string2 = object.toString();
        if (n == -1 || string2.isEmpty()) {
            return new EmptyGroupTitle(string);
        }
        String string3 = new String(Character.toChars(n));
        if (Character.isAlphabetic(n)) {
            String string4 = this.caseStyle == 0 ? string3 : string3.toUpperCase();
            int n2 = string4.codePointAt(0);
            if (this.caseStyle == 2 || this.caseStyle == 3) {
                n2 = Character.toLowerCase(n2);
            }
            return new GroupTitle(string4, string3, n2, string);
        }
        if (string3.equals("\\") || string3.equals("{") || string3.equals("}")) {
            string3 = "\\char`\\" + string3;
        }
        return new OtherGroupTitle(string3, n, string);
    }

    @Override
    protected String updateSortValue(Bib2GlsEntry bib2GlsEntry, Vector<Bib2GlsEntry> vector) {
        String string = super.updateSortValue(bib2GlsEntry, vector);
        String string2 = bib2GlsEntry.getId();
        String string3 = null;
        GlsResource glsResource = this.bib2gls.getCurrentResource();
        String string4 = this.getType(bib2GlsEntry);
        if (this.bib2gls.useGroupField() && !bib2GlsEntry.hasParent() && bib2GlsEntry.getFieldValue(this.groupField) == null) {
            if (string.isEmpty()) {
                this.setGroupTitle(bib2GlsEntry, -1, string, string, string4);
            } else {
                int n = string.codePointAt(0);
                string3 = this.setGroupTitle(bib2GlsEntry, n, string, string, string4);
            }
        }
        if (this.bib2gls.getVerboseLevel() > 0) {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = string.length();
            for (int i = 0; i < n2; i += Character.charCount(n)) {
                n = string.codePointAt(i);
                if (stringBuilder.length() == 0) {
                    stringBuilder.append(n);
                    continue;
                }
                stringBuilder.append(' ');
                stringBuilder.append(n);
            }
            if (string3 == null) {
                this.bib2gls.verbose(String.format("%s -> '%s' [%s]", string2, string, stringBuilder));
            } else {
                this.bib2gls.verbose(String.format("%s -> '%s' (%s) [%s]", string2, string, string3, stringBuilder));
            }
        }
        return string;
    }

    @Override
    protected int compare(int n, int n2) {
        if (this.caseStyle == 2) {
            int n3;
            int n4 = Character.toLowerCase(n);
            if (n4 == (n3 = Character.toLowerCase(n2))) {
                if (n == n2) {
                    return 0;
                }
                if (Character.isUpperCase(n)) {
                    return -1;
                }
                if (Character.isUpperCase(n2)) {
                    return 1;
                }
                if (n < n2) {
                    return -1;
                }
                return 1;
            }
            if (n4 < n3) {
                return -1;
            }
            if (n4 > n3) {
                return 1;
            }
        } else if (this.caseStyle == 3) {
            int n5;
            int n6 = Character.toLowerCase(n);
            if (n6 == (n5 = Character.toLowerCase(n2))) {
                if (n == n2) {
                    return 0;
                }
                if (Character.isLowerCase(n)) {
                    return -1;
                }
                if (Character.isLowerCase(n2)) {
                    return 1;
                }
                if (n < n2) {
                    return -1;
                }
                return 1;
            }
            if (n6 < n5) {
                return -1;
            }
            if (n6 > n5) {
                return 1;
            }
        } else {
            if (n < n2) {
                return -1;
            }
            if (n > n2) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    protected int compare(String string, String string2) {
        int n;
        int n2;
        int n3 = string.length();
        int n4 = string2.length();
        int n5 = 0;
        for (int i = 0; n5 < n3 && i < n4; n5 += Character.charCount(n2), i += Character.charCount(n)) {
            n2 = string.codePointAt(n5);
            n = string2.codePointAt(i);
            int n6 = this.compare(n2, n);
            if (n6 == 0) continue;
            return n6;
        }
        return n3 == n4 ? 0 : (n3 < n4 ? -1 : 1);
    }

    @Override
    protected int compareElements(Bib2GlsEntry bib2GlsEntry, Bib2GlsEntry bib2GlsEntry2) {
        String string = bib2GlsEntry.getFieldValue(this.sortStorageField);
        String string2 = bib2GlsEntry2.getFieldValue(this.sortStorageField);
        return this.compare(string, string2);
    }
}

