/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public class IndexLocation
implements TeXObject {
    private byte type = 0;
    private TeXObject format;
    private TeXObject location;
    public static final byte NORMAL = 0;
    public static final byte OPEN = 1;
    public static final byte CLOSE = 2;

    public IndexLocation(TeXObject teXObject) {
        this(null, teXObject, 0);
    }

    public IndexLocation(TeXObject teXObject, TeXObject teXObject2) {
        this(teXObject, teXObject2, 0);
    }

    public IndexLocation(TeXObject teXObject, TeXObject teXObject2, byte by) {
        this.format = teXObject;
        this.location = teXObject2;
        this.setType(by);
    }

    @Override
    public Object clone() {
        return new IndexLocation(this.format == null ? null : (TeXObject)this.format.clone(), (TeXObject)this.location.clone(), this.type);
    }

    public void setType(byte by) {
        switch (by) {
            case 0: 
            case 1: 
            case 2: {
                this.type = by;
                return;
            }
        }
        throw new IllegalArgumentException("Invalid location type: " + by);
    }

    public byte getType() {
        return this.type;
    }

    public TeXObject getFormat() {
        return this.format;
    }

    public TeXObject getLocation() {
        return this.location;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof IndexLocation)) {
            return false;
        }
        IndexLocation indexLocation = (IndexLocation)object;
        if (this.type != indexLocation.type) {
            return false;
        }
        if (this.format == null ^ indexLocation.format == null) {
            return false;
        }
        if (this.format != indexLocation.format || !this.format.equals(indexLocation.format)) {
            return false;
        }
        if (this.location == null ^ indexLocation.location == null) {
            return false;
        }
        if (this.location == indexLocation.location) {
            return true;
        }
        return this.location.equals(indexLocation.location);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        if (this.format == null) {
            this.location.process(teXParser);
            return;
        }
        if (this.location instanceof TeXObjectList && !(this.location instanceof Group)) {
            Group group = teXParser.getListener().createGroup();
            group.addAll((TeXObjectList)this.location);
            teXParser.push(group);
        } else {
            teXParser.push(this.location);
        }
        this.format.process(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.format == null) {
            this.location.process(teXParser, teXObjectList);
            return;
        }
        if (this.location instanceof TeXObjectList && !(this.location instanceof Group)) {
            Group group = teXParser.getListener().createGroup();
            group.addAll((TeXObjectList)this.location);
            teXObjectList.push(group);
        } else {
            teXObjectList.push(this.location);
        }
        this.format.process(teXParser, teXObjectList);
    }

    @Override
    public boolean isPar() {
        return false;
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        if (this.format == null) {
            return this.location.string(teXParser);
        }
        TeXObjectList teXObjectList = this.format.string(teXParser);
        teXObjectList.add(teXParser.getListener().getOther(teXParser.getBgChar()));
        teXObjectList.addAll(this.location.string(teXParser));
        teXObjectList.add(teXParser.getListener().getOther(teXParser.getEgChar()));
        return teXObjectList;
    }

    @Override
    public String toString(TeXParser teXParser) {
        if (this.format == null) {
            return this.location.toString(teXParser);
        }
        return String.format("%s%c%s%c", this.format.toString(teXParser), teXParser.getBgChar(), this.location.toString(teXParser), teXParser.getEgChar());
    }

    public String toString() {
        return String.format("IndexLocation[type=%d,format=%s,location=%s]", this.type, this.format.toString(), this.location.toString());
    }

    @Override
    public String format() {
        if (this.format == null) {
            return this.location.format();
        }
        return String.format("%s{%s}", this.format.format(), this.location.format());
    }
}

