/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.gls2bib;

import com.dickimawbooks.gls2bib.Gls2BibException;
import java.text.ChoiceFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Properties;

public class Gls2BibMessages
extends Hashtable<String, MessageFormat> {
    public Gls2BibMessages(Properties properties) throws Gls2BibException {
        super(properties.isEmpty() ? 10 : properties.size());
        for (Object object : properties.keySet()) {
            try {
                this.put((String)object, new MessageFormat((String)properties.get(object)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new Gls2BibException(String.format("Property '%s': Invalid message format: %s", object, illegalArgumentException.getMessage()), illegalArgumentException);
            }
        }
    }

    public String getMessage(String string, Object ... objectArray) {
        MessageFormat messageFormat = (MessageFormat)this.get(string);
        if (messageFormat == null) {
            throw new IllegalArgumentException("Invalid message label: " + string);
        }
        return messageFormat.format(objectArray);
    }

    public String getChoiceMessage(String string, int n, String string2, int n2, Object ... objectArray) {
        Object object;
        String[] stringArray = new String[n2];
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            object = String.format("message.%d.%s", i, string2);
            MessageFormat messageFormat = (MessageFormat)this.get(object);
            if (messageFormat == null) {
                throw new IllegalArgumentException("Invalid message label: " + (String)object);
            }
            stringArray[i] = messageFormat.toPattern();
            dArray[i] = i;
        }
        MessageFormat messageFormat = (MessageFormat)this.get(string);
        if (messageFormat == null) {
            throw new IllegalArgumentException("Invalid message label: " + string);
        }
        object = new ChoiceFormat(dArray, stringArray);
        messageFormat.setFormatByArgumentIndex(n, (Format)object);
        return messageFormat.format(objectArray);
    }
}

