#!/bin/bash
#
# This file is a part of the CM-LGC font package
# version 0.5 (May 07, 2005)
#
# Copyright (c) 2003--2005 Alexej Kryukov <basileia@yandex.ru>.
# 
# This package is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# As a special exception, permission is granted to include these font
# programs in a Postscript or PDF file that consists of a document that
# contains text to be displayed or printed using these fonts, regardless
# of the conditions or license applying to the document itself.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

CUR_DIR=$PWD
FONT_DIR=$CUR_DIR/output
SCRIPTS_DIR=$CUR_DIR/bin

cd $FONT_DIR

for font in fcm*.pfb; do
    echo "processing $font..."
    t1disasm $font > ${font%.pfb}.t1a
    $SCRIPTS_DIR/t1toinf.pl ${font%.pfb}.afm -t ${font%.pfb}.t1a -s true ${font%.pfb}.inf
    rm ${font%.pfb}.t1a
done

for font in fcs*.pfb; do
    echo "processing $font..."
    t1disasm $font > ${font%.pfb}.t1a
    $SCRIPTS_DIR/t1toinf.pl ${font%.pfb}.afm -t ${font%.pfb}.t1a -s false ${font%.pfb}.inf
    rm ${font%.pfb}.t1a
done

for font in fct*.pfb; do
    echo "processing $font..."
    t1disasm $font > ${font%.pfb}.t1a
    $SCRIPTS_DIR/t1toinf.pl ${font%.pfb}.afm -t ${font%.pfb}.t1a -s true ${font%.pfb}.inf
    rm ${font%.pfb}.t1a
done

exit 0
