/**
 * \cond LICENSE
 * Arara -- the cool TeX automation tool
 * Copyright (c) 2012, Paulo Roberto Massa Cereda
 * All rights reserved.
 *
 * Redistribution and  use in source  and binary forms, with  or without
 * modification, are  permitted provided  that the  following conditions
 * are met:
 *
 * 1. Redistributions  of source  code must  retain the  above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form  must reproduce the above copyright
 * notice, this list  of conditions and the following  disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. Neither  the name  of the  project's author nor  the names  of its
 * contributors may be used to  endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS  PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS
 * "AS IS"  AND ANY  EXPRESS OR IMPLIED  WARRANTIES, INCLUDING,  BUT NOT
 * LIMITED  TO, THE  IMPLIED WARRANTIES  OF MERCHANTABILITY  AND FITNESS
 * FOR  A PARTICULAR  PURPOSE  ARE  DISCLAIMED. IN  NO  EVENT SHALL  THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY,  OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT  NOT LIMITED  TO, PROCUREMENT  OF SUBSTITUTE  GOODS OR  SERVICES;
 * LOSS  OF USE,  DATA, OR  PROFITS; OR  BUSINESS INTERRUPTION)  HOWEVER
 * CAUSED AND  ON ANY THEORY  OF LIABILITY, WHETHER IN  CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY
 * WAY  OUT  OF  THE USE  OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE
 * POSSIBILITY OF SUCH DAMAGE.
 * \endcond
 * 
 * AraraConstants: This class contains all the constants used in the main
 * application.
 */
// package definition
package com.github.arara.utils;

/**
 * Contains all the constants used in the main application.
 * 
 * @author Paulo Roberto Massa Cereda
 * @version 3.0a
 * @since 3.0
 */
public class AraraConstants {
    
    /**
     * The arara version.
     */
    public static final String VERSION = "3.0a";
    /**
     * The number of characters per line in messages.
     */
    public static final int WRAPLENGTH = 65;
    /**
     * The name of the default configuration file.
     */
    public static final String ARARACONFIG = "araraconfig.yaml";
    /**
     * The directive prefix for the pattern matching method.
     */
    public static final String DIRECTIVEPREFIX = "arara:\\s";
    /**
     * The rule pattern for string reference.
     */
    public static final String RULEPATTERN = "^(\\s)*<arara>\\s";
    /**
     * The name of the log file generated by arara.
     */
    public static final String LOGNAME = "arara";
    /**
     * The copyright year.
     */
    public static final String COPYRIGHTYEAR = "2012";
    /**
     * The variable exception matching pattern.
     */
    public static final String VAREXCEPTIONPATTERN = "^\\[Error: could not access: (.*);";
    /**
     * The method exception matching pattern.
     */
    public static final String METHODEXCEPTIONPATTERN = "^\\[Error: unable to access property \\((.*)\\): (.*)\\]";
    /**
     * The full directive matching pattern.
     */
    public static final String FULLDIRECTIVEPATTERN = "^\\s*(\\w+)\\s*:\\s*\\{.*\\}\\s*$";
    /**
     * The empty directive matching pattern.
     */
    public static final String EMPTYDIRECTIVEPATTERN = "^\\s*(\\w+)\\s*$";
    
}
