---
myst:
  html_meta:
    keywords: LaTeX, programmation, erreurs, messages d'erreur de LaTeX,
              problème d'environnement, \begin et \end
---

# Que signifie l'erreur : "`\begin{⟨env⟩}` on input line ⟨num-ligne⟩ ended by `\end{⟨autre-env⟩}`" ?

- **Message** : `\begin{⟨env⟩} on input line ⟨num-ligne⟩ ended by \end{⟨autre-env⟩}`
- **Origine** : LaTeX

LaTeX indique cette erreur lorsqu'il voit que l'environnement `⟨env⟩` 
se termine par le code de terminaison de l'environnement `⟨autre-env⟩`. 
La plupart du temps, cette erreur est due à l'oubli du `\end{⟨env⟩}`. 
Une autre possibilité pour obtenir cette erreur est d'essayer d'utiliser
les environnements de type verbatim ou un environnement 
hors-texte <ctanpkg:mathtools> (ou <ctanpkg:amsmath>) à l'intérieur 
de la définition d'un environnement créé par l'utilisateur, 
ce qui est souvent impossible.

S'il ne s'agit d'aucun des cas précédents et que vous êtes absolument certain
que tous les environnements sont convenablement emboîtés alors, quelque part
entre le début de `⟨env⟩` et l'endroit où se situe l'erreur, doit se trouver
une commande qui engendre un `\endgroup` sans `\begingroup` antérieur 
correspondant, ce qui fait croire à LaTeX que l'environnement `⟨env⟩` 
prend fin à cet endroit.

Pour trouver l'origine du problème, vous pouvez déplacer la commande d
e fin d'environnement, en la rapprochant du départ de celui-ci, 
jusqu'à ce que le problème disparaisse.


:::{seealso}
La section 
[Verbatim](/4_domaines_specialises/sciences/informatique/verbatim/start) 
présente différentes extensions et méthodes pour mieux gérer les anomalies
liées au mode verbatim. Le *LaTeX Companion* présente, pour sa part, 
une section de plusieurs pages dédiée à l'extension <ctanpkg:fancyvrb>.
:::


:::{sources}
- [FAQ erreurs - Lettre B](https://latex.developpez.com/faq/erreurs?page=B), 
  sur le site [Developpez.com](https://latex.developpez.com)
- *[LaTeX Companion](https://www.latex-project.org/help/books/#french)*, 
  2e édition, Frank Mittelbach, Michel Goossens, Johannes Braams, 
  David Carlisle, Chris Rowley (Pearson, 2006)
:::