---
myst:
  html_meta:
    keywords: LaTeX,flottants
---

# Flottants


Ce thème regroupe les questions portant sur les *flottants*. Ces
derniers sont des tables, des figures ou autres éléments accompagnant le
[texte](/3_composition/texte/start) et dont le placement dans le
document final est pris en charge par LaTeX, en application de
différentes règles de présentation (par exemple, ne pas mettre trop de
flottants sur une même page). Le fait que l'emplacement de ces éléments
n'est pas stabilisé tant que le document n'est pas finalisé leur a
donné ce nom de flottants : ils peuvent en effet bouger assez facilement
tant que le document et son contenu évolue.

Deux sujets propres aux flottants font l'objet de pages dédiées :

-   [Légendes](/3_composition/flottants/legendes/start) ;
-   [Positionnement des
    flottants](/3_composition/flottants/positionnement/start)

## Création et gestion de flottants

-   [Comment gérer proprement les flottants dans LaTeX ?](/3_composition/flottants/pourquoi_faire_flotter_ses_figures_et_tableaux)
-   [Comment générer une liste des flottants ?](/3_composition/flottants/listes_des_flottants)
-   [Comment définir de nouveaux flottants ?](/3_composition/flottants/definir_de_nouveaux_flottants)
-   [Comment mettre un commentaire à côté d'un flottant ?](/3_composition/flottants/mettre_un_commentaire_a_cote_d_une_figure)
-   [Comment habiller une image ou une citation avec du texte ?](/3_composition/flottants/habiller_une_image_avec_du_texte)
-   [Comment mettre des flottants sur des pages en vis-à-vis ?](/3_composition/flottants/mettre_des_flottants_en_vis_a_vis)

## Style des flottants

-   [Pourquoi ma figure (ou mon tableau) n'est-elle pas centrée ?](/3_composition/flottants/flottant_non_centre)
-   [Comment centrer une figure ou une table très large ?](/3_composition/flottants/centrer_un_flottant_tres_large)
-   [Comment encadrer un objet flottant ?](/3_composition/flottants/encadrer_un_flottant)
-   [Comment isoler les flottants par un filet horizontal ?](/3_composition/flottants/separer_les_flottants_du_texte_par_un_trait)
-   [Comment modifier l'orientation de flottants ?](/3_composition/flottants/changer_l_orientation_d_un_flottant)
-   [Comment changer l'agencement vertical des pages de flottants ?](/3_composition/flottants/composition_verticale_d_une_page_de_flottants)
-   [Comment supprimer l'espace en trop autour des flottants ?](/3_composition/flottants/trop_d_espace_dans_un_flottant)

## Gestion des flottants dans des documents à plusieurs colonnes

-   [Comment insérer des flottants dans un document multicolonne ?](/3_composition/flottants/inserer_des_figures_dans_un_environnement_multicols)
-   [Comment insérer une figure large dans un document en deux colonnes ?](/3_composition/flottants/inserer_des_figures_dans_un_environnement_multicol3)
-   [Pourquoi les flottants sont-ils numérotés dans le désordre en mode
    deux colonnes ?](/3_composition/flottants/flottants_dans_le_desordre_en_mode_deux_colonnes)
-   [Comment mettre des flottants en bas de page en mode deux colonnes ?](/3_composition/flottants/placer_les_flottants_en_bas_de_page_en_mode_deux_colonnes)

## Gestion des sous-figures

-   [Comment découper une figure en plusieurs sous-figures ?](/3_composition/flottants/sous-figures)
-   [Comment gérer des sous-figures sur plusieurs pages ?](/3_composition/flottants/sous-figures_sur_plusieurs_pages)

```{toctree}
:glob: true
:maxdepth: 1
:hidden:

*/start
*
```
