---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, paramètres de page
---

# Comment modifier les paramètres de page ?

Changer la mise en page d'un document implique de tenir compte 
de nombreuses subtilités peu évidentes pour un débutant. Il existe en effet
des interactions entre :

- les contraintes fondamentales de TeX ;
- les contraintes liées à la conception de LaTeX ;
- et les bonnes pratiques de composition et de conception.

Ceci signifie que tout changement doit être très attentivement considéré, 
pour s'assurer d'une part qu'il fonctionne et d'autre part que le résultat 
est visuellement satisfaisant.

Si, pour un débutant, les valeurs par défaut de LaTeX semblent parfois 
excessivement conservatrices, il y a de bonnes raisons derrière ces réglages. 
Même Leslie Lamport, dans son livre 
*[LaTeX, a Document Preparation System](/1_generalites/documentation/livres/documents_sur_latex)*, 
suggère d'éviter de toucher à ces réglages. Et à ceux qui voudraient 
tout de même faire des modifications, il ajoute : "tout ce que je peux faire 
ici est de vous mettre en garde contre l'erreur très courante de créer 
des lignes trop larges pour être lues facilement --- une erreur 
que vous ne ferez pas si vous suivez cette suggestion : utilisez des lignes 
qui ne contiennent pas plus de 75 caractères, y compris la ponctuation 
et les espaces.".

Nous vous recommandons d'utiliser une extension pour établir des jeux 
de paramètres cohérents car chaque extension prend en charge les interrelations 
sans que vous *ayez* besoin d'y penser. 
Ces extensions, présentées ci-après, sont aussi évoquées à la question 
"[](/3_composition/texte/pages/parametres_de_page/extensions_pour_modifier_les_parametres_de_page)".
Rappelez-vous cependant que les extensions fournissent des mécanismes cohérents
et fonctionnels : elles n'analysent jamais la qualité typographique 
de ce que vous faites.


## Modifier la page avec une extension dédiée

C'est la méthode recommandée pour ne pas avoir à traiter les interactions
évoquées ci-avant.

Cette page en cite quelques unes mais vous pouvez aussi consulter 
la page dédiée : 
"[](/3_composition/texte/pages/parametres_de_page/extensions_pour_modifier_les_parametres_de_page)".


### Avec l'extension <ctanpkg:geometry>

L'extension <ctanpkg:geometry> propose des fonctionnalités très pratiques 
pour définir son propre format de page, sans avoir à modifier directement 
les grandeurs citées plus haut. Elle définit de nouvelles variables 
de structure de la page. Elle propose en outre un ensemble de formats 
par défaut (`a0paper`, `b5paper`, `legalpaper`...). Pour plus de détails, 
consultez la question 
"[](/3_composition/texte/pages/parametres_de_page/configurer_la_taille_du_papier)".


### Avec les extensions <ctanpkg:a4> et <ctanpkg:a4wide> 

:::{warning}
Les extensions <ctanpkg:a4> et <ctanpkg:a4wide> sont classées comme 
[obsolètes](/1_generalites/histoire/liste_des_packages_obsoletes). 
Ce qui suit n'a donc qu'un intérêt historique. Il est maintenant conseillé 
d'utiliser <ctanpkg:geometry> (voir ci-dessus). Si vous utilisiez <ctanpkg:a4wide> 
par le passé, vous pouvez la remplacer simplement par :

```{noedit}
\usepackage[a4paper,margin=1in,includeheadfoot]{geometry}
```
:::

Si votre installation de LaTeX utilise du format *letter* par défaut 
(format de papier américain), vous pouvez charger l'extension <ctanpkg:a4> 
pour retrouver le format A4 usuel en Europe. Si vous trouvez les marges 
trop grandes, l'extension <ctanpkg:a4wide> les réduira (à une largeur 
de 1 pouce), en même temps qu'elle passera en format A4.


## Modifier la page avec les commandes de base

Cette méthode demande de bien connaître les relations entre les éléments 
de la page. Elle se base sur la redéfinition des grandeurs citées plus haut 
avec la commande `\setlength{⟨grandeur⟩}{⟨dimension⟩}`.

L'exemple ci-dessous illustre une modification qui, malencontreusement, 
ne donnera pas une mise en page satisfaisante. La zone des notes marginales, 
comme le montre <ctanpkg:layout>, est en effet partiellement hors de la page.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{layout}

  \setlength{\textwidth}{450pt}
  \setlength{\oddsidemargin}{32pt}

\begin{document}
\layout
\end{document}
```


:::{sources}
[How to set up page layout "by hand"](faquk:FAQ-marginmanual)
:::