---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, paragraphes, texte dans une forme, 
              disque, étoile, losange
---

# Comment écrire du texte en forme de losange ou autre ?

## Avec l'extension <ctanpkg:shapepar>

L'extension <ctanpkg:shapepar> définit plusieurs commandes pour écrire 
des paragraphes dans des formes :

- `\diamondpar` pour un losange ;
- `\heartpar` pour un cœur ;
- `\starpar` pour une étoile à cinq branches ;
- `\circlepar` pour un disque ;
- et bien d'autres, d'autant plus que l'extension permet de définir 
  des formes personnalisées.

Voici un exemple pour le losange :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{shapepar}

\begin{document}
\diamondpar{Mon si beau paragraphe en forme de losange (vous imaginez 
bien que c'est plus joli quand le paragraphe est assez long).}
\end{document}
```