---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, paragraphes, indentation, 
              titre de sectionnement
---

# Comment changer l'indentation du premier paragraphe après un titre de sectionnement ?

LaTeX implémente un style qui n'indente pas le premier paragraphe 
après un titre de sectionnement (un titre de section par exemple). 
Mais ce comportement peut être modifié. Pour montrer comment, 
voici un exemple de ce que restitue LaTeX par défaut :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\section{Indentation}
En typographie, une indentation correspond à un retrait de la première ligne
d'un paragraphe.

Son utilisation est la norme en typographie française mais pas une typographie
anglo-saxonne.
\end{document}
```

## Avec l'extension <ctanpkg:indentfirst>

La très courte extension <ctanpkg:indentfirst>, de David Carlisle, supprime 
ce mécanisme. Cela donne sur notre exemple le résultat suivant :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{indentfirst}

\begin{document}
\section{Indentation}
En typographie, une indentation correspond à un retrait de la première ligne
d'un paragraphe.

Son utilisation est la norme en typographie française mais pas une typographie
anglo-saxonne.
\end{document}
```


## Avec l'extension <ctanpkg:babel> et son option `french`

Pour un document de langue française, l'extension <ctanpkg:babel> 
avec son option [french](ctanpkg:babel-french) procéde automatiquement 
à cette modification. Ce qui conduit à :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\section{Indentation}
En typographie, une indentation correspond à un retrait de la première ligne
d'un paragraphe.

Son utilisation est la norme en typographie française mais pas une typographie
anglo-saxonne.
\end{document}
```


## Avec l'extension <ctanpkg:polyglossia> et le français comme langue principale

L'extension <ctanpkg:polyglossia> gère l'indentation des premiers paragraphes 
pour le français de la même panière que <ctanpkg:babel>.

```
%!TEX engine=lualatex
\documentclass{article}
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{polyglossia}
  \setmainlanguage{french}

\begin{document}
\section{Indentation}
En typographie, une indentation correspond à un retrait de la première ligne
d'un paragraphe.

Son utilisation est la norme en typographie française mais pas une typographie
anglo-saxonne.
\end{document}
```


:::{sources}
[Indent after section headings](faquk:FAQ-secindent)
:::