---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symbole, caractères, phonétique
---

# Comment obtenir les symboles phonétiques (de l'API) ?

Les symboles de l’[alphabet typographique international](wpfr:Alphabet_phonétique_international) 
(API) peuvent être obtenus avec deux méthodes différentes selon les outils que vous utilisez.

## Pour LaTeX

### Avec l'extension <ctanpkg:tipa>

L'extension <ctanpkg:tipa>, très complète, permet d’obtenir des symboles phonétiques. 
En complément, l'extension <ctanpkg:engpron>, basée sur <ctanpkg:tipa>, 
facilite la saisie de la prononciation de l’anglais et de l’américain.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{tipa}

\begin{document}
Voici un exemple d'écriture phonétique, celle de l'expression anglaise
\emph{science fiction} : \textipa{/""saI@ns fIkS@n/}.
\end{document}
```


### Avec l'extension <ctanpkg:phonetic>

L'extension <ctanpkg:phonetic> fournit également un certain nombre de symboles phonétiques...
mais pas tous. Vous devrez donc procéder à quelques approximations comme dans l'exemple ci-dessous,
ce qui rend cette extension moins intéressante que <ctanpkg:tipa>.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}  % Encodage T1 (adapté au français)
  \usepackage{lmodern}      % Caractères plus lisibles
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \usepackage{phonetic}

\begin{document}
Voici un exemple d'écriture phonétique, celle de l'expression anglaise
\emph{science fiction} : /\syl{~}sa{\scriptsize I}\schwa ns 
f{\scriptsize I}k\esh \schwa n/. 

L'écriture est ici assez approximative : la 
taille du \frquote{{\scriptsize I}} tout comme la largeur de l'accent 
secondaire ne sont pas tout à fait satisfaisantes.
\end{document}
```


## Pour XeLaTeX et LuaLaTeX

L'utilisation directe de l'unicode avec XeLaTeX et LuaLaTeX offre une autre solution : 
celle de saisir directement les symboles phonétiques dans son texte. 
L'extension <ctanpkg:tipa> peut aussi être utilisée dans ce cas 
(dans la mesure où elle permet des facilités de saisie).

```
\documentclass[french]{article}
  \usepackage{babel}        % Réglages linguistiques (avec french)
  \usepackage{fontspec}     % Gestion des fontes pour XeLaTeX/LuaLaTeX
  \pagestyle{empty}         % N'affiche pas de numéro de page
  \setmainfont{Doulos SIL}

\begin{document}
Voici un exemple d'écriture phonétique, celle de l'expression anglaise
\emph{science fiction} : /ˈsaɪəns ˌfɪkʃən/.
\end{document}
```