#ifndef STREAMVBYTE_SHUFFLE_TABLES_ENCODE_H
#define STREAMVBYTE_SHUFFLE_TABLES_ENCODE_H
#include "streamvbyte_isadetection.h"

#include <stdint.h>
#ifdef STREAMVBYTE_X64
// encoding:
static const uint8_t shuf_lut[64*16] = {
	0x00, 0x04, 0x08, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x04, 0x08, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x04, 0x08, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x08, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x04, 0x05, 0x08, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x04, 0x05, 0x08, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x04, 0x05, 0x08, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x08, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x04, 0x05, 0x06, 0x08, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x04, 0x05, 0x06, 0x08, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x08, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
	0x00, 0x04, 0x08, 0x09, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x04, 0x08, 0x09, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x04, 0x08, 0x09, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x08, 0x09, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x04, 0x05, 0x08, 0x09, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x04, 0x05, 0x08, 0x09, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x04, 0x05, 0x08, 0x09, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x08, 0x09, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
	0x00, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
	0x00, 0x04, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x04, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x04, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x04, 0x05, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x04, 0x05, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x04, 0x05, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
	0x00, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
	0x00, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF,
	0x00, 0x04, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x04, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x04, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
	0x00, 0x04, 0x05, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x04, 0x05, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x04, 0x05, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
	0x00, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF,
	0x00, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF, 0xFF,
	0x00, 0x01, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF, 0xFF,
	0x00, 0x01, 0x02, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F, 0xFF,
	0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F
};


static const uint8_t len_lut[256] = {
	 4,  5,  6,  7,  5,  6,  7,  8,  6,  7,  8,  9,  7,  8,  9, 10,
	 5,  6,  7,  8,  6,  7,  8,  9,  7,  8,  9, 10,  8,  9, 10, 11,
	 6,  7,  8,  9,  7,  8,  9, 10,  8,  9, 10, 11,  9, 10, 11, 12,
	 7,  8,  9, 10,  8,  9, 10, 11,  9, 10, 11, 12, 10, 11, 12, 13,
	 5,  6,  7,  8,  6,  7,  8,  9,  7,  8,  9, 10,  8,  9, 10, 11,
	 6,  7,  8,  9,  7,  8,  9, 10,  8,  9, 10, 11,  9, 10, 11, 12,
	 7,  8,  9, 10,  8,  9, 10, 11,  9, 10, 11, 12, 10, 11, 12, 13,
	 8,  9, 10, 11,  9, 10, 11, 12, 10, 11, 12, 13, 11, 12, 13, 14,
	 6,  7,  8,  9,  7,  8,  9, 10,  8,  9, 10, 11,  9, 10, 11, 12,
	 7,  8,  9, 10,  8,  9, 10, 11,  9, 10, 11, 12, 10, 11, 12, 13,
	 8,  9, 10, 11,  9, 10, 11, 12, 10, 11, 12, 13, 11, 12, 13, 14,
	 9, 10, 11, 12, 10, 11, 12, 13, 11, 12, 13, 14, 12, 13, 14, 15,
	 7,  8,  9, 10,  8,  9, 10, 11,  9, 10, 11, 12, 10, 11, 12, 13,
	 8,  9, 10, 11,  9, 10, 11, 12, 10, 11, 12, 13, 11, 12, 13, 14,
	 9, 10, 11, 12, 10, 11, 12, 13, 11, 12, 13, 14, 12, 13, 14, 15,
	10, 11, 12, 13, 11, 12, 13, 14, 12, 13, 14, 15, 13, 14, 15, 16,
};
#endif
#ifdef STREAMVBYTE_ARM
static int8_t encodingShuffleTable[256][16] = {
 {  0,  4,  8, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1111
 {  0,  1,  4,  8, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2111
 {  0,  1,  2,  4,  8, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 3111
 {  0,  1,  2,  3,  4,  8, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 4111
 {  0,  4,  5,  8, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1211
 {  0,  1,  4,  5,  8, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2211
 {  0,  1,  2,  4,  5,  8, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 3211
 {  0,  1,  2,  3,  4,  5,  8, 12, -1, -1, -1, -1, -1, -1, -1, -1 },    // 4211
 {  0,  4,  5,  6,  8, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1311
 {  0,  1,  4,  5,  6,  8, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2311
 {  0,  1,  2,  4,  5,  6,  8, 12, -1, -1, -1, -1, -1, -1, -1, -1 },    // 3311
 {  0,  1,  2,  3,  4,  5,  6,  8, 12, -1, -1, -1, -1, -1, -1, -1 },    // 4311
 {  0,  4,  5,  6,  7,  8, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1411
 {  0,  1,  4,  5,  6,  7,  8, 12, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2411
 {  0,  1,  2,  4,  5,  6,  7,  8, 12, -1, -1, -1, -1, -1, -1, -1 },    // 3411
 {  0,  1,  2,  3,  4,  5,  6,  7,  8, 12, -1, -1, -1, -1, -1, -1 },    // 4411
 {  0,  4,  8,  9, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1121
 {  0,  1,  4,  8,  9, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2121
 {  0,  1,  2,  4,  8,  9, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 3121
 {  0,  1,  2,  3,  4,  8,  9, 12, -1, -1, -1, -1, -1, -1, -1, -1 },    // 4121
 {  0,  4,  5,  8,  9, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1221
 {  0,  1,  4,  5,  8,  9, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2221
 {  0,  1,  2,  4,  5,  8,  9, 12, -1, -1, -1, -1, -1, -1, -1, -1 },    // 3221
 {  0,  1,  2,  3,  4,  5,  8,  9, 12, -1, -1, -1, -1, -1, -1, -1 },    // 4221
 {  0,  4,  5,  6,  8,  9, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1321
 {  0,  1,  4,  5,  6,  8,  9, 12, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2321
 {  0,  1,  2,  4,  5,  6,  8,  9, 12, -1, -1, -1, -1, -1, -1, -1 },    // 3321
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 12, -1, -1, -1, -1, -1, -1 },    // 4321
 {  0,  4,  5,  6,  7,  8,  9, 12, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1421
 {  0,  1,  4,  5,  6,  7,  8,  9, 12, -1, -1, -1, -1, -1, -1, -1 },    // 2421
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 12, -1, -1, -1, -1, -1, -1 },    // 3421
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 12, -1, -1, -1, -1, -1 },    // 4421
 {  0,  4,  8,  9, 10, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1131
 {  0,  1,  4,  8,  9, 10, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2131
 {  0,  1,  2,  4,  8,  9, 10, 12, -1, -1, -1, -1, -1, -1, -1, -1 },    // 3131
 {  0,  1,  2,  3,  4,  8,  9, 10, 12, -1, -1, -1, -1, -1, -1, -1 },    // 4131
 {  0,  4,  5,  8,  9, 10, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1231
 {  0,  1,  4,  5,  8,  9, 10, 12, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2231
 {  0,  1,  2,  4,  5,  8,  9, 10, 12, -1, -1, -1, -1, -1, -1, -1 },    // 3231
 {  0,  1,  2,  3,  4,  5,  8,  9, 10, 12, -1, -1, -1, -1, -1, -1 },    // 4231
 {  0,  4,  5,  6,  8,  9, 10, 12, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1331
 {  0,  1,  4,  5,  6,  8,  9, 10, 12, -1, -1, -1, -1, -1, -1, -1 },    // 2331
 {  0,  1,  2,  4,  5,  6,  8,  9, 10, 12, -1, -1, -1, -1, -1, -1 },    // 3331
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 10, 12, -1, -1, -1, -1, -1 },    // 4331
 {  0,  4,  5,  6,  7,  8,  9, 10, 12, -1, -1, -1, -1, -1, -1, -1 },    // 1431
 {  0,  1,  4,  5,  6,  7,  8,  9, 10, 12, -1, -1, -1, -1, -1, -1 },    // 2431
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 10, 12, -1, -1, -1, -1, -1 },    // 3431
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 12, -1, -1, -1, -1 },    // 4431
 {  0,  4,  8,  9, 10, 11, 12, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1141
 {  0,  1,  4,  8,  9, 10, 11, 12, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2141
 {  0,  1,  2,  4,  8,  9, 10, 11, 12, -1, -1, -1, -1, -1, -1, -1 },    // 3141
 {  0,  1,  2,  3,  4,  8,  9, 10, 11, 12, -1, -1, -1, -1, -1, -1 },    // 4141
 {  0,  4,  5,  8,  9, 10, 11, 12, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1241
 {  0,  1,  4,  5,  8,  9, 10, 11, 12, -1, -1, -1, -1, -1, -1, -1 },    // 2241
 {  0,  1,  2,  4,  5,  8,  9, 10, 11, 12, -1, -1, -1, -1, -1, -1 },    // 3241
 {  0,  1,  2,  3,  4,  5,  8,  9, 10, 11, 12, -1, -1, -1, -1, -1 },    // 4241
 {  0,  4,  5,  6,  8,  9, 10, 11, 12, -1, -1, -1, -1, -1, -1, -1 },    // 1341
 {  0,  1,  4,  5,  6,  8,  9, 10, 11, 12, -1, -1, -1, -1, -1, -1 },    // 2341
 {  0,  1,  2,  4,  5,  6,  8,  9, 10, 11, 12, -1, -1, -1, -1, -1 },    // 3341
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 10, 11, 12, -1, -1, -1, -1 },    // 4341
 {  0,  4,  5,  6,  7,  8,  9, 10, 11, 12, -1, -1, -1, -1, -1, -1 },    // 1441
 {  0,  1,  4,  5,  6,  7,  8,  9, 10, 11, 12, -1, -1, -1, -1, -1 },    // 2441
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 10, 11, 12, -1, -1, -1, -1 },    // 3441
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, -1, -1, -1 },    // 4441
 {  0,  4,  8, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1112
 {  0,  1,  4,  8, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2112
 {  0,  1,  2,  4,  8, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 3112
 {  0,  1,  2,  3,  4,  8, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1 },    // 4112
 {  0,  4,  5,  8, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1212
 {  0,  1,  4,  5,  8, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2212
 {  0,  1,  2,  4,  5,  8, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1 },    // 3212
 {  0,  1,  2,  3,  4,  5,  8, 12, 13, -1, -1, -1, -1, -1, -1, -1 },    // 4212
 {  0,  4,  5,  6,  8, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1312
 {  0,  1,  4,  5,  6,  8, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2312
 {  0,  1,  2,  4,  5,  6,  8, 12, 13, -1, -1, -1, -1, -1, -1, -1 },    // 3312
 {  0,  1,  2,  3,  4,  5,  6,  8, 12, 13, -1, -1, -1, -1, -1, -1 },    // 4312
 {  0,  4,  5,  6,  7,  8, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1412
 {  0,  1,  4,  5,  6,  7,  8, 12, 13, -1, -1, -1, -1, -1, -1, -1 },    // 2412
 {  0,  1,  2,  4,  5,  6,  7,  8, 12, 13, -1, -1, -1, -1, -1, -1 },    // 3412
 {  0,  1,  2,  3,  4,  5,  6,  7,  8, 12, 13, -1, -1, -1, -1, -1 },    // 4412
 {  0,  4,  8,  9, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1122
 {  0,  1,  4,  8,  9, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2122
 {  0,  1,  2,  4,  8,  9, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1 },    // 3122
 {  0,  1,  2,  3,  4,  8,  9, 12, 13, -1, -1, -1, -1, -1, -1, -1 },    // 4122
 {  0,  4,  5,  8,  9, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1222
 {  0,  1,  4,  5,  8,  9, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2222
 {  0,  1,  2,  4,  5,  8,  9, 12, 13, -1, -1, -1, -1, -1, -1, -1 },    // 3222
 {  0,  1,  2,  3,  4,  5,  8,  9, 12, 13, -1, -1, -1, -1, -1, -1 },    // 4222
 {  0,  4,  5,  6,  8,  9, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1322
 {  0,  1,  4,  5,  6,  8,  9, 12, 13, -1, -1, -1, -1, -1, -1, -1 },    // 2322
 {  0,  1,  2,  4,  5,  6,  8,  9, 12, 13, -1, -1, -1, -1, -1, -1 },    // 3322
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 12, 13, -1, -1, -1, -1, -1 },    // 4322
 {  0,  4,  5,  6,  7,  8,  9, 12, 13, -1, -1, -1, -1, -1, -1, -1 },    // 1422
 {  0,  1,  4,  5,  6,  7,  8,  9, 12, 13, -1, -1, -1, -1, -1, -1 },    // 2422
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 12, 13, -1, -1, -1, -1, -1 },    // 3422
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 12, 13, -1, -1, -1, -1 },    // 4422
 {  0,  4,  8,  9, 10, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1132
 {  0,  1,  4,  8,  9, 10, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2132
 {  0,  1,  2,  4,  8,  9, 10, 12, 13, -1, -1, -1, -1, -1, -1, -1 },    // 3132
 {  0,  1,  2,  3,  4,  8,  9, 10, 12, 13, -1, -1, -1, -1, -1, -1 },    // 4132
 {  0,  4,  5,  8,  9, 10, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1232
 {  0,  1,  4,  5,  8,  9, 10, 12, 13, -1, -1, -1, -1, -1, -1, -1 },    // 2232
 {  0,  1,  2,  4,  5,  8,  9, 10, 12, 13, -1, -1, -1, -1, -1, -1 },    // 3232
 {  0,  1,  2,  3,  4,  5,  8,  9, 10, 12, 13, -1, -1, -1, -1, -1 },    // 4232
 {  0,  4,  5,  6,  8,  9, 10, 12, 13, -1, -1, -1, -1, -1, -1, -1 },    // 1332
 {  0,  1,  4,  5,  6,  8,  9, 10, 12, 13, -1, -1, -1, -1, -1, -1 },    // 2332
 {  0,  1,  2,  4,  5,  6,  8,  9, 10, 12, 13, -1, -1, -1, -1, -1 },    // 3332
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 10, 12, 13, -1, -1, -1, -1 },    // 4332
 {  0,  4,  5,  6,  7,  8,  9, 10, 12, 13, -1, -1, -1, -1, -1, -1 },    // 1432
 {  0,  1,  4,  5,  6,  7,  8,  9, 10, 12, 13, -1, -1, -1, -1, -1 },    // 2432
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 10, 12, 13, -1, -1, -1, -1 },    // 3432
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 12, 13, -1, -1, -1 },    // 4432
 {  0,  4,  8,  9, 10, 11, 12, 13, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1142
 {  0,  1,  4,  8,  9, 10, 11, 12, 13, -1, -1, -1, -1, -1, -1, -1 },    // 2142
 {  0,  1,  2,  4,  8,  9, 10, 11, 12, 13, -1, -1, -1, -1, -1, -1 },    // 3142
 {  0,  1,  2,  3,  4,  8,  9, 10, 11, 12, 13, -1, -1, -1, -1, -1 },    // 4142
 {  0,  4,  5,  8,  9, 10, 11, 12, 13, -1, -1, -1, -1, -1, -1, -1 },    // 1242
 {  0,  1,  4,  5,  8,  9, 10, 11, 12, 13, -1, -1, -1, -1, -1, -1 },    // 2242
 {  0,  1,  2,  4,  5,  8,  9, 10, 11, 12, 13, -1, -1, -1, -1, -1 },    // 3242
 {  0,  1,  2,  3,  4,  5,  8,  9, 10, 11, 12, 13, -1, -1, -1, -1 },    // 4242
 {  0,  4,  5,  6,  8,  9, 10, 11, 12, 13, -1, -1, -1, -1, -1, -1 },    // 1342
 {  0,  1,  4,  5,  6,  8,  9, 10, 11, 12, 13, -1, -1, -1, -1, -1 },    // 2342
 {  0,  1,  2,  4,  5,  6,  8,  9, 10, 11, 12, 13, -1, -1, -1, -1 },    // 3342
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 10, 11, 12, 13, -1, -1, -1 },    // 4342
 {  0,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, -1, -1, -1, -1, -1 },    // 1442
 {  0,  1,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, -1, -1, -1, -1 },    // 2442
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, -1, -1, -1 },    // 3442
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, -1, -1 },    // 4442
 {  0,  4,  8, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1113
 {  0,  1,  4,  8, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2113
 {  0,  1,  2,  4,  8, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1, -1 },    // 3113
 {  0,  1,  2,  3,  4,  8, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1 },    // 4113
 {  0,  4,  5,  8, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1213
 {  0,  1,  4,  5,  8, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2213
 {  0,  1,  2,  4,  5,  8, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1 },    // 3213
 {  0,  1,  2,  3,  4,  5,  8, 12, 13, 14, -1, -1, -1, -1, -1, -1 },    // 4213
 {  0,  4,  5,  6,  8, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1313
 {  0,  1,  4,  5,  6,  8, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1 },    // 2313
 {  0,  1,  2,  4,  5,  6,  8, 12, 13, 14, -1, -1, -1, -1, -1, -1 },    // 3313
 {  0,  1,  2,  3,  4,  5,  6,  8, 12, 13, 14, -1, -1, -1, -1, -1 },    // 4313
 {  0,  4,  5,  6,  7,  8, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1 },    // 1413
 {  0,  1,  4,  5,  6,  7,  8, 12, 13, 14, -1, -1, -1, -1, -1, -1 },    // 2413
 {  0,  1,  2,  4,  5,  6,  7,  8, 12, 13, 14, -1, -1, -1, -1, -1 },    // 3413
 {  0,  1,  2,  3,  4,  5,  6,  7,  8, 12, 13, 14, -1, -1, -1, -1 },    // 4413
 {  0,  4,  8,  9, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1123
 {  0,  1,  4,  8,  9, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2123
 {  0,  1,  2,  4,  8,  9, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1 },    // 3123
 {  0,  1,  2,  3,  4,  8,  9, 12, 13, 14, -1, -1, -1, -1, -1, -1 },    // 4123
 {  0,  4,  5,  8,  9, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1223
 {  0,  1,  4,  5,  8,  9, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1 },    // 2223
 {  0,  1,  2,  4,  5,  8,  9, 12, 13, 14, -1, -1, -1, -1, -1, -1 },    // 3223
 {  0,  1,  2,  3,  4,  5,  8,  9, 12, 13, 14, -1, -1, -1, -1, -1 },    // 4223
 {  0,  4,  5,  6,  8,  9, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1 },    // 1323
 {  0,  1,  4,  5,  6,  8,  9, 12, 13, 14, -1, -1, -1, -1, -1, -1 },    // 2323
 {  0,  1,  2,  4,  5,  6,  8,  9, 12, 13, 14, -1, -1, -1, -1, -1 },    // 3323
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 12, 13, 14, -1, -1, -1, -1 },    // 4323
 {  0,  4,  5,  6,  7,  8,  9, 12, 13, 14, -1, -1, -1, -1, -1, -1 },    // 1423
 {  0,  1,  4,  5,  6,  7,  8,  9, 12, 13, 14, -1, -1, -1, -1, -1 },    // 2423
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 12, 13, 14, -1, -1, -1, -1 },    // 3423
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 12, 13, 14, -1, -1, -1 },    // 4423
 {  0,  4,  8,  9, 10, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1133
 {  0,  1,  4,  8,  9, 10, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1 },    // 2133
 {  0,  1,  2,  4,  8,  9, 10, 12, 13, 14, -1, -1, -1, -1, -1, -1 },    // 3133
 {  0,  1,  2,  3,  4,  8,  9, 10, 12, 13, 14, -1, -1, -1, -1, -1 },    // 4133
 {  0,  4,  5,  8,  9, 10, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1 },    // 1233
 {  0,  1,  4,  5,  8,  9, 10, 12, 13, 14, -1, -1, -1, -1, -1, -1 },    // 2233
 {  0,  1,  2,  4,  5,  8,  9, 10, 12, 13, 14, -1, -1, -1, -1, -1 },    // 3233
 {  0,  1,  2,  3,  4,  5,  8,  9, 10, 12, 13, 14, -1, -1, -1, -1 },    // 4233
 {  0,  4,  5,  6,  8,  9, 10, 12, 13, 14, -1, -1, -1, -1, -1, -1 },    // 1333
 {  0,  1,  4,  5,  6,  8,  9, 10, 12, 13, 14, -1, -1, -1, -1, -1 },    // 2333
 {  0,  1,  2,  4,  5,  6,  8,  9, 10, 12, 13, 14, -1, -1, -1, -1 },    // 3333
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 10, 12, 13, 14, -1, -1, -1 },    // 4333
 {  0,  4,  5,  6,  7,  8,  9, 10, 12, 13, 14, -1, -1, -1, -1, -1 },    // 1433
 {  0,  1,  4,  5,  6,  7,  8,  9, 10, 12, 13, 14, -1, -1, -1, -1 },    // 2433
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 10, 12, 13, 14, -1, -1, -1 },    // 3433
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 12, 13, 14, -1, -1 },    // 4433
 {  0,  4,  8,  9, 10, 11, 12, 13, 14, -1, -1, -1, -1, -1, -1, -1 },    // 1143
 {  0,  1,  4,  8,  9, 10, 11, 12, 13, 14, -1, -1, -1, -1, -1, -1 },    // 2143
 {  0,  1,  2,  4,  8,  9, 10, 11, 12, 13, 14, -1, -1, -1, -1, -1 },    // 3143
 {  0,  1,  2,  3,  4,  8,  9, 10, 11, 12, 13, 14, -1, -1, -1, -1 },    // 4143
 {  0,  4,  5,  8,  9, 10, 11, 12, 13, 14, -1, -1, -1, -1, -1, -1 },    // 1243
 {  0,  1,  4,  5,  8,  9, 10, 11, 12, 13, 14, -1, -1, -1, -1, -1 },    // 2243
 {  0,  1,  2,  4,  5,  8,  9, 10, 11, 12, 13, 14, -1, -1, -1, -1 },    // 3243
 {  0,  1,  2,  3,  4,  5,  8,  9, 10, 11, 12, 13, 14, -1, -1, -1 },    // 4243
 {  0,  4,  5,  6,  8,  9, 10, 11, 12, 13, 14, -1, -1, -1, -1, -1 },    // 1343
 {  0,  1,  4,  5,  6,  8,  9, 10, 11, 12, 13, 14, -1, -1, -1, -1 },    // 2343
 {  0,  1,  2,  4,  5,  6,  8,  9, 10, 11, 12, 13, 14, -1, -1, -1 },    // 3343
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 10, 11, 12, 13, 14, -1, -1 },    // 4343
 {  0,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, -1, -1, -1, -1 },    // 1443
 {  0,  1,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, -1, -1, -1 },    // 2443
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, -1, -1 },    // 3443
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, -1 },    // 4443
 {  0,  4,  8, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1114
 {  0,  1,  4,  8, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1 },    // 2114
 {  0,  1,  2,  4,  8, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1 },    // 3114
 {  0,  1,  2,  3,  4,  8, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1 },    // 4114
 {  0,  4,  5,  8, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1214
 {  0,  1,  4,  5,  8, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1 },    // 2214
 {  0,  1,  2,  4,  5,  8, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1 },    // 3214
 {  0,  1,  2,  3,  4,  5,  8, 12, 13, 14, 15, -1, -1, -1, -1, -1 },    // 4214
 {  0,  4,  5,  6,  8, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1 },    // 1314
 {  0,  1,  4,  5,  6,  8, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1 },    // 2314
 {  0,  1,  2,  4,  5,  6,  8, 12, 13, 14, 15, -1, -1, -1, -1, -1 },    // 3314
 {  0,  1,  2,  3,  4,  5,  6,  8, 12, 13, 14, 15, -1, -1, -1, -1 },    // 4314
 {  0,  4,  5,  6,  7,  8, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1 },    // 1414
 {  0,  1,  4,  5,  6,  7,  8, 12, 13, 14, 15, -1, -1, -1, -1, -1 },    // 2414
 {  0,  1,  2,  4,  5,  6,  7,  8, 12, 13, 14, 15, -1, -1, -1, -1 },    // 3414
 {  0,  1,  2,  3,  4,  5,  6,  7,  8, 12, 13, 14, 15, -1, -1, -1 },    // 4414
 {  0,  4,  8,  9, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1 },    // 1124
 {  0,  1,  4,  8,  9, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1 },    // 2124
 {  0,  1,  2,  4,  8,  9, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1 },    // 3124
 {  0,  1,  2,  3,  4,  8,  9, 12, 13, 14, 15, -1, -1, -1, -1, -1 },    // 4124
 {  0,  4,  5,  8,  9, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1 },    // 1224
 {  0,  1,  4,  5,  8,  9, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1 },    // 2224
 {  0,  1,  2,  4,  5,  8,  9, 12, 13, 14, 15, -1, -1, -1, -1, -1 },    // 3224
 {  0,  1,  2,  3,  4,  5,  8,  9, 12, 13, 14, 15, -1, -1, -1, -1 },    // 4224
 {  0,  4,  5,  6,  8,  9, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1 },    // 1324
 {  0,  1,  4,  5,  6,  8,  9, 12, 13, 14, 15, -1, -1, -1, -1, -1 },    // 2324
 {  0,  1,  2,  4,  5,  6,  8,  9, 12, 13, 14, 15, -1, -1, -1, -1 },    // 3324
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 12, 13, 14, 15, -1, -1, -1 },    // 4324
 {  0,  4,  5,  6,  7,  8,  9, 12, 13, 14, 15, -1, -1, -1, -1, -1 },    // 1424
 {  0,  1,  4,  5,  6,  7,  8,  9, 12, 13, 14, 15, -1, -1, -1, -1 },    // 2424
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 12, 13, 14, 15, -1, -1, -1 },    // 3424
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 12, 13, 14, 15, -1, -1 },    // 4424
 {  0,  4,  8,  9, 10, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1 },    // 1134
 {  0,  1,  4,  8,  9, 10, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1 },    // 2134
 {  0,  1,  2,  4,  8,  9, 10, 12, 13, 14, 15, -1, -1, -1, -1, -1 },    // 3134
 {  0,  1,  2,  3,  4,  8,  9, 10, 12, 13, 14, 15, -1, -1, -1, -1 },    // 4134
 {  0,  4,  5,  8,  9, 10, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1 },    // 1234
 {  0,  1,  4,  5,  8,  9, 10, 12, 13, 14, 15, -1, -1, -1, -1, -1 },    // 2234
 {  0,  1,  2,  4,  5,  8,  9, 10, 12, 13, 14, 15, -1, -1, -1, -1 },    // 3234
 {  0,  1,  2,  3,  4,  5,  8,  9, 10, 12, 13, 14, 15, -1, -1, -1 },    // 4234
 {  0,  4,  5,  6,  8,  9, 10, 12, 13, 14, 15, -1, -1, -1, -1, -1 },    // 1334
 {  0,  1,  4,  5,  6,  8,  9, 10, 12, 13, 14, 15, -1, -1, -1, -1 },    // 2334
 {  0,  1,  2,  4,  5,  6,  8,  9, 10, 12, 13, 14, 15, -1, -1, -1 },    // 3334
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 10, 12, 13, 14, 15, -1, -1 },    // 4334
 {  0,  4,  5,  6,  7,  8,  9, 10, 12, 13, 14, 15, -1, -1, -1, -1 },    // 1434
 {  0,  1,  4,  5,  6,  7,  8,  9, 10, 12, 13, 14, 15, -1, -1, -1 },    // 2434
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 10, 12, 13, 14, 15, -1, -1 },    // 3434
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 12, 13, 14, 15, -1 },    // 4434
 {  0,  4,  8,  9, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1 },    // 1144
 {  0,  1,  4,  8,  9, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1 },    // 2144
 {  0,  1,  2,  4,  8,  9, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1 },    // 3144
 {  0,  1,  2,  3,  4,  8,  9, 10, 11, 12, 13, 14, 15, -1, -1, -1 },    // 4144
 {  0,  4,  5,  8,  9, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1 },    // 1244
 {  0,  1,  4,  5,  8,  9, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1 },    // 2244
 {  0,  1,  2,  4,  5,  8,  9, 10, 11, 12, 13, 14, 15, -1, -1, -1 },    // 3244
 {  0,  1,  2,  3,  4,  5,  8,  9, 10, 11, 12, 13, 14, 15, -1, -1 },    // 4244
 {  0,  4,  5,  6,  8,  9, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1 },    // 1344
 {  0,  1,  4,  5,  6,  8,  9, 10, 11, 12, 13, 14, 15, -1, -1, -1 },    // 2344
 {  0,  1,  2,  4,  5,  6,  8,  9, 10, 11, 12, 13, 14, 15, -1, -1 },    // 3344
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 10, 11, 12, 13, 14, 15, -1 },    // 4344
 {  0,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, -1, -1, -1 },    // 1444
 {  0,  1,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, -1, -1 },    // 2444
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, -1 },    // 3444
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15 },    // 4444
};
#endif
#endif
