char tcl_ports[] = "\
#	File ports.tcl\n\
#	GUI for selection of ALSA port.\n\
\n\
proc port_setup {} {\n\
	global tcl_rcFileName\n\
	global ports\n\
	global iolists\n\
	global font12\n\
\n\
	set ports .setup\n\
	toplevel $ports\n\
	wm title $ports \"TK-707 ALSA port setup\"\n\
\n\
	set howto .setup.h\n\
	set howtotext $howto.text\n\
	set howtoscroll $howto.scroll\n\
	frame $howto ;#-relief groove -borderwidth 2\n\
	canvas $howtotext -yscrollcommand \"$howtoscroll set\" -width 13.5c -height 5c\n\
	scrollbar $howtoscroll -command \"$howtotext yview\" -width 0.4c\n\
	pack $howtoscroll -side right -fill y\n\
	pack $howtotext\n\
	pack $howto\n\
\n\
	$howtotext create text 0.2c 0.2c -anchor nw -font *-${font12}-* -text	\\\n\
\"Double click on one of Output Ports to make it the Selected Output.\\n\n\
The SAVE button will save the setting in ~/.tk707rc so that this\n\
selection dialogue won't appear next time TK-707 is started.\\n\n\
The OK button will close this dialogue and allow TK-707 to start\n\
using the selected port. If the current setting hasn't been SAVEd\n\
then this dialogue will appear again next time TK-707 is run.\n\
If no port has been selected, TK707 will not start.\\n\n\
Input Port selection is for future use and currently has no effect.\\n\n\
When this selection dialogue is raised from the File->Ports menu,\n\
a selection can be SAVEd but ports cannot be changed while\n\
TK-707 is running (yet).\"\n\
\n\
	set iolists $ports.l\n\
	canvas $iolists -width 14c -height 8c -relief groove -borderwidth 2\n\
	pack $iolists\n\
	set	olist $iolists.ol\n\
	set	ilist $iolists.il\n\
	set oselect $iolists.op\n\
	set iselect $iolists.ip\n\
	listbox $olist -font *-${font12}-* -width 28 -height 6 -selectmode browse -exportselection 1\n\
	listbox $ilist -font *-${font12}-* -width 28 -height 6 -selectmode browse -exportselection 1\n\
	label $oselect -width 28 -height 1 -relief sunken -borderwidth 2\n\
	label $iselect -width 28 -height 1 -relief sunken -borderwidth 2\n\
\n\
	$iolists create text 2c 0.5c -font *-${font12}-* -text \"Input Ports\" -anchor nw\n\
	$iolists create text 9c 0.5c -font *-${font12}-* -text \"Output Ports\" -anchor nw\n\
	$iolists create window 0.15c 1.5c -window $ilist -anchor nw\n\
	$iolists create window 7c 1.5c -window $olist -anchor nw\n\
	$iolists create window 0.2c 6c -window $iselect -anchor nw\n\
	$iolists create window 7.05c 6c -window $oselect -anchor nw\n\
	$iolists create text 2c 7c -font *-${font12}-* -text \"Selected Input\" -anchor nw\n\
	$iolists create text 9c 7c -font *-${font12}-* -text \"Selected Output\" -anchor nw\n\
\n\
	# Get list of output ports\n\
	set oportlist [tk7_port_list 1]\n\
	foreach i $oportlist {\n\
		if {[regexp -nocase \"MIDI\" $i]} {\n\
			$olist insert end $i\n\
		}\n\
	}\n\
	# Get list of input ports\n\
	set iportlist [tk7_port_list 0]\n\
	foreach i $iportlist {\n\
		if {[regexp -nocase \"midi\" $i]} {\n\
			$ilist insert end $i\n\
		}\n\
	}\n\
	bind .setup.l.il <Double-1> {\n\
		$iolists.ip configure -font *-${font12}-* -text [selection get]\n\
	}\n\
	bind $olist <Double-1> {\n\
		$iolists.op configure -font *-${font12}-* -text [selection get]\n\
	}\n\
	set portacts $ports.pa\n\
	canvas $portacts -width 14c -height 1.5c\n\
	pack $portacts\n\
\n\
	button $portacts.c -font *-${font12}-* -text CANCEL -width 6 -command {\n\
		if {! [tk7_port_setcheck]} {\n\
			puts \"NO PORTS SET\"\n\
			destroy .\n\
			exit\n\
		} else {\n\
			destroy $ports\n\
		}\n\
	}\n\
	button $portacts.s -font *-${font12}-* -text SAVE -width 6 -command {\n\
		set oplist [.setup.l.op configure -text]\n\
		# puts \"XX${oplist}XX\"\n\
		if {[llength $oplist] != 5} {\n\
			puts nothing\n\
		} else {\n\
			if {[llength [lindex $oplist 4]] > 0} {\n\
				set op [lindex [lindex $oplist 4] 0]\n\
				set oc [lindex [lindex $oplist 4] 1]\n\
				set tkxox(ALSA_OUTPORT) \"${op}:${oc}\"\n\
				# Save selection\n\
				set OPstr [format \"set tkxox(ALSA_OUTPORT) %d:%d\" $op $oc]\n\
				set f [open $tcl_rcFileName w]\n\
				seek $f  0 end\n\
				puts $f $OPstr\n\
				close $f\n\
				destroy $ports\n\
			}\n\
		}\n\
	}\n\
	button $portacts.b -font *-${font12}-* -text OK -width 6 -command {\n\
		set oplist [.setup.l.op configure -text]\n\
		if {[llength $oplist] != 5} {\n\
			puts nothing\n\
		} else {\n\
			if {[llength [lindex $oplist 4]] > 0} {\n\
				set op [lindex [lindex $oplist 4] 0]\n\
				set oc [lindex [lindex $oplist 4] 1]\n\
				set tkxox(ALSA_OUTPORT) \"${op}:${oc}\"\n\
			}\n\
		}\n\
		if {! [tk7_port_setcheck]} {\n\
			#puts \"NO PORTS SET\"\n\
			destroy .\n\
			exit\n\
		} else {\n\
			destroy $ports\n\
		}\n\
	}\n\
	$portacts create window 3c 0.75c -window  $portacts.c\n\
	$portacts create window 7c 0.75c -window  $portacts.s\n\
	$portacts create window 11c 0.75c -window  $portacts.b\n\
\n\
	grab set $ports\n\
	tkwait window $portacts\n\
}\n\
";
