#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2008-2013 Richard Liao <richard.liao.i@gmail.com>
# All rights reserved.
#
# This software is licensed as described in the file COPYING, which
# you should have received as part of this distribution.
#

import sys
from setuptools import setup

extra = {}

try:
    import babel
    from trac.util.dist import get_l10n_js_cmdclass
except ImportError:
    babel = None
else:
    extra['cmdclass'] = get_l10n_js_cmdclass()
    extractors = [
        ('**.py', 'python', None),
        ('**/templates/**.html', 'genshi', None),
        ('**/templates/**.txt', 'genshi',
         {'template_class': 'genshi.template:NewTextTemplate'}),
    ]
    extra['message_extractors'] = {
        'tickettemplate': extractors,
    }

setup(
    name='TracTicketTemplate',
    version='1.0.1',
    packages=['tickettemplate'],
    package_data={
        'tickettemplate': [
            '*.txt',
            'templates/jinja2/*.html',
            'templates/genshi/*.html',
            'htdocs/*.*',
            'locale/*.pot',
            'locale/*/LC_MESSAGES/*.mo',
        ],
    },
    author="Richard Liao",
    author_email='richard.liao.i@gmail.com',
    maintainer="Richard Liao",
    maintainer_email="richard.liao.i@gmail.com",
    description="Ticket template plugin for Trac.",
    license="3-Clause BSD",
    keywords="trac ticket template",
    url="https://trac-hacks.org/wiki/TracTicketTemplatePlugin",
    classifiers=[
        'Framework :: Trac',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
    ],

    install_requires=['Trac'],
    test_suite='tickettemplate.tests',
    entry_points={
        'trac.plugins': ['tickettemplate = tickettemplate.ttadmin'],
    },
    **extra
)
