from _typeshed import Incomplete
from collections.abc import Iterable
from datetime import date, datetime, timedelta
from time import _TimeTuple, struct_time
from typing import Any, Generic, NamedTuple, TypeVar, overload

_GetterReturnType = TypeVar("_GetterReturnType")
_SetterValueType = TypeVar("_SetterValueType")

class _AsymmetricProperty(Generic[_GetterReturnType, _SetterValueType]):
    @overload
    def __get__(self, __obj: None, __type: type | None = ...) -> property: ...
    @overload
    def __get__(self, __obj: Any, __type: type | None = ...) -> _GetterReturnType: ...
    def __set__(self, __obj: Any, __value: _SetterValueType) -> None: ...

class _AsymmetricPropertyWithDelete(_AsymmetricProperty[_GetterReturnType, _SetterValueType]):
    def __delete__(self, __obj: Any) -> None: ...

class _StringProperty(_AsymmetricPropertyWithDelete[str | None, str | None]): ...
class _ListProperty(_AsymmetricPropertyWithDelete[tuple[str, ...] | None, Iterable[str] | str | None]): ...
class _DateProperty(
    _AsymmetricPropertyWithDelete[datetime | None, date | datetime | timedelta | _TimeTuple | struct_time | float | str | None]
): ...

def environ_getter(key, default=..., rfc_section: Incomplete | None = None): ...
def environ_decoder(key, default=..., rfc_section: Incomplete | None = None, encattr: Incomplete | None = None): ...
def upath_property(key): ...
def deprecated_property(attr, name, text, version): ...
def header_getter(header: str, rfc_section: str) -> _StringProperty: ...
def converter(prop, parse, serialize, convert_name: Incomplete | None = None): ...
def list_header(header: str, rfc_section: str) -> _ListProperty: ...
def parse_list(value): ...
def serialize_list(value): ...
def converter_date(prop): ...
def date_header(header: str, rfc_section: str) -> _DateProperty: ...
def parse_etag_response(value, strong: bool = False): ...
def serialize_etag_response(value): ...
def serialize_if_range(value): ...
def parse_range(value): ...
def serialize_range(value): ...
def parse_int(value): ...
def parse_int_safe(value): ...

serialize_int = str

def parse_content_range(value): ...
def serialize_content_range(value): ...
def parse_auth_params(params): ...

known_auth_schemes: dict[str, None]

class _authorization(NamedTuple):
    authtype: str
    params: dict[str, str] | str

def parse_auth(val): ...
def serialize_auth(val): ...
