/**
 * @file
 * @brief Trigger functions
 */

/*
All original material Copyright (C) 2002-2013 UFO: Alien Invasion.

Original file from Quake 2 v3.21: quake2-2.31/game/g_spawn.c
Copyright (C) 1997-2001 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#pragma once

#include "g_local.h"

bool G_TriggerIsInList(Edict* self, Edict* activator);
void G_TriggerAddToList(Edict* self, Edict* activator);
bool G_TriggerRemoveFromList(Edict* self, Edict* activator);
Edict* G_TriggerSpawn(Edict* owner);
void Think_NextMapTrigger(Edict* self);
void SP_trigger_nextmap(Edict* ent);
bool Touch_HurtTrigger(Edict* self, Edict* activator);
void SP_trigger_hurt(Edict* ent);
void SP_trigger_touch(Edict* ent);
void SP_trigger_rescue(Edict* ent);
