/* valaccodeassignment.c generated by valac, the Vala compiler
 * generated from valaccodeassignment.vala, do not modify */

/* valaccodeassignment.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valaccode.h"

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))

struct _ValaCCodeAssignmentPrivate {
	ValaCCodeExpression* _left;
	ValaCCodeAssignmentOperator _operator;
	ValaCCodeExpression* _right;
};


static gpointer vala_ccode_assignment_parent_class = NULL;

#define VALA_CCODE_ASSIGNMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ASSIGNMENT, ValaCCodeAssignmentPrivate))
static void vala_ccode_assignment_real_write (ValaCCodeNode* base,
                                       ValaCCodeWriter* writer);
static void vala_ccode_assignment_real_write_inner (ValaCCodeExpression* base,
                                             ValaCCodeWriter* writer);
static void vala_ccode_assignment_finalize (ValaCCodeNode * obj);


ValaCCodeAssignment*
vala_ccode_assignment_construct (GType object_type,
                                 ValaCCodeExpression* l,
                                 ValaCCodeExpression* r,
                                 ValaCCodeAssignmentOperator op)
{
	ValaCCodeAssignment* self = NULL;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	self = (ValaCCodeAssignment*) vala_ccode_expression_construct (object_type);
	vala_ccode_assignment_set_left (self, l);
	vala_ccode_assignment_set_operator (self, op);
	vala_ccode_assignment_set_right (self, r);
	return self;
}


ValaCCodeAssignment*
vala_ccode_assignment_new (ValaCCodeExpression* l,
                           ValaCCodeExpression* r,
                           ValaCCodeAssignmentOperator op)
{
	return vala_ccode_assignment_construct (VALA_TYPE_CCODE_ASSIGNMENT, l, r, op);
}


static void
vala_ccode_assignment_real_write (ValaCCodeNode* base,
                                  ValaCCodeWriter* writer)
{
	ValaCCodeAssignment * self;
	ValaCCodeExpression* _tmp0_;
	ValaCCodeAssignmentOperator _tmp1_;
	ValaCCodeExpression* _tmp2_;
	self = (ValaCCodeAssignment*) base;
	g_return_if_fail (writer != NULL);
	_tmp0_ = self->priv->_left;
	vala_ccode_node_write ((ValaCCodeNode*) _tmp0_, writer);
	_tmp1_ = self->priv->_operator;
	switch (_tmp1_) {
		case VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE:
		{
			vala_ccode_writer_write_string (writer, " = ");
			break;
		}
		case VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_OR:
		{
			vala_ccode_writer_write_string (writer, " |= ");
			break;
		}
		case VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_AND:
		{
			vala_ccode_writer_write_string (writer, " &= ");
			break;
		}
		case VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_XOR:
		{
			vala_ccode_writer_write_string (writer, " ^= ");
			break;
		}
		case VALA_CCODE_ASSIGNMENT_OPERATOR_ADD:
		{
			vala_ccode_writer_write_string (writer, " += ");
			break;
		}
		case VALA_CCODE_ASSIGNMENT_OPERATOR_SUB:
		{
			vala_ccode_writer_write_string (writer, " -= ");
			break;
		}
		case VALA_CCODE_ASSIGNMENT_OPERATOR_MUL:
		{
			vala_ccode_writer_write_string (writer, " *= ");
			break;
		}
		case VALA_CCODE_ASSIGNMENT_OPERATOR_DIV:
		{
			vala_ccode_writer_write_string (writer, " /= ");
			break;
		}
		case VALA_CCODE_ASSIGNMENT_OPERATOR_PERCENT:
		{
			vala_ccode_writer_write_string (writer, " %= ");
			break;
		}
		case VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_LEFT:
		{
			vala_ccode_writer_write_string (writer, " <<= ");
			break;
		}
		case VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_RIGHT:
		{
			vala_ccode_writer_write_string (writer, " >>= ");
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp2_ = self->priv->_right;
	vala_ccode_node_write ((ValaCCodeNode*) _tmp2_, writer);
}


static void
vala_ccode_assignment_real_write_inner (ValaCCodeExpression* base,
                                        ValaCCodeWriter* writer)
{
	ValaCCodeAssignment * self;
	self = (ValaCCodeAssignment*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, "(");
	vala_ccode_node_write ((ValaCCodeNode*) self, writer);
	vala_ccode_writer_write_string (writer, ")");
}


ValaCCodeExpression*
vala_ccode_assignment_get_left (ValaCCodeAssignment* self)
{
	ValaCCodeExpression* result;
	ValaCCodeExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


void
vala_ccode_assignment_set_left (ValaCCodeAssignment* self,
                                ValaCCodeExpression* value)
{
	ValaCCodeExpression* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_ccode_node_ref0 (value);
	_vala_ccode_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
}


ValaCCodeAssignmentOperator
vala_ccode_assignment_get_operator (ValaCCodeAssignment* self)
{
	ValaCCodeAssignmentOperator result;
	ValaCCodeAssignmentOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}


void
vala_ccode_assignment_set_operator (ValaCCodeAssignment* self,
                                    ValaCCodeAssignmentOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}


ValaCCodeExpression*
vala_ccode_assignment_get_right (ValaCCodeAssignment* self)
{
	ValaCCodeExpression* result;
	ValaCCodeExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}


void
vala_ccode_assignment_set_right (ValaCCodeAssignment* self,
                                 ValaCCodeExpression* value)
{
	ValaCCodeExpression* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_ccode_node_ref0 (value);
	_vala_ccode_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
}


static void
vala_ccode_assignment_class_init (ValaCCodeAssignmentClass * klass)
{
	vala_ccode_assignment_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeNodeClass *) klass)->finalize = vala_ccode_assignment_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeAssignmentPrivate));
	((ValaCCodeNodeClass *) klass)->write = (void (*) (ValaCCodeNode*, ValaCCodeWriter*)) vala_ccode_assignment_real_write;
	((ValaCCodeExpressionClass *) klass)->write_inner = (void (*) (ValaCCodeExpression*, ValaCCodeWriter*)) vala_ccode_assignment_real_write_inner;
}


static void
vala_ccode_assignment_instance_init (ValaCCodeAssignment * self)
{
	self->priv = VALA_CCODE_ASSIGNMENT_GET_PRIVATE (self);
}


static void
vala_ccode_assignment_finalize (ValaCCodeNode * obj)
{
	ValaCCodeAssignment * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_ASSIGNMENT, ValaCCodeAssignment);
	_vala_ccode_node_unref0 (self->priv->_left);
	_vala_ccode_node_unref0 (self->priv->_right);
	VALA_CCODE_NODE_CLASS (vala_ccode_assignment_parent_class)->finalize (obj);
}


/**
 * Represents an assignment expression in the C code.
 */
GType
vala_ccode_assignment_get_type (void)
{
	static volatile gsize vala_ccode_assignment_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_assignment_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeAssignmentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_assignment_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeAssignment), 0, (GInstanceInitFunc) vala_ccode_assignment_instance_init, NULL };
		GType vala_ccode_assignment_type_id;
		vala_ccode_assignment_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeAssignment", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_assignment_type_id__volatile, vala_ccode_assignment_type_id);
	}
	return vala_ccode_assignment_type_id__volatile;
}


GType
vala_ccode_assignment_operator_get_type (void)
{
	static volatile gsize vala_ccode_assignment_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_assignment_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE, "VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE", "simple"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_OR, "VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_AND, "VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_XOR, "VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_ADD, "VALA_CCODE_ASSIGNMENT_OPERATOR_ADD", "add"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_SUB, "VALA_CCODE_ASSIGNMENT_OPERATOR_SUB", "sub"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_MUL, "VALA_CCODE_ASSIGNMENT_OPERATOR_MUL", "mul"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_DIV, "VALA_CCODE_ASSIGNMENT_OPERATOR_DIV", "div"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_PERCENT, "VALA_CCODE_ASSIGNMENT_OPERATOR_PERCENT", "percent"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_LEFT, "VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_RIGHT, "VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_RIGHT", "shift-right"}, {0, NULL, NULL}};
		GType vala_ccode_assignment_operator_type_id;
		vala_ccode_assignment_operator_type_id = g_enum_register_static ("ValaCCodeAssignmentOperator", values);
		g_once_init_leave (&vala_ccode_assignment_operator_type_id__volatile, vala_ccode_assignment_operator_type_id);
	}
	return vala_ccode_assignment_operator_type_id__volatile;
}



