/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <glib.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                       ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static GType vala_ccode_method_call_module_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaMemberAccess* _tmp6_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaList* _tmp13_;
	ValaList* _tmp14_;
	ValaDataType* _tmp15_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp166_;
	GEqualFunc _tmp167_;
	GEqualFunc _tmp168_;
	ValaHashMap* _tmp169_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp170_;
	ValaHashMap* _tmp171_;
	gboolean _tmp172_ = FALSE;
	ValaMethod* _tmp173_;
	gboolean _tmp290_ = FALSE;
	ValaMethod* _tmp291_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp455_;
	ValaCCodeExpression* _tmp456_;
	gboolean _tmp457_ = FALSE;
	ValaMethod* _tmp458_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp486_ = FALSE;
	ValaMethod* _tmp487_;
	gboolean _tmp638_ = FALSE;
	ValaMethod* _tmp639_;
	ValaMethod* _tmp689_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp877_;
	ValaIterator* _tmp878_;
	ValaIterator* _tmp1290_;
	gboolean _tmp1300_ = FALSE;
	gboolean _tmp1301_ = FALSE;
	ValaMethod* _tmp1302_;
	gboolean _tmp1427_ = FALSE;
	ValaDelegate* _tmp1428_;
	gboolean _tmp1528_ = FALSE;
	ValaMethod* _tmp1529_;
	gboolean _tmp1545_;
	gboolean _tmp1546_;
	gboolean _tmp1589_ = FALSE;
	ValaDelegate* _tmp1590_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1608_;
	ValaDataType* _tmp1609_;
	gboolean _tmp1610_ = FALSE;
	ValaDataType* _tmp1611_;
	ValaCCodeFunctionCall* _tmp1639_;
	ValaCCodeFunctionCall* _tmp1640_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1653_;
	ValaCCodeFunctionCall* _tmp1654_;
	ValaCCodeFunctionCall* _tmp1669_;
	gboolean _tmp1684_;
	gboolean _tmp1685_;
	gboolean _tmp1709_;
	gboolean _tmp1710_;
	gboolean _tmp1745_ = FALSE;
	gboolean _tmp1746_ = FALSE;
	ValaMethod* _tmp1747_;
	gboolean _tmp1785_ = FALSE;
	gboolean _tmp1786_ = FALSE;
	gboolean _tmp1787_ = FALSE;
	gboolean _tmp1788_ = FALSE;
	gboolean _tmp1789_ = FALSE;
	ValaMethod* _tmp1790_;
	gboolean _tmp1807_ = FALSE;
	gboolean _tmp1808_ = FALSE;
	ValaMethod* _tmp1809_;
	ValaMethod* _tmp1828_;
	gboolean _tmp1944_ = FALSE;
	ValaCodeNode* _tmp1945_;
	ValaCodeNode* _tmp1946_;
	ValaList* _tmp2046_;
	ValaIterator* _tmp2047_;
	gboolean _tmp2194_ = FALSE;
	gboolean _tmp2195_ = FALSE;
	ValaMethod* _tmp2196_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_get_cvalue (_tmp1_);
	_tmp3_ = vala_ccode_function_call_new (_tmp2_);
	ccall = _tmp3_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp4_ = vala_method_call_get_call (expr);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp5_) : NULL);
	ma = _tmp6_;
	_tmp7_ = vala_method_call_get_call (expr);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_expression_get_value_type (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _vala_code_node_ref0 (_tmp10_);
	itype = _tmp11_;
	_tmp12_ = itype;
	_tmp13_ = vala_data_type_get_parameters (_tmp12_);
	_tmp14_ = _vala_iterable_ref0 (_tmp13_);
	_vala_iterable_unref0 (params);
	params = _tmp14_;
	_tmp15_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp16_;
		ValaDataType* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		ValaMemberAccess* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp16_ = ma;
		_vala_assert (_tmp16_ != NULL, "ma != null");
		_tmp17_ = itype;
		_tmp18_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp19_ = _tmp18_;
		_tmp20_ = _vala_code_node_ref0 (_tmp19_);
		_vala_code_node_unref0 (m);
		m = _tmp20_;
		_tmp21_ = m;
		if (!vala_get_ccode_simple_generics (_tmp21_)) {
			ValaCodeContext* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaSemanticAnalyzer* _tmp24_;
			ValaSemanticAnalyzer* _tmp25_;
			ValaMemberAccess* _tmp26_;
			_tmp22_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_code_context_get_analyzer (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = ma;
			vala_semantic_analyzer_check_type_arguments (_tmp25_, _tmp26_);
		}
		_tmp29_ = ma;
		_tmp30_ = vala_member_access_get_inner (_tmp29_);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaMemberAccess* _tmp32_;
			ValaExpression* _tmp33_;
			ValaExpression* _tmp34_;
			ValaDataType* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp32_ = ma;
			_tmp33_ = vala_member_access_get_inner (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_expression_get_value_type (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp28_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp36_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaMemberAccess* _tmp37_;
			ValaExpression* _tmp38_;
			ValaExpression* _tmp39_;
			ValaDataType* _tmp40_;
			ValaDataType* _tmp41_;
			ValaMethod* _tmp42_;
			ValaMethod* _tmp43_;
			_tmp37_ = ma;
			_tmp38_ = vala_member_access_get_inner (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_expression_get_value_type (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp43_ = m;
			_tmp27_ = _tmp42_ == _tmp43_;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp44_;
			ValaExpression* _tmp45_;
			ValaExpression* _tmp46_;
			ValaDataType* _tmp47_;
			ValaDataType* _tmp48_;
			ValaTypeSymbol* _tmp49_;
			ValaTypeSymbol* _tmp50_;
			ValaCCodeFunctionCall* _tmp51_;
			ValaEnum* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			ValaCCodeIdentifier* _tmp56_;
			_tmp44_ = ma;
			_tmp45_ = vala_member_access_get_inner (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_expression_get_value_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_data_type_get_type_symbol (_tmp48_);
			_tmp50_ = _tmp49_;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_ENUM, ValaEnum);
			_tmp51_ = ccall;
			_tmp52_ = en;
			_tmp53_ = vala_ccode_method_call_module_generate_enum_to_string_function (self, _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_ccode_identifier_new (_tmp54_);
			_tmp56_ = _tmp55_;
			vala_ccode_function_call_set_call (_tmp51_, (ValaCCodeExpression*) _tmp56_);
			_vala_ccode_node_unref0 (_tmp56_);
			_g_free0 (_tmp54_);
		} else {
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			gboolean _tmp60_ = FALSE;
			ValaCodeContext* _tmp61_;
			ValaCodeContext* _tmp62_;
			ValaProfile _tmp63_;
			ValaProfile _tmp64_;
			_tmp61_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_code_context_get_profile (_tmp62_);
			_tmp64_ = _tmp63_;
			if (_tmp64_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp65_;
				ValaExpression* _tmp66_;
				ValaExpression* _tmp67_;
				_tmp65_ = ma;
				_tmp66_ = vala_member_access_get_inner (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp60_ = _tmp67_ != NULL;
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaMemberAccess* _tmp68_;
				ValaExpression* _tmp69_;
				ValaExpression* _tmp70_;
				ValaDataType* _tmp71_;
				ValaDataType* _tmp72_;
				_tmp68_ = ma;
				_tmp69_ = vala_member_access_get_inner (_tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = vala_expression_get_value_type (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp59_ = _tmp72_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp73_;
				ValaExpression* _tmp74_;
				ValaExpression* _tmp75_;
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaTypeSymbol* _tmp79_;
				ValaDataType* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				ValaTypeSymbol* _tmp82_;
				_tmp73_ = ma;
				_tmp74_ = vala_member_access_get_inner (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_expression_get_value_type (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_data_type_get_type_symbol (_tmp77_);
				_tmp79_ = _tmp78_;
				_tmp80_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp81_ = vala_data_type_get_type_symbol (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp58_ = _tmp79_ == _tmp82_;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp83_;
				const gchar* _tmp84_;
				const gchar* _tmp85_;
				_tmp83_ = ma;
				_tmp84_ = vala_member_access_get_member_name (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp57_ = g_strcmp0 (_tmp85_, "printf") == 0;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp86_;
				gchar* _tmp87_;
				gchar* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				ValaCCodeIdentifier* _tmp90_;
				_tmp86_ = ccall;
				_tmp87_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_ccode_identifier_new (_tmp88_);
				_tmp90_ = _tmp89_;
				vala_ccode_function_call_set_call (_tmp86_, (ValaCCodeExpression*) _tmp90_);
				_vala_ccode_node_unref0 (_tmp90_);
				_g_free0 (_tmp88_);
			} else {
				gboolean _tmp91_;
				gboolean _tmp92_;
				_tmp91_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp92_ = _tmp91_;
				if (_tmp92_) {
					ValaCCodeFunctionCall* _tmp93_;
					ValaMethod* _tmp94_;
					gchar* _tmp95_;
					gchar* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					ValaCCodeIdentifier* _tmp98_;
					_tmp93_ = ccall;
					_tmp94_ = m;
					_tmp95_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp96_ = _tmp95_;
					_tmp97_ = vala_ccode_identifier_new (_tmp96_);
					_tmp98_ = _tmp97_;
					vala_ccode_function_call_set_call (_tmp93_, (ValaCCodeExpression*) _tmp98_);
					_vala_ccode_node_unref0 (_tmp98_);
					_g_free0 (_tmp96_);
				}
			}
		}
	} else {
		ValaDataType* _tmp99_;
		_tmp99_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp100_;
			ValaSignalType* _tmp101_;
			gboolean _tmp102_ = FALSE;
			gboolean _tmp103_ = FALSE;
			ValaMemberAccess* _tmp104_;
			_tmp100_ = itype;
			_tmp101_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp101_;
			_tmp104_ = ma;
			if (_tmp104_ != NULL) {
				ValaMemberAccess* _tmp105_;
				ValaExpression* _tmp106_;
				ValaExpression* _tmp107_;
				_tmp105_ = ma;
				_tmp106_ = vala_member_access_get_inner (_tmp105_);
				_tmp107_ = _tmp106_;
				_tmp103_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp107_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp103_ = FALSE;
			}
			if (_tmp103_) {
				ValaSignalType* _tmp108_;
				ValaSignal* _tmp109_;
				ValaSignal* _tmp110_;
				gboolean _tmp111_;
				gboolean _tmp112_;
				_tmp108_ = sig_type;
				_tmp109_ = vala_signal_type_get_signal_symbol (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = vala_signal_get_is_virtual (_tmp110_);
				_tmp112_ = _tmp111_;
				_tmp102_ = _tmp112_;
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp113_;
				ValaSignal* _tmp114_;
				ValaSignal* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				ValaMethod* _tmp118_;
				_tmp113_ = sig_type;
				_tmp114_ = vala_signal_type_get_signal_symbol (_tmp113_);
				_tmp115_ = _tmp114_;
				_tmp116_ = vala_signal_get_default_handler (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = _vala_code_node_ref0 (_tmp117_);
				_vala_code_node_unref0 (m);
				m = _tmp118_;
			} else {
				ValaExpression* _tmp119_;
				ValaExpression* _tmp120_;
				ValaCCodeExpression* _tmp121_;
				ValaCCodeFunctionCall* _tmp122_;
				_tmp119_ = vala_method_call_get_call (expr);
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_get_cvalue (_tmp120_);
				_tmp122_ = _vala_ccode_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall));
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp122_;
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp123_;
			_tmp123_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp123_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp124_;
				ValaTypeSymbol* _tmp125_;
				ValaTypeSymbol* _tmp126_;
				ValaClass* _tmp127_;
				ValaClass* _tmp128_;
				ValaCreationMethod* _tmp129_;
				ValaCreationMethod* _tmp130_;
				ValaMethod* _tmp131_;
				ValaMethod* _tmp132_;
				ValaCCodeFile* _tmp133_;
				gchar* real_name = NULL;
				ValaMethod* _tmp134_;
				gchar* _tmp135_;
				gboolean _tmp136_;
				gboolean _tmp137_;
				const gchar* _tmp140_;
				ValaCCodeIdentifier* _tmp141_;
				ValaCCodeIdentifier* _tmp142_;
				ValaCCodeFunctionCall* _tmp143_;
				_tmp124_ = itype;
				_tmp125_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp126_ = _tmp125_;
				_tmp127_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp127_;
				_tmp128_ = cl;
				_tmp129_ = vala_class_get_default_construction_method (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = _vala_code_node_ref0 ((ValaMethod*) _tmp130_);
				_vala_code_node_unref0 (m);
				m = _tmp131_;
				_tmp132_ = m;
				_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp132_, _tmp133_);
				_tmp134_ = m;
				_tmp135_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp134_);
				real_name = _tmp135_;
				_tmp136_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp137_ = _tmp136_;
				if (_tmp137_) {
					ValaMethod* _tmp138_;
					gchar* _tmp139_;
					_tmp138_ = m;
					_tmp139_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp138_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp139_;
				}
				_tmp140_ = real_name;
				_tmp141_ = vala_ccode_identifier_new (_tmp140_);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp142_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp143_;
				_vala_ccode_node_unref0 (_tmp142_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp144_;
				_tmp144_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp144_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp145_;
					ValaTypeSymbol* _tmp146_;
					ValaTypeSymbol* _tmp147_;
					ValaStruct* _tmp148_;
					ValaStruct* _tmp149_;
					ValaCreationMethod* _tmp150_;
					ValaCreationMethod* _tmp151_;
					ValaMethod* _tmp152_;
					ValaMethod* _tmp153_;
					ValaCCodeFile* _tmp154_;
					ValaMethod* _tmp155_;
					gchar* _tmp156_;
					gchar* _tmp157_;
					ValaCCodeIdentifier* _tmp158_;
					ValaCCodeIdentifier* _tmp159_;
					ValaCCodeFunctionCall* _tmp160_;
					_tmp145_ = itype;
					_tmp146_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp147_ = _tmp146_;
					_tmp148_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp147_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp148_;
					_tmp149_ = st;
					_tmp150_ = vala_struct_get_default_construction_method (_tmp149_);
					_tmp151_ = _tmp150_;
					_tmp152_ = _vala_code_node_ref0 ((ValaMethod*) _tmp151_);
					_vala_code_node_unref0 (m);
					m = _tmp152_;
					_tmp153_ = m;
					_tmp154_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp153_, _tmp154_);
					_tmp155_ = m;
					_tmp156_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_identifier_new (_tmp157_);
					_tmp159_ = _tmp158_;
					_tmp160_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp159_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp160_;
					_vala_ccode_node_unref0 (_tmp159_);
					_g_free0 (_tmp157_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp161_;
					_tmp161_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp161_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp162_;
						ValaDelegate* _tmp163_;
						ValaDelegate* _tmp164_;
						ValaDelegate* _tmp165_;
						_tmp162_ = itype;
						_tmp163_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp164_ = _tmp163_;
						_tmp165_ = _vala_code_node_ref0 (_tmp164_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp165_;
					}
				}
			}
		}
	}
	_tmp166_ = g_direct_hash;
	_tmp167_ = g_direct_equal;
	_tmp168_ = g_direct_equal;
	_tmp169_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp166_, _tmp167_, _tmp168_);
	in_arg_map = _tmp169_;
	_tmp170_ = in_arg_map;
	_tmp171_ = _vala_map_ref0 (_tmp170_);
	out_arg_map = _tmp171_;
	_tmp173_ = m;
	if (_tmp173_ != NULL) {
		ValaMethod* _tmp174_;
		gboolean _tmp175_;
		gboolean _tmp176_;
		_tmp174_ = m;
		_tmp175_ = vala_method_get_coroutine (_tmp174_);
		_tmp176_ = _tmp175_;
		_tmp172_ = _tmp176_;
	} else {
		_tmp172_ = FALSE;
	}
	if (_tmp172_) {
		ValaMethod* _tmp177_;
		gchar* _tmp178_;
		gchar* _tmp179_;
		ValaCCodeIdentifier* _tmp180_;
		ValaCCodeIdentifier* _tmp181_;
		ValaCCodeFunctionCall* _tmp182_;
		ValaMethod* _tmp183_;
		gchar* _tmp184_;
		gchar* _tmp185_;
		ValaCCodeIdentifier* _tmp186_;
		ValaCCodeIdentifier* _tmp187_;
		ValaCCodeFunctionCall* _tmp188_;
		ValaMemberAccess* _tmp189_;
		ValaExpression* _tmp190_;
		ValaExpression* _tmp191_;
		gboolean _tmp240_ = FALSE;
		ValaMemberAccess* _tmp241_;
		const gchar* _tmp242_;
		const gchar* _tmp243_;
		_tmp177_ = m;
		_tmp178_ = vala_get_ccode_name ((ValaCodeNode*) _tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_identifier_new (_tmp179_);
		_tmp181_ = _tmp180_;
		_tmp182_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp181_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp182_;
		_vala_ccode_node_unref0 (_tmp181_);
		_g_free0 (_tmp179_);
		_tmp183_ = m;
		_tmp184_ = vala_get_ccode_finish_name (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_identifier_new (_tmp185_);
		_tmp187_ = _tmp186_;
		_tmp188_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp187_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp188_;
		_vala_ccode_node_unref0 (_tmp187_);
		_g_free0 (_tmp185_);
		_tmp189_ = ma;
		_tmp190_ = vala_member_access_get_inner (_tmp189_);
		_tmp191_ = _tmp190_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp191_, VALA_TYPE_BASE_ACCESS)) {
			ValaCCodeExpression* vcast = NULL;
			ValaMethod* _tmp192_;
			ValaMethod* _tmp193_;
			ValaMethod* _tmp194_;
			ValaCCodeExpression* _tmp225_;
			vcast = NULL;
			_tmp192_ = m;
			_tmp193_ = vala_method_get_base_method (_tmp192_);
			_tmp194_ = _tmp193_;
			if (_tmp194_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp195_;
				ValaMethod* _tmp196_;
				ValaMethod* _tmp197_;
				ValaSymbol* _tmp198_;
				ValaSymbol* _tmp199_;
				ValaClass* _tmp200_;
				gchar* _tmp201_;
				gchar* _tmp202_;
				ValaCCodeIdentifier* _tmp203_;
				ValaCCodeIdentifier* _tmp204_;
				ValaCCodeFunctionCall* _tmp205_;
				ValaCCodeExpression* _tmp206_;
				ValaClass* _tmp207_;
				ValaClass* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				ValaCCodeIdentifier* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				_tmp195_ = m;
				_tmp196_ = vala_method_get_base_method (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp197_);
				_tmp199_ = _tmp198_;
				base_class = G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, VALA_TYPE_CLASS, ValaClass);
				_tmp200_ = base_class;
				_tmp201_ = vala_get_ccode_class_type_function (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = vala_ccode_identifier_new (_tmp202_);
				_tmp204_ = _tmp203_;
				_tmp205_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp204_);
				_vala_ccode_node_unref0 (vcast);
				vcast = (ValaCCodeExpression*) _tmp205_;
				_vala_ccode_node_unref0 (_tmp204_);
				_g_free0 (_tmp202_);
				_tmp206_ = vcast;
				_tmp207_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp208_, NULL);
				_tmp210_ = _tmp209_;
				_tmp211_ = g_strdup_printf ("%s_parent_class", _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_ccode_identifier_new (_tmp212_);
				_tmp214_ = _tmp213_;
				vala_ccode_function_call_add_argument (G_TYPE_CHECK_INSTANCE_CAST (_tmp206_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall), (ValaCCodeExpression*) _tmp214_);
				_vala_ccode_node_unref0 (_tmp214_);
				_g_free0 (_tmp212_);
				_g_free0 (_tmp210_);
			} else {
				ValaMethod* _tmp215_;
				ValaMethod* _tmp216_;
				ValaMethod* _tmp217_;
				_tmp215_ = m;
				_tmp216_ = vala_method_get_base_interface_method (_tmp215_);
				_tmp217_ = _tmp216_;
				if (_tmp217_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp218_;
					ValaMethod* _tmp219_;
					ValaMethod* _tmp220_;
					ValaSymbol* _tmp221_;
					ValaSymbol* _tmp222_;
					ValaInterface* _tmp223_;
					ValaCCodeExpression* _tmp224_;
					_tmp218_ = m;
					_tmp219_ = vala_method_get_base_interface_method (_tmp218_);
					_tmp220_ = _tmp219_;
					_tmp221_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp220_);
					_tmp222_ = _tmp221_;
					base_iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp222_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp223_ = base_iface;
					_tmp224_ = vala_ccode_base_module_get_this_interface_cexpression ((ValaCCodeBaseModule*) self, _tmp223_);
					_vala_ccode_node_unref0 (vcast);
					vcast = _tmp224_;
				}
			}
			_tmp225_ = vcast;
			if (_tmp225_ != NULL) {
				ValaCCodeFunctionCall* _tmp226_;
				ValaCCodeExpression* _tmp227_;
				ValaMethod* _tmp228_;
				gchar* _tmp229_;
				gchar* _tmp230_;
				ValaCCodeMemberAccess* _tmp231_;
				ValaCCodeMemberAccess* _tmp232_;
				ValaCCodeFunctionCall* _tmp233_;
				ValaCCodeExpression* _tmp234_;
				ValaMethod* _tmp235_;
				gchar* _tmp236_;
				gchar* _tmp237_;
				ValaCCodeMemberAccess* _tmp238_;
				ValaCCodeMemberAccess* _tmp239_;
				_tmp226_ = async_call;
				_tmp227_ = vcast;
				_tmp228_ = m;
				_tmp229_ = vala_get_ccode_vfunc_name (_tmp228_);
				_tmp230_ = _tmp229_;
				_tmp231_ = vala_ccode_member_access_new_pointer (_tmp227_, _tmp230_);
				_tmp232_ = _tmp231_;
				vala_ccode_function_call_set_call (_tmp226_, (ValaCCodeExpression*) _tmp232_);
				_vala_ccode_node_unref0 (_tmp232_);
				_g_free0 (_tmp230_);
				_tmp233_ = finish_call;
				_tmp234_ = vcast;
				_tmp235_ = m;
				_tmp236_ = vala_get_ccode_finish_vfunc_name (_tmp235_);
				_tmp237_ = _tmp236_;
				_tmp238_ = vala_ccode_member_access_new_pointer (_tmp234_, _tmp237_);
				_tmp239_ = _tmp238_;
				vala_ccode_function_call_set_call (_tmp233_, (ValaCCodeExpression*) _tmp239_);
				_vala_ccode_node_unref0 (_tmp239_);
				_g_free0 (_tmp237_);
			}
			_vala_ccode_node_unref0 (vcast);
		}
		_tmp241_ = ma;
		_tmp242_ = vala_member_access_get_member_name (_tmp241_);
		_tmp243_ = _tmp242_;
		if (g_strcmp0 (_tmp243_, "begin") == 0) {
			ValaMemberAccess* _tmp244_;
			ValaExpression* _tmp245_;
			ValaExpression* _tmp246_;
			ValaSymbol* _tmp247_;
			ValaSymbol* _tmp248_;
			ValaMemberAccess* _tmp249_;
			ValaSymbol* _tmp250_;
			ValaSymbol* _tmp251_;
			_tmp244_ = ma;
			_tmp245_ = vala_member_access_get_inner (_tmp244_);
			_tmp246_ = _tmp245_;
			_tmp247_ = vala_expression_get_symbol_reference (_tmp246_);
			_tmp248_ = _tmp247_;
			_tmp249_ = ma;
			_tmp250_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp249_);
			_tmp251_ = _tmp250_;
			_tmp240_ = _tmp248_ == _tmp251_;
		} else {
			_tmp240_ = FALSE;
		}
		if (_tmp240_) {
			ValaCCodeFunctionCall* _tmp252_;
			ValaCCodeFunctionCall* _tmp253_;
			ValaMethod* _tmp254_;
			ValaList* _tmp255_;
			_tmp252_ = async_call;
			_tmp253_ = _vala_ccode_node_ref0 (_tmp252_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp253_;
			_tmp254_ = m;
			_tmp255_ = vala_method_get_async_begin_parameters (_tmp254_);
			_vala_iterable_unref0 (params);
			params = _tmp255_;
		} else {
			gboolean _tmp256_ = FALSE;
			ValaMemberAccess* _tmp257_;
			const gchar* _tmp258_;
			const gchar* _tmp259_;
			_tmp257_ = ma;
			_tmp258_ = vala_member_access_get_member_name (_tmp257_);
			_tmp259_ = _tmp258_;
			if (g_strcmp0 (_tmp259_, "end") == 0) {
				ValaMemberAccess* _tmp260_;
				ValaExpression* _tmp261_;
				ValaExpression* _tmp262_;
				ValaSymbol* _tmp263_;
				ValaSymbol* _tmp264_;
				ValaMemberAccess* _tmp265_;
				ValaSymbol* _tmp266_;
				ValaSymbol* _tmp267_;
				_tmp260_ = ma;
				_tmp261_ = vala_member_access_get_inner (_tmp260_);
				_tmp262_ = _tmp261_;
				_tmp263_ = vala_expression_get_symbol_reference (_tmp262_);
				_tmp264_ = _tmp263_;
				_tmp265_ = ma;
				_tmp266_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp265_);
				_tmp267_ = _tmp266_;
				_tmp256_ = _tmp264_ == _tmp267_;
			} else {
				_tmp256_ = FALSE;
			}
			if (_tmp256_) {
				ValaCCodeFunctionCall* _tmp268_;
				ValaCCodeFunctionCall* _tmp269_;
				ValaMethod* _tmp270_;
				ValaList* _tmp271_;
				_tmp268_ = finish_call;
				_tmp269_ = _vala_ccode_node_ref0 (_tmp268_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp269_;
				_tmp270_ = m;
				_tmp271_ = vala_method_get_async_end_parameters (_tmp270_);
				_vala_iterable_unref0 (params);
				params = _tmp271_;
			} else {
				gboolean _tmp272_;
				gboolean _tmp273_;
				_tmp272_ = vala_method_call_get_is_yield_expression (expr);
				_tmp273_ = _tmp272_;
				if (!_tmp273_) {
					ValaCCodeFunctionCall* _tmp274_;
					ValaCCodeFunctionCall* _tmp275_;
					ValaMethod* _tmp276_;
					ValaList* _tmp277_;
					_tmp274_ = async_call;
					_tmp275_ = _vala_ccode_node_ref0 (_tmp274_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp275_;
					_tmp276_ = m;
					_tmp277_ = vala_method_get_async_begin_parameters (_tmp276_);
					_vala_iterable_unref0 (params);
					params = _tmp277_;
				} else {
					ValaCCodeFunctionCall* _tmp278_;
					ValaCCodeFunctionCall* _tmp279_;
					GHashFunc _tmp280_;
					GEqualFunc _tmp281_;
					GEqualFunc _tmp282_;
					ValaHashMap* _tmp283_;
					ValaHashMap* _tmp284_;
					ValaMethod* _tmp285_;
					ValaCCodeIdentifier* _tmp286_;
					ValaCCodeIdentifier* _tmp287_;
					ValaCCodeMemberAccess* _tmp288_;
					ValaCCodeMemberAccess* _tmp289_;
					_tmp278_ = finish_call;
					_tmp279_ = _vala_ccode_node_ref0 (_tmp278_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp279_;
					_tmp280_ = g_direct_hash;
					_tmp281_ = g_direct_equal;
					_tmp282_ = g_direct_equal;
					_tmp283_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp280_, _tmp281_, _tmp282_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp283_;
					_tmp284_ = out_arg_map;
					_tmp285_ = m;
					_tmp286_ = vala_ccode_identifier_new ("_data_");
					_tmp287_ = _tmp286_;
					_tmp288_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp287_, "_res_");
					_tmp289_ = _tmp288_;
					vala_map_set ((ValaMap*) _tmp284_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp285_), FALSE)), (ValaCCodeExpression*) _tmp289_);
					_vala_ccode_node_unref0 (_tmp289_);
					_vala_ccode_node_unref0 (_tmp287_);
				}
			}
		}
	}
	_tmp291_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp291_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp292_;
		ValaSymbol* _tmp293_;
		ValaSymbol* _tmp294_;
		_tmp292_ = m;
		_tmp293_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp292_);
		_tmp294_ = _tmp293_;
		_tmp290_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp294_, VALA_TYPE_CLASS);
	} else {
		_tmp290_ = FALSE;
	}
	if (_tmp290_) {
		ValaCodeContext* _tmp295_;
		ValaCodeContext* _tmp296_;
		ValaProfile _tmp297_;
		ValaProfile _tmp298_;
		ValaClass* _tmp310_;
		ValaClass* _tmp311_;
		gboolean _tmp312_;
		gboolean _tmp313_;
		_tmp295_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp296_ = _tmp295_;
		_tmp297_ = vala_code_context_get_profile (_tmp296_);
		_tmp298_ = _tmp297_;
		if (_tmp298_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp299_;
			ValaSymbol* _tmp300_;
			ValaSymbol* _tmp301_;
			gboolean _tmp302_;
			gboolean _tmp303_;
			_tmp299_ = m;
			_tmp300_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp299_);
			_tmp301_ = _tmp300_;
			_tmp302_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp301_, VALA_TYPE_CLASS, ValaClass));
			_tmp303_ = _tmp302_;
			if (!_tmp303_) {
				ValaCCodeFunctionCall* _tmp304_;
				ValaCCodeExpression* _tmp305_;
				ValaCCodeExpression* _tmp306_;
				_tmp304_ = ccall;
				_tmp305_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp306_ = _tmp305_;
				vala_ccode_function_call_add_argument (_tmp304_, _tmp306_);
				_vala_ccode_node_unref0 (_tmp306_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp307_;
			ValaCCodeExpression* _tmp308_;
			ValaCCodeExpression* _tmp309_;
			_tmp307_ = ccall;
			_tmp308_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp309_ = _tmp308_;
			vala_ccode_function_call_add_argument (_tmp307_, _tmp309_);
			_vala_ccode_node_unref0 (_tmp309_);
		}
		_tmp310_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp311_ = _tmp310_;
		_tmp312_ = vala_class_get_is_compact (_tmp311_);
		_tmp313_ = _tmp312_;
		if (!_tmp313_) {
			ValaClass* _tmp314_;
			ValaClass* _tmp315_;
			ValaMethod* _tmp316_;
			ValaSymbol* _tmp317_;
			ValaSymbol* _tmp318_;
			_tmp314_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp315_ = _tmp314_;
			_tmp316_ = m;
			_tmp317_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp316_);
			_tmp318_ = _tmp317_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp315_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp318_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp319_;
					ValaClass* _tmp320_;
					ValaList* _tmp321_;
					ValaList* _tmp322_;
					gint _base_type_size = 0;
					ValaList* _tmp323_;
					gint _tmp324_;
					gint _tmp325_;
					gint _base_type_index = 0;
					_tmp319_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp320_ = _tmp319_;
					_tmp321_ = vala_class_get_base_types (_tmp320_);
					_tmp322_ = _vala_iterable_ref0 (_tmp321_);
					_base_type_list = _tmp322_;
					_tmp323_ = _base_type_list;
					_tmp324_ = vala_collection_get_size ((ValaCollection*) _tmp323_);
					_tmp325_ = _tmp324_;
					_base_type_size = _tmp325_;
					_base_type_index = -1;
					while (TRUE) {
						ValaDataType* base_type = NULL;
						ValaList* _tmp326_;
						gpointer _tmp327_;
						ValaDataType* _tmp328_;
						ValaTypeSymbol* _tmp329_;
						ValaTypeSymbol* _tmp330_;
						_base_type_index = _base_type_index + 1;
						if (!(_base_type_index < _base_type_size)) {
							break;
						}
						_tmp326_ = _base_type_list;
						_tmp327_ = vala_list_get (_tmp326_, _base_type_index);
						base_type = (ValaDataType*) _tmp327_;
						_tmp328_ = base_type;
						_tmp329_ = vala_data_type_get_type_symbol (_tmp328_);
						_tmp330_ = _tmp329_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp330_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp331_;
							gchar* _tmp332_;
							gchar* _tmp333_;
							gboolean _tmp334_;
							ValaHashMap* _tmp340_;
							ValaDataType* _tmp341_;
							ValaList* _tmp342_;
							ValaList* _tmp343_;
							type_parameters = NULL;
							_tmp331_ = m;
							_tmp332_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp331_);
							_tmp333_ = _tmp332_;
							_tmp334_ = g_strcmp0 (_tmp333_, "g_object_new") == 0;
							_g_free0 (_tmp333_);
							if (_tmp334_) {
								ValaDataType* _tmp335_;
								ValaTypeSymbol* _tmp336_;
								ValaTypeSymbol* _tmp337_;
								ValaList* _tmp338_;
								ValaList* _tmp339_;
								_tmp335_ = base_type;
								_tmp336_ = vala_data_type_get_type_symbol (_tmp335_);
								_tmp337_ = _tmp336_;
								_tmp338_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp337_, VALA_TYPE_CLASS, ValaClass));
								_tmp339_ = _vala_iterable_ref0 (_tmp338_);
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp339_;
							}
							_tmp340_ = in_arg_map;
							_tmp341_ = base_type;
							_tmp342_ = vala_data_type_get_type_arguments (_tmp341_);
							_tmp343_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp340_, _tmp342_, (ValaCodeNode*) expr, TRUE, _tmp343_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp344_;
				ValaSymbol* _tmp345_;
				ValaSymbol* _tmp346_;
				ValaClass* _tmp347_;
				type_param_index = 0;
				_tmp344_ = m;
				_tmp345_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp344_);
				_tmp346_ = _tmp345_;
				_tmp347_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp346_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp347_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp348_;
					ValaList* _tmp349_;
					ValaList* _tmp350_;
					gint _type_param_size = 0;
					ValaList* _tmp351_;
					gint _tmp352_;
					gint _tmp353_;
					gint _type_param_index = 0;
					_tmp348_ = cl;
					_tmp349_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp348_);
					_tmp350_ = _vala_iterable_ref0 (_tmp349_);
					_type_param_list = _tmp350_;
					_tmp351_ = _type_param_list;
					_tmp352_ = vala_collection_get_size ((ValaCollection*) _tmp351_);
					_tmp353_ = _tmp352_;
					_type_param_size = _tmp353_;
					_type_param_index = -1;
					while (TRUE) {
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp354_;
						gpointer _tmp355_;
						ValaHashMap* _tmp356_;
						ValaTypeParameter* _tmp357_;
						const gchar* _tmp358_;
						const gchar* _tmp359_;
						gchar* _tmp360_;
						gchar* _tmp361_;
						gchar* _tmp362_;
						gchar* _tmp363_;
						ValaCCodeIdentifier* _tmp364_;
						ValaCCodeIdentifier* _tmp365_;
						ValaHashMap* _tmp366_;
						ValaTypeParameter* _tmp367_;
						const gchar* _tmp368_;
						const gchar* _tmp369_;
						gchar* _tmp370_;
						gchar* _tmp371_;
						gchar* _tmp372_;
						gchar* _tmp373_;
						ValaCCodeIdentifier* _tmp374_;
						ValaCCodeIdentifier* _tmp375_;
						ValaHashMap* _tmp376_;
						ValaTypeParameter* _tmp377_;
						const gchar* _tmp378_;
						const gchar* _tmp379_;
						gchar* _tmp380_;
						gchar* _tmp381_;
						gchar* _tmp382_;
						gchar* _tmp383_;
						ValaCCodeIdentifier* _tmp384_;
						ValaCCodeIdentifier* _tmp385_;
						gint _tmp386_;
						_type_param_index = _type_param_index + 1;
						if (!(_type_param_index < _type_param_size)) {
							break;
						}
						_tmp354_ = _type_param_list;
						_tmp355_ = vala_list_get (_tmp354_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp355_;
						_tmp356_ = in_arg_map;
						_tmp357_ = type_param;
						_tmp358_ = vala_symbol_get_name ((ValaSymbol*) _tmp357_);
						_tmp359_ = _tmp358_;
						_tmp360_ = g_utf8_strdown (_tmp359_, (gssize) -1);
						_tmp361_ = _tmp360_;
						_tmp362_ = g_strdup_printf ("%s_type", _tmp361_);
						_tmp363_ = _tmp362_;
						_tmp364_ = vala_ccode_identifier_new (_tmp363_);
						_tmp365_ = _tmp364_;
						vala_map_set ((ValaMap*) _tmp356_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp365_);
						_vala_ccode_node_unref0 (_tmp365_);
						_g_free0 (_tmp363_);
						_g_free0 (_tmp361_);
						_tmp366_ = in_arg_map;
						_tmp367_ = type_param;
						_tmp368_ = vala_symbol_get_name ((ValaSymbol*) _tmp367_);
						_tmp369_ = _tmp368_;
						_tmp370_ = g_utf8_strdown (_tmp369_, (gssize) -1);
						_tmp371_ = _tmp370_;
						_tmp372_ = g_strdup_printf ("%s_dup_func", _tmp371_);
						_tmp373_ = _tmp372_;
						_tmp374_ = vala_ccode_identifier_new (_tmp373_);
						_tmp375_ = _tmp374_;
						vala_map_set ((ValaMap*) _tmp366_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp375_);
						_vala_ccode_node_unref0 (_tmp375_);
						_g_free0 (_tmp373_);
						_g_free0 (_tmp371_);
						_tmp376_ = in_arg_map;
						_tmp377_ = type_param;
						_tmp378_ = vala_symbol_get_name ((ValaSymbol*) _tmp377_);
						_tmp379_ = _tmp378_;
						_tmp380_ = g_utf8_strdown (_tmp379_, (gssize) -1);
						_tmp381_ = _tmp380_;
						_tmp382_ = g_strdup_printf ("%s_destroy_func", _tmp381_);
						_tmp383_ = _tmp382_;
						_tmp384_ = vala_ccode_identifier_new (_tmp383_);
						_tmp385_ = _tmp384_;
						vala_map_set ((ValaMap*) _tmp376_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp385_);
						_vala_ccode_node_unref0 (_tmp385_);
						_g_free0 (_tmp383_);
						_g_free0 (_tmp381_);
						_tmp386_ = type_param_index;
						type_param_index = _tmp386_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp387_;
			ValaClass* _tmp388_;
			ValaClass* _tmp389_;
			ValaClass* _tmp390_;
			ValaClass* _tmp391_;
			_tmp387_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp388_ = _tmp387_;
			_tmp389_ = vala_class_get_base_class (_tmp388_);
			_tmp390_ = _tmp389_;
			_tmp391_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp390_ == _tmp391_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp392_;
				ValaClass* _tmp393_;
				gchar* _tmp394_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp395_;
				ValaCCodeDeclaration* _tmp396_;
				ValaCCodeDeclaration* _tmp397_;
				const gchar* _tmp398_;
				const gchar* _tmp399_;
				const gchar* _tmp400_;
				const gchar* _tmp401_;
				gchar* _tmp402_;
				gchar* _tmp403_;
				ValaCCodeConstant* _tmp404_;
				ValaCCodeConstant* _tmp405_;
				ValaCCodeVariableDeclarator* _tmp406_;
				ValaCCodeVariableDeclarator* _tmp407_;
				ValaCCodeFunction* _tmp408_;
				ValaCCodeFunction* _tmp409_;
				ValaCCodeDeclaration* _tmp410_;
				ValaCCodeFunctionCall* _tmp411_;
				ValaCCodeIdentifier* _tmp412_;
				ValaCCodeIdentifier* _tmp413_;
				ValaCCodeUnaryExpression* _tmp414_;
				ValaCCodeUnaryExpression* _tmp415_;
				ValaCCodeCastExpression* _tmp416_;
				ValaCCodeCastExpression* _tmp417_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp418_;
				ValaCCodeIdentifier* _tmp419_;
				ValaCCodeFunctionCall* _tmp420_;
				ValaCCodeFunctionCall* _tmp421_;
				ValaCCodeFunctionCall* _tmp422_;
				ValaClass* _tmp423_;
				ValaClass* _tmp424_;
				gchar* _tmp425_;
				gchar* _tmp426_;
				ValaCCodeIdentifier* _tmp427_;
				ValaCCodeIdentifier* _tmp428_;
				ValaCCodeFunctionCall* _tmp429_;
				ValaCCodeFunctionCall* _tmp430_;
				_tmp392_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp393_ = _tmp392_;
				_tmp394_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp393_, NULL);
				class_prefix = _tmp394_;
				_tmp395_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp395_;
				_tmp396_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp396_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp397_ = funcs;
				_tmp398_ = class_prefix;
				_tmp399_ = class_prefix;
				_tmp400_ = class_prefix;
				_tmp401_ = class_prefix;
				_tmp402_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp398_, _tmp399_, _tmp400_, _tmp401_);
				_tmp403_ = _tmp402_;
				_tmp404_ = vala_ccode_constant_new (_tmp403_);
				_tmp405_ = _tmp404_;
				_tmp406_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp405_, NULL);
				_tmp407_ = _tmp406_;
				vala_ccode_declaration_add_declarator (_tmp397_, (ValaCCodeDeclarator*) _tmp407_);
				_vala_ccode_node_unref0 (_tmp407_);
				_vala_ccode_node_unref0 (_tmp405_);
				_g_free0 (_tmp403_);
				_tmp408_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp409_ = _tmp408_;
				_tmp410_ = funcs;
				vala_ccode_function_add_statement (_tmp409_, (ValaCCodeNode*) _tmp410_);
				_tmp411_ = ccall;
				_tmp412_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp413_ = _tmp412_;
				_tmp414_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp413_);
				_tmp415_ = _tmp414_;
				_tmp416_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp415_, "GSourceFuncs *");
				_tmp417_ = _tmp416_;
				vala_ccode_function_call_add_argument (_tmp411_, (ValaCCodeExpression*) _tmp417_);
				_vala_ccode_node_unref0 (_tmp417_);
				_vala_ccode_node_unref0 (_tmp415_);
				_vala_ccode_node_unref0 (_tmp413_);
				_tmp418_ = vala_ccode_identifier_new ("sizeof");
				_tmp419_ = _tmp418_;
				_tmp420_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp419_);
				_tmp421_ = _tmp420_;
				_vala_ccode_node_unref0 (_tmp419_);
				csizeof = _tmp421_;
				_tmp422_ = csizeof;
				_tmp423_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp424_ = _tmp423_;
				_tmp425_ = vala_get_ccode_name ((ValaCodeNode*) _tmp424_);
				_tmp426_ = _tmp425_;
				_tmp427_ = vala_ccode_identifier_new (_tmp426_);
				_tmp428_ = _tmp427_;
				vala_ccode_function_call_add_argument (_tmp422_, (ValaCCodeExpression*) _tmp428_);
				_vala_ccode_node_unref0 (_tmp428_);
				_g_free0 (_tmp426_);
				_tmp429_ = ccall;
				_tmp430_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp429_, (ValaCCodeExpression*) _tmp430_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp431_ = FALSE;
		ValaMethod* _tmp432_;
		_tmp432_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp432_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp433_;
			ValaSymbol* _tmp434_;
			ValaSymbol* _tmp435_;
			_tmp433_ = m;
			_tmp434_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp433_);
			_tmp435_ = _tmp434_;
			_tmp431_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp435_, VALA_TYPE_STRUCT);
		} else {
			_tmp431_ = FALSE;
		}
		if (_tmp431_) {
			ValaCCodeFunctionCall* _tmp436_;
			ValaCCodeExpression* _tmp437_;
			ValaCCodeExpression* _tmp438_;
			_tmp436_ = ccall;
			_tmp437_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp438_ = _tmp437_;
			vala_ccode_function_call_add_argument (_tmp436_, _tmp438_);
			_vala_ccode_node_unref0 (_tmp438_);
		} else {
			gboolean _tmp439_ = FALSE;
			gboolean _tmp440_ = FALSE;
			gboolean _tmp441_ = FALSE;
			gboolean _tmp442_ = FALSE;
			ValaMethod* _tmp443_;
			_tmp443_ = m;
			if (_tmp443_ != NULL) {
				ValaMethod* _tmp444_;
				_tmp444_ = m;
				_tmp442_ = vala_method_has_type_parameters (_tmp444_);
			} else {
				_tmp442_ = FALSE;
			}
			if (_tmp442_) {
				ValaMethod* _tmp445_;
				_tmp445_ = m;
				_tmp441_ = !vala_get_ccode_has_generic_type_parameter (_tmp445_);
			} else {
				_tmp441_ = FALSE;
			}
			if (_tmp441_) {
				ValaMethod* _tmp446_;
				_tmp446_ = m;
				_tmp440_ = !vala_get_ccode_simple_generics (_tmp446_);
			} else {
				_tmp440_ = FALSE;
			}
			if (_tmp440_) {
				gboolean _tmp447_ = FALSE;
				ValaCCodeFunctionCall* _tmp448_;
				ValaCCodeFunctionCall* _tmp449_;
				_tmp448_ = ccall;
				_tmp449_ = finish_call;
				if (_tmp448_ != _tmp449_) {
					_tmp447_ = TRUE;
				} else {
					gboolean _tmp450_;
					gboolean _tmp451_;
					_tmp450_ = vala_method_call_get_is_yield_expression (expr);
					_tmp451_ = _tmp450_;
					_tmp447_ = _tmp451_;
				}
				_tmp439_ = _tmp447_;
			} else {
				_tmp439_ = FALSE;
			}
			if (_tmp439_) {
				ValaHashMap* _tmp452_;
				ValaMemberAccess* _tmp453_;
				ValaList* _tmp454_;
				_tmp452_ = in_arg_map;
				_tmp453_ = ma;
				_tmp454_ = vala_member_access_get_type_arguments (_tmp453_);
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp452_, _tmp454_, (ValaCodeNode*) expr, FALSE, NULL);
			}
		}
	}
	_tmp455_ = ccall;
	_tmp456_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp455_);
	ccall_expr = _tmp456_;
	_tmp458_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp458_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaCodeContext* _tmp459_;
		ValaCodeContext* _tmp460_;
		ValaProfile _tmp461_;
		ValaProfile _tmp462_;
		_tmp459_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp460_ = _tmp459_;
		_tmp461_ = vala_code_context_get_profile (_tmp460_);
		_tmp462_ = _tmp461_;
		_tmp457_ = _tmp462_ != VALA_PROFILE_POSIX;
	} else {
		_tmp457_ = FALSE;
	}
	if (_tmp457_) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp463_;
		ValaExpression* _tmp464_;
		ValaExpression* _tmp465_;
		ValaDataType* _tmp466_;
		ValaDataType* _tmp467_;
		ValaArrayType* _tmp468_;
		ValaHashMap* _tmp469_;
		ValaArrayType* _tmp470_;
		ValaDataType* _tmp471_;
		ValaDataType* _tmp472_;
		gchar* _tmp473_;
		gchar* _tmp474_;
		ValaCCodeIdentifier* _tmp475_;
		ValaCCodeIdentifier* _tmp476_;
		_tmp463_ = ma;
		_tmp464_ = vala_member_access_get_inner (_tmp463_);
		_tmp465_ = _tmp464_;
		_tmp466_ = vala_expression_get_value_type (_tmp465_);
		_tmp467_ = _tmp466_;
		_tmp468_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp467_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp468_;
		_tmp469_ = in_arg_map;
		_tmp470_ = array_type;
		_tmp471_ = vala_array_type_get_element_type (_tmp470_);
		_tmp472_ = _tmp471_;
		_tmp473_ = vala_get_ccode_name ((ValaCodeNode*) _tmp472_);
		_tmp474_ = _tmp473_;
		_tmp475_ = vala_ccode_identifier_new (_tmp474_);
		_tmp476_ = _tmp475_;
		vala_map_set ((ValaMap*) _tmp469_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp476_);
		_vala_ccode_node_unref0 (_tmp476_);
		_g_free0 (_tmp474_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp477_;
		_tmp477_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp477_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp478_;
			_tmp478_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp478_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp479_;
				ValaExpression* _tmp480_;
				ValaExpression* _tmp481_;
				ValaTargetValue* _tmp482_;
				ValaTargetValue* _tmp483_;
				ValaTargetValue* _tmp484_;
				ValaTargetValue* _tmp485_;
				_tmp479_ = ma;
				_tmp480_ = vala_member_access_get_inner (_tmp479_);
				_tmp481_ = _tmp480_;
				_tmp482_ = vala_expression_get_target_value (_tmp481_);
				_tmp483_ = _tmp482_;
				_tmp484_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp483_, (ValaCodeNode*) expr);
				_tmp485_ = _tmp484_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp485_);
				_vala_target_value_unref0 (_tmp485_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp487_ = m;
	if (_tmp487_ != NULL) {
		ValaMethod* _tmp488_;
		gboolean _tmp489_;
		gboolean _tmp490_;
		_tmp488_ = m;
		_tmp489_ = vala_method_get_is_async_callback (_tmp488_);
		_tmp490_ = _tmp489_;
		_tmp486_ = _tmp490_;
	} else {
		_tmp486_ = FALSE;
	}
	if (_tmp486_) {
		ValaMethod* _tmp491_;
		ValaMethod* _tmp492_;
		gboolean _tmp493_;
		gboolean _tmp494_;
		ValaHashMap* _tmp508_;
		ValaMethod* _tmp509_;
		ValaCCodeExpression* _tmp510_;
		ValaHashMap* _tmp511_;
		ValaMethod* _tmp512_;
		ValaCCodeExpression* _tmp513_;
		_tmp491_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp492_ = _tmp491_;
		_tmp493_ = vala_method_get_closure (_tmp492_);
		_tmp494_ = _tmp493_;
		if (_tmp494_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp495_;
			ValaSymbol* _tmp496_;
			ValaSymbol* _tmp497_;
			ValaBlock* _tmp498_;
			ValaBlock* _tmp499_;
			ValaBlock* _tmp500_;
			ValaBlock* _tmp501_;
			gchar* _tmp502_;
			gchar* _tmp503_;
			ValaCCodeExpression* _tmp504_;
			ValaCCodeExpression* _tmp505_;
			ValaCCodeMemberAccess* _tmp506_;
			_tmp495_ = m;
			_tmp496_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp495_);
			_tmp497_ = _tmp496_;
			_tmp498_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp497_, VALA_TYPE_METHOD, ValaMethod));
			_tmp499_ = _tmp498_;
			_tmp500_ = _vala_code_node_ref0 (_tmp499_);
			block = _tmp500_;
			_tmp501_ = block;
			_tmp502_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp501_));
			_tmp503_ = _tmp502_;
			_tmp504_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp503_);
			_tmp505_ = _tmp504_;
			_tmp506_ = vala_ccode_member_access_new_pointer (_tmp505_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp506_;
			_vala_ccode_node_unref0 (_tmp505_);
			_g_free0 (_tmp503_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp507_;
			_tmp507_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp507_;
		}
		_tmp508_ = in_arg_map;
		_tmp509_ = m;
		_tmp510_ = instance;
		vala_map_set ((ValaMap*) _tmp508_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp509_), FALSE)), _tmp510_);
		_tmp511_ = out_arg_map;
		_tmp512_ = m;
		_tmp513_ = instance;
		vala_map_set ((ValaMap*) _tmp511_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp512_), FALSE)), _tmp513_);
	} else {
		gboolean _tmp514_ = FALSE;
		gboolean _tmp515_ = FALSE;
		ValaMethod* _tmp516_;
		_tmp516_ = m;
		if (_tmp516_ != NULL) {
			ValaMethod* _tmp517_;
			ValaMemberBinding _tmp518_;
			ValaMemberBinding _tmp519_;
			_tmp517_ = m;
			_tmp518_ = vala_method_get_binding (_tmp517_);
			_tmp519_ = _tmp518_;
			_tmp515_ = _tmp519_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp515_ = FALSE;
		}
		if (_tmp515_) {
			ValaMethod* _tmp520_;
			_tmp520_ = m;
			_tmp514_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp520_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp514_ = FALSE;
		}
		if (_tmp514_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp521_;
			ValaExpression* _tmp522_;
			ValaExpression* _tmp523_;
			ValaTargetValue* _tmp524_;
			ValaTargetValue* _tmp525_;
			ValaTargetValue* _tmp526_;
			gboolean _tmp527_ = FALSE;
			gboolean _tmp528_ = FALSE;
			ValaMemberAccess* _tmp529_;
			const gchar* _tmp530_;
			const gchar* _tmp531_;
			ValaTargetValue* _tmp553_;
			ValaCCodeExpression* _tmp554_;
			ValaCCodeExpression* _tmp555_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp556_;
			ValaSymbol* _tmp557_;
			ValaSymbol* _tmp558_;
			ValaStruct* _tmp559_;
			gboolean _tmp560_ = FALSE;
			ValaStruct* _tmp561_;
			gboolean _tmp569_;
			gboolean _tmp570_;
			_tmp521_ = ma;
			_tmp522_ = vala_member_access_get_inner (_tmp521_);
			_tmp523_ = _tmp522_;
			_tmp524_ = vala_expression_get_target_value (_tmp523_);
			_tmp525_ = _tmp524_;
			_tmp526_ = _vala_target_value_ref0 (_tmp525_);
			instance_value = _tmp526_;
			_tmp529_ = ma;
			_tmp530_ = vala_member_access_get_member_name (_tmp529_);
			_tmp531_ = _tmp530_;
			if (g_strcmp0 (_tmp531_, "begin") == 0) {
				_tmp528_ = TRUE;
			} else {
				ValaMemberAccess* _tmp532_;
				const gchar* _tmp533_;
				const gchar* _tmp534_;
				_tmp532_ = ma;
				_tmp533_ = vala_member_access_get_member_name (_tmp532_);
				_tmp534_ = _tmp533_;
				_tmp528_ = g_strcmp0 (_tmp534_, "end") == 0;
			}
			if (_tmp528_) {
				ValaMemberAccess* _tmp535_;
				ValaExpression* _tmp536_;
				ValaExpression* _tmp537_;
				ValaSymbol* _tmp538_;
				ValaSymbol* _tmp539_;
				ValaMemberAccess* _tmp540_;
				ValaSymbol* _tmp541_;
				ValaSymbol* _tmp542_;
				_tmp535_ = ma;
				_tmp536_ = vala_member_access_get_inner (_tmp535_);
				_tmp537_ = _tmp536_;
				_tmp538_ = vala_expression_get_symbol_reference (_tmp537_);
				_tmp539_ = _tmp538_;
				_tmp540_ = ma;
				_tmp541_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp540_);
				_tmp542_ = _tmp541_;
				_tmp527_ = _tmp539_ == _tmp542_;
			} else {
				_tmp527_ = FALSE;
			}
			if (_tmp527_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp543_;
				ValaExpression* _tmp544_;
				ValaExpression* _tmp545_;
				ValaMemberAccess* _tmp546_;
				ValaMemberAccess* _tmp547_;
				ValaExpression* _tmp548_;
				ValaExpression* _tmp549_;
				ValaTargetValue* _tmp550_;
				ValaTargetValue* _tmp551_;
				ValaTargetValue* _tmp552_;
				_tmp543_ = ma;
				_tmp544_ = vala_member_access_get_inner (_tmp543_);
				_tmp545_ = _tmp544_;
				_tmp546_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp545_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp546_;
				_tmp547_ = inner_ma;
				_tmp548_ = vala_member_access_get_inner (_tmp547_);
				_tmp549_ = _tmp548_;
				_tmp550_ = vala_expression_get_target_value (_tmp549_);
				_tmp551_ = _tmp550_;
				_tmp552_ = _vala_target_value_ref0 (_tmp551_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp552_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp553_ = instance_value;
			_tmp554_ = vala_get_cvalue_ (_tmp553_);
			_tmp555_ = _vala_ccode_node_ref0 (_tmp554_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp555_;
			_tmp556_ = m;
			_tmp557_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp556_);
			_tmp558_ = _tmp557_;
			_tmp559_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp558_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp558_) : NULL);
			st = _tmp559_;
			_tmp561_ = st;
			if (_tmp561_ != NULL) {
				ValaStruct* _tmp562_;
				_tmp562_ = st;
				_tmp560_ = !vala_struct_is_simple_type (_tmp562_);
			} else {
				_tmp560_ = FALSE;
			}
			if (_tmp560_) {
				ValaTargetValue* _tmp563_;
				ValaTargetValue* _tmp566_;
				ValaCCodeExpression* _tmp567_;
				ValaCCodeUnaryExpression* _tmp568_;
				_tmp563_ = instance_value;
				if (!vala_get_lvalue (_tmp563_)) {
					ValaTargetValue* _tmp564_;
					ValaTargetValue* _tmp565_;
					_tmp564_ = instance_value;
					_tmp565_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp564_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp565_;
				}
				_tmp566_ = instance_value;
				_tmp567_ = vala_get_cvalue_ (_tmp566_);
				_tmp568_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp567_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp568_;
			}
			_tmp569_ = vala_method_call_get_is_yield_expression (expr);
			_tmp570_ = _tmp569_;
			if (_tmp570_) {
				ValaHashMap* _tmp571_;
				ValaMethod* _tmp572_;
				ValaCCodeExpression* _tmp573_;
				ValaMethod* _tmp574_;
				_tmp571_ = in_arg_map;
				_tmp572_ = m;
				_tmp573_ = instance;
				vala_map_set ((ValaMap*) _tmp571_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp572_), FALSE)), _tmp573_);
				_tmp574_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp574_)) {
					ValaHashMap* _tmp575_;
					ValaMethod* _tmp576_;
					ValaCCodeExpression* _tmp577_;
					_tmp575_ = out_arg_map;
					_tmp576_ = m;
					_tmp577_ = instance;
					vala_map_set ((ValaMap*) _tmp575_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp576_), FALSE)), _tmp577_);
				}
			} else {
				gboolean _tmp578_ = FALSE;
				ValaMemberAccess* _tmp579_;
				const gchar* _tmp580_;
				const gchar* _tmp581_;
				_tmp579_ = ma;
				_tmp580_ = vala_member_access_get_member_name (_tmp579_);
				_tmp581_ = _tmp580_;
				if (g_strcmp0 (_tmp581_, "end") != 0) {
					_tmp578_ = TRUE;
				} else {
					ValaMethod* _tmp582_;
					_tmp582_ = m;
					_tmp578_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp582_);
				}
				if (_tmp578_) {
					ValaHashMap* _tmp583_;
					ValaMethod* _tmp584_;
					ValaCCodeExpression* _tmp585_;
					ValaHashMap* _tmp586_;
					ValaMethod* _tmp587_;
					ValaCCodeExpression* _tmp588_;
					_tmp583_ = out_arg_map;
					_tmp584_ = m;
					_tmp585_ = instance;
					vala_map_set ((ValaMap*) _tmp583_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp584_), FALSE)), _tmp585_);
					_tmp586_ = in_arg_map;
					_tmp587_ = m;
					_tmp588_ = instance;
					vala_map_set ((ValaMap*) _tmp586_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp587_), FALSE)), _tmp588_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp589_ = FALSE;
			ValaMethod* _tmp590_;
			_tmp590_ = m;
			if (_tmp590_ != NULL) {
				ValaMethod* _tmp591_;
				ValaMemberBinding _tmp592_;
				ValaMemberBinding _tmp593_;
				_tmp591_ = m;
				_tmp592_ = vala_method_get_binding (_tmp591_);
				_tmp593_ = _tmp592_;
				_tmp589_ = _tmp593_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp589_ = FALSE;
			}
			if (_tmp589_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp594_;
				ValaSymbol* _tmp595_;
				ValaSymbol* _tmp596_;
				ValaClass* _tmp597_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp598_;
				gchar* _tmp599_;
				gchar* _tmp600_;
				ValaCCodeIdentifier* _tmp601_;
				ValaCCodeIdentifier* _tmp602_;
				ValaCCodeFunctionCall* _tmp603_;
				ValaCCodeFunctionCall* _tmp604_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp605_;
				ValaExpression* _tmp606_;
				ValaExpression* _tmp607_;
				ValaCCodeFunctionCall* _tmp630_;
				ValaCCodeExpression* _tmp631_;
				ValaHashMap* _tmp632_;
				ValaMethod* _tmp633_;
				ValaCCodeFunctionCall* _tmp634_;
				ValaHashMap* _tmp635_;
				ValaMethod* _tmp636_;
				ValaCCodeFunctionCall* _tmp637_;
				_tmp594_ = m;
				_tmp595_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp594_);
				_tmp596_ = _tmp595_;
				_tmp597_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp596_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp597_;
				_tmp598_ = cl;
				_tmp599_ = vala_get_ccode_class_type_function (_tmp598_);
				_tmp600_ = _tmp599_;
				_tmp601_ = vala_ccode_identifier_new (_tmp600_);
				_tmp602_ = _tmp601_;
				_tmp603_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp602_);
				_tmp604_ = _tmp603_;
				_vala_ccode_node_unref0 (_tmp602_);
				_g_free0 (_tmp600_);
				cast = _tmp604_;
				_tmp605_ = ma;
				_tmp606_ = vala_member_access_get_inner (_tmp605_);
				_tmp607_ = _tmp606_;
				if (_tmp607_ == NULL) {
					ValaDataType* _tmp608_;
					_tmp608_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					if (_tmp608_ == NULL) {
						ValaCCodeIdentifier* _tmp609_;
						_tmp609_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp609_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp610_;
						ValaCCodeIdentifier* _tmp611_;
						ValaCCodeFunctionCall* _tmp612_;
						ValaCCodeFunctionCall* _tmp613_;
						ValaCCodeFunctionCall* _tmp614_;
						ValaCCodeExpression* _tmp615_;
						ValaCCodeExpression* _tmp616_;
						ValaCCodeFunctionCall* _tmp617_;
						ValaCCodeExpression* _tmp618_;
						_tmp610_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp611_ = _tmp610_;
						_tmp612_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp611_);
						_tmp613_ = _tmp612_;
						_vala_ccode_node_unref0 (_tmp611_);
						k = _tmp613_;
						_tmp614_ = k;
						_tmp615_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp616_ = _tmp615_;
						vala_ccode_function_call_add_argument (_tmp614_, _tmp616_);
						_vala_ccode_node_unref0 (_tmp616_);
						_tmp617_ = k;
						_tmp618_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp617_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp618_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp619_;
					ValaCCodeIdentifier* _tmp620_;
					ValaCCodeFunctionCall* _tmp621_;
					ValaCCodeFunctionCall* _tmp622_;
					ValaCCodeFunctionCall* _tmp623_;
					ValaMemberAccess* _tmp624_;
					ValaExpression* _tmp625_;
					ValaExpression* _tmp626_;
					ValaCCodeExpression* _tmp627_;
					ValaCCodeFunctionCall* _tmp628_;
					ValaCCodeExpression* _tmp629_;
					_tmp619_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp620_ = _tmp619_;
					_tmp621_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp620_);
					_tmp622_ = _tmp621_;
					_vala_ccode_node_unref0 (_tmp620_);
					k = _tmp622_;
					_tmp623_ = k;
					_tmp624_ = ma;
					_tmp625_ = vala_member_access_get_inner (_tmp624_);
					_tmp626_ = _tmp625_;
					_tmp627_ = vala_get_cvalue (_tmp626_);
					vala_ccode_function_call_add_argument (_tmp623_, _tmp627_);
					_tmp628_ = k;
					_tmp629_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp628_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp629_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp630_ = cast;
				_tmp631_ = klass;
				vala_ccode_function_call_add_argument (_tmp630_, _tmp631_);
				_tmp632_ = in_arg_map;
				_tmp633_ = m;
				_tmp634_ = cast;
				vala_map_set ((ValaMap*) _tmp632_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp633_), FALSE)), (ValaCCodeExpression*) _tmp634_);
				_tmp635_ = out_arg_map;
				_tmp636_ = m;
				_tmp637_ = cast;
				vala_map_set ((ValaMap*) _tmp635_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp636_), FALSE)), (ValaCCodeExpression*) _tmp637_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp639_ = m;
	if (_tmp639_ != NULL) {
		ValaMethod* _tmp640_;
		_tmp640_ = m;
		_tmp638_ = vala_get_ccode_has_generic_type_parameter (_tmp640_);
	} else {
		_tmp638_ = FALSE;
	}
	if (_tmp638_) {
		ValaMethod* _tmp641_;
		_tmp641_ = m;
		if (vala_method_has_type_parameters (_tmp641_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp642_;
				ValaList* _tmp643_;
				ValaList* _tmp644_;
				gint _type_arg_size = 0;
				ValaList* _tmp645_;
				gint _tmp646_;
				gint _tmp647_;
				gint _type_arg_index = 0;
				_tmp642_ = ma;
				_tmp643_ = vala_member_access_get_type_arguments (_tmp642_);
				_tmp644_ = _vala_iterable_ref0 (_tmp643_);
				_type_arg_list = _tmp644_;
				_tmp645_ = _type_arg_list;
				_tmp646_ = vala_collection_get_size ((ValaCollection*) _tmp645_);
				_tmp647_ = _tmp646_;
				_type_arg_size = _tmp647_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp648_;
					gpointer _tmp649_;
					gboolean _tmp650_ = FALSE;
					gboolean _tmp651_ = FALSE;
					gboolean _tmp652_ = FALSE;
					ValaMethod* _tmp653_;
					ValaHashMap* _tmp661_;
					ValaMethod* _tmp662_;
					ValaDataType* _tmp663_;
					gchar* _tmp664_;
					gchar* _tmp665_;
					ValaCCodeIdentifier* _tmp666_;
					ValaCCodeIdentifier* _tmp667_;
					gint _tmp668_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp648_ = _type_arg_list;
					_tmp649_ = vala_list_get (_tmp648_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp649_;
					_tmp653_ = m;
					if (vala_get_ccode_simple_generics (_tmp653_)) {
						ValaDataType* _tmp654_;
						_tmp654_ = type_arg;
						_tmp652_ = vala_data_type_is_real_struct_type (_tmp654_);
					} else {
						_tmp652_ = FALSE;
					}
					if (_tmp652_) {
						ValaDataType* _tmp655_;
						gboolean _tmp656_;
						gboolean _tmp657_;
						_tmp655_ = type_arg;
						_tmp656_ = vala_data_type_get_nullable (_tmp655_);
						_tmp657_ = _tmp656_;
						_tmp651_ = !_tmp657_;
					} else {
						_tmp651_ = FALSE;
					}
					if (_tmp651_) {
						ValaDataType* _tmp658_;
						_tmp658_ = type_arg;
						_tmp650_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp658_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp650_ = FALSE;
					}
					if (_tmp650_) {
						ValaDataType* _tmp659_;
						ValaPointerType* _tmp660_;
						_tmp659_ = type_arg;
						_tmp660_ = vala_pointer_type_new (_tmp659_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp660_;
					}
					_tmp661_ = in_arg_map;
					_tmp662_ = m;
					_tmp663_ = type_arg;
					_tmp664_ = vala_get_ccode_name ((ValaCodeNode*) _tmp663_);
					_tmp665_ = _tmp664_;
					_tmp666_ = vala_ccode_identifier_new (_tmp665_);
					_tmp667_ = _tmp666_;
					vala_map_set ((ValaMap*) _tmp661_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp662_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp667_);
					_vala_ccode_node_unref0 (_tmp667_);
					_g_free0 (_tmp665_);
					_tmp668_ = type_param_index;
					type_param_index = _tmp668_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp669_;
				ValaExpression* _tmp670_;
				ValaExpression* _tmp671_;
				ValaDataType* _tmp672_;
				ValaDataType* _tmp673_;
				ValaList* _tmp674_;
				ValaList* _tmp675_;
				gint _type_arg_size = 0;
				ValaList* _tmp676_;
				gint _tmp677_;
				gint _tmp678_;
				gint _type_arg_index = 0;
				_tmp669_ = ma;
				_tmp670_ = vala_member_access_get_inner (_tmp669_);
				_tmp671_ = _tmp670_;
				_tmp672_ = vala_expression_get_value_type (_tmp671_);
				_tmp673_ = _tmp672_;
				_tmp674_ = vala_data_type_get_type_arguments (_tmp673_);
				_tmp675_ = _vala_iterable_ref0 (_tmp674_);
				_type_arg_list = _tmp675_;
				_tmp676_ = _type_arg_list;
				_tmp677_ = vala_collection_get_size ((ValaCollection*) _tmp676_);
				_tmp678_ = _tmp677_;
				_type_arg_size = _tmp678_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp679_;
					gpointer _tmp680_;
					ValaHashMap* _tmp681_;
					ValaMethod* _tmp682_;
					ValaDataType* _tmp683_;
					gchar* _tmp684_;
					gchar* _tmp685_;
					ValaCCodeIdentifier* _tmp686_;
					ValaCCodeIdentifier* _tmp687_;
					gint _tmp688_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp679_ = _type_arg_list;
					_tmp680_ = vala_list_get (_tmp679_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp680_;
					_tmp681_ = in_arg_map;
					_tmp682_ = m;
					_tmp683_ = type_arg;
					_tmp684_ = vala_get_ccode_name ((ValaCodeNode*) _tmp683_);
					_tmp685_ = _tmp684_;
					_tmp686_ = vala_ccode_identifier_new (_tmp685_);
					_tmp687_ = _tmp686_;
					vala_map_set ((ValaMap*) _tmp681_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp682_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp687_);
					_vala_ccode_node_unref0 (_tmp687_);
					_g_free0 (_tmp685_);
					_tmp688_ = type_param_index;
					type_param_index = _tmp688_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp689_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp689_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp690_;
		ValaExpression* _tmp691_;
		ValaExpression* _tmp692_;
		ValaDataType* _tmp693_;
		ValaDataType* _tmp694_;
		ValaArrayType* _tmp695_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp696_;
		ValaCCodeIdentifier* _tmp697_;
		ValaCCodeFunctionCall* _tmp698_;
		ValaCCodeFunctionCall* _tmp699_;
		ValaCCodeFunctionCall* _tmp700_;
		ValaArrayType* _tmp701_;
		ValaDataType* _tmp702_;
		ValaDataType* _tmp703_;
		gchar* _tmp704_;
		gchar* _tmp705_;
		ValaCCodeIdentifier* _tmp706_;
		ValaCCodeIdentifier* _tmp707_;
		ValaHashMap* _tmp708_;
		ValaCCodeFunctionCall* _tmp709_;
		_tmp690_ = ma;
		_tmp691_ = vala_member_access_get_inner (_tmp690_);
		_tmp692_ = _tmp691_;
		_tmp693_ = vala_expression_get_value_type (_tmp692_);
		_tmp694_ = _tmp693_;
		_tmp695_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp694_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp695_;
		_tmp696_ = vala_ccode_identifier_new ("sizeof");
		_tmp697_ = _tmp696_;
		_tmp698_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp697_);
		_tmp699_ = _tmp698_;
		_vala_ccode_node_unref0 (_tmp697_);
		csizeof = _tmp699_;
		_tmp700_ = csizeof;
		_tmp701_ = array_type;
		_tmp702_ = vala_array_type_get_element_type (_tmp701_);
		_tmp703_ = _tmp702_;
		_tmp704_ = vala_get_ccode_name ((ValaCodeNode*) _tmp703_);
		_tmp705_ = _tmp704_;
		_tmp706_ = vala_ccode_identifier_new (_tmp705_);
		_tmp707_ = _tmp706_;
		vala_ccode_function_call_add_argument (_tmp700_, (ValaCCodeExpression*) _tmp707_);
		_vala_ccode_node_unref0 (_tmp707_);
		_g_free0 (_tmp705_);
		_tmp708_ = in_arg_map;
		_tmp709_ = csizeof;
		vala_map_set ((ValaMap*) _tmp708_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp709_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp710_;
		_tmp710_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp710_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaCCodeBaseModuleEmitContext* _tmp711_;
			ValaMethod* _tmp712_;
			ValaMethod* _tmp713_;
			gint param_nr = 0;
			ValaMethod* _tmp775_;
			ValaCCodeBaseModuleEmitContext* _tmp776_;
			_tmp711_ = ((ValaCCodeBaseModule*) self)->emit_context;
			_tmp712_ = m;
			vala_ccode_base_module_emit_context_push_symbol (_tmp711_, (ValaSymbol*) _tmp712_);
			_tmp713_ = m;
			vala_method_clear_parameters (_tmp713_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp714_;
				ValaList* _tmp715_;
				gint _arg_size = 0;
				ValaList* _tmp716_;
				gint _tmp717_;
				gint _tmp718_;
				gint _arg_index = 0;
				_tmp714_ = vala_method_call_get_argument_list (expr);
				_tmp715_ = _vala_iterable_ref0 (_tmp714_);
				_arg_list = _tmp715_;
				_tmp716_ = _arg_list;
				_tmp717_ = vala_collection_get_size ((ValaCollection*) _tmp716_);
				_tmp718_ = _tmp717_;
				_arg_size = _tmp718_;
				_arg_index = -1;
				while (TRUE) {
					ValaExpression* arg = NULL;
					ValaList* _tmp719_;
					gpointer _tmp720_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp721_;
					ValaUnaryExpression* _tmp722_;
					gboolean _tmp723_ = FALSE;
					ValaUnaryExpression* _tmp724_;
					gint _tmp765_;
					_arg_index = _arg_index + 1;
					if (!(_arg_index < _arg_size)) {
						break;
					}
					_tmp719_ = _arg_list;
					_tmp720_ = vala_list_get (_tmp719_, _arg_index);
					arg = (ValaExpression*) _tmp720_;
					_tmp721_ = arg;
					_tmp722_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp721_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp721_) : NULL);
					unary = _tmp722_;
					_tmp724_ = unary;
					if (_tmp724_ != NULL) {
						ValaUnaryExpression* _tmp725_;
						ValaUnaryOperator _tmp726_;
						ValaUnaryOperator _tmp727_;
						_tmp725_ = unary;
						_tmp726_ = vala_unary_expression_get_operator (_tmp725_);
						_tmp727_ = _tmp726_;
						_tmp723_ = _tmp727_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp723_ = FALSE;
					}
					if (_tmp723_) {
						ValaParameter* param = NULL;
						gchar* _tmp728_;
						gchar* _tmp729_;
						ValaUnaryExpression* _tmp730_;
						ValaExpression* _tmp731_;
						ValaExpression* _tmp732_;
						ValaDataType* _tmp733_;
						ValaDataType* _tmp734_;
						ValaParameter* _tmp735_;
						ValaParameter* _tmp736_;
						ValaParameter* _tmp737_;
						ValaMethod* _tmp738_;
						ValaParameter* _tmp739_;
						_tmp728_ = g_strdup_printf ("param%d", param_nr);
						_tmp729_ = _tmp728_;
						_tmp730_ = unary;
						_tmp731_ = vala_unary_expression_get_inner (_tmp730_);
						_tmp732_ = _tmp731_;
						_tmp733_ = vala_expression_get_value_type (_tmp732_);
						_tmp734_ = _tmp733_;
						_tmp735_ = vala_parameter_new (_tmp729_, _tmp734_, NULL);
						_tmp736_ = _tmp735_;
						_g_free0 (_tmp729_);
						param = _tmp736_;
						_tmp737_ = param;
						vala_parameter_set_direction (_tmp737_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp738_ = m;
						_tmp739_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp738_, _tmp739_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp740_ = FALSE;
						ValaUnaryExpression* _tmp741_;
						_tmp741_ = unary;
						if (_tmp741_ != NULL) {
							ValaUnaryExpression* _tmp742_;
							ValaUnaryOperator _tmp743_;
							ValaUnaryOperator _tmp744_;
							_tmp742_ = unary;
							_tmp743_ = vala_unary_expression_get_operator (_tmp742_);
							_tmp744_ = _tmp743_;
							_tmp740_ = _tmp744_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp740_ = FALSE;
						}
						if (_tmp740_) {
							ValaParameter* param = NULL;
							gchar* _tmp745_;
							gchar* _tmp746_;
							ValaUnaryExpression* _tmp747_;
							ValaExpression* _tmp748_;
							ValaExpression* _tmp749_;
							ValaDataType* _tmp750_;
							ValaDataType* _tmp751_;
							ValaParameter* _tmp752_;
							ValaParameter* _tmp753_;
							ValaParameter* _tmp754_;
							ValaMethod* _tmp755_;
							ValaParameter* _tmp756_;
							_tmp745_ = g_strdup_printf ("param%d", param_nr);
							_tmp746_ = _tmp745_;
							_tmp747_ = unary;
							_tmp748_ = vala_unary_expression_get_inner (_tmp747_);
							_tmp749_ = _tmp748_;
							_tmp750_ = vala_expression_get_value_type (_tmp749_);
							_tmp751_ = _tmp750_;
							_tmp752_ = vala_parameter_new (_tmp746_, _tmp751_, NULL);
							_tmp753_ = _tmp752_;
							_g_free0 (_tmp746_);
							param = _tmp753_;
							_tmp754_ = param;
							vala_parameter_set_direction (_tmp754_, VALA_PARAMETER_DIRECTION_REF);
							_tmp755_ = m;
							_tmp756_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp755_, _tmp756_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp757_;
							gchar* _tmp758_;
							gchar* _tmp759_;
							ValaExpression* _tmp760_;
							ValaDataType* _tmp761_;
							ValaDataType* _tmp762_;
							ValaParameter* _tmp763_;
							ValaParameter* _tmp764_;
							_tmp757_ = m;
							_tmp758_ = g_strdup_printf ("param%d", param_nr);
							_tmp759_ = _tmp758_;
							_tmp760_ = arg;
							_tmp761_ = vala_expression_get_value_type (_tmp760_);
							_tmp762_ = _tmp761_;
							_tmp763_ = vala_parameter_new (_tmp759_, _tmp762_, NULL);
							_tmp764_ = _tmp763_;
							vala_callable_add_parameter ((ValaCallable*) _tmp757_, _tmp764_);
							_vala_code_node_unref0 (_tmp764_);
							_g_free0 (_tmp759_);
						}
					}
					_tmp765_ = param_nr;
					param_nr = _tmp765_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp766_;
				ValaList* _tmp767_;
				ValaList* _tmp768_;
				gint _param_size = 0;
				ValaList* _tmp769_;
				gint _tmp770_;
				gint _tmp771_;
				gint _param_index = 0;
				_tmp766_ = m;
				_tmp767_ = vala_callable_get_parameters ((ValaCallable*) _tmp766_);
				_tmp768_ = _vala_iterable_ref0 (_tmp767_);
				_param_list = _tmp768_;
				_tmp769_ = _param_list;
				_tmp770_ = vala_collection_get_size ((ValaCollection*) _tmp769_);
				_tmp771_ = _tmp770_;
				_param_size = _tmp771_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp772_;
					gpointer _tmp773_;
					ValaParameter* _tmp774_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp772_ = _param_list;
					_tmp773_ = vala_list_get (_tmp772_, _param_index);
					param = (ValaParameter*) _tmp773_;
					_tmp774_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp774_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp775_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp775_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
			_tmp776_ = ((ValaCCodeBaseModule*) self)->emit_context;
			vala_ccode_base_module_emit_context_pop_symbol (_tmp776_);
		} else {
			gboolean _tmp777_ = FALSE;
			gboolean _tmp778_ = FALSE;
			ValaMethod* _tmp779_;
			_tmp779_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp779_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp780_;
				ValaCodeContext* _tmp781_;
				ValaProfile _tmp782_;
				ValaProfile _tmp783_;
				_tmp780_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp781_ = _tmp780_;
				_tmp782_ = vala_code_context_get_profile (_tmp781_);
				_tmp783_ = _tmp782_;
				_tmp778_ = _tmp783_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp778_ = FALSE;
			}
			if (_tmp778_) {
				ValaMethod* _tmp784_;
				ValaSymbol* _tmp785_;
				ValaSymbol* _tmp786_;
				_tmp784_ = m;
				_tmp785_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp784_);
				_tmp786_ = _tmp785_;
				_tmp777_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp786_, VALA_TYPE_CLASS);
			} else {
				_tmp777_ = FALSE;
			}
			if (_tmp777_) {
				ValaCCodeFunction* _tmp787_;
				ValaCCodeFunction* _tmp788_;
				ValaCCodeExpression* _tmp789_;
				ValaCCodeExpression* _tmp790_;
				ValaCCodeFunctionCall* _tmp791_;
				ValaClass* _tmp792_;
				ValaClass* _tmp793_;
				gchar* _tmp794_;
				gchar* _tmp795_;
				gchar* _tmp796_;
				gchar* _tmp797_;
				ValaCCodeCastExpression* _tmp798_;
				ValaCCodeCastExpression* _tmp799_;
				ValaMethod* _tmp800_;
				ValaMethod* _tmp801_;
				ValaBlock* _tmp802_;
				ValaBlock* _tmp803_;
				gboolean _tmp804_;
				gboolean _tmp805_;
				gboolean _tmp832_ = FALSE;
				ValaClass* _tmp833_;
				ValaClass* _tmp834_;
				gboolean _tmp835_;
				gboolean _tmp836_;
				_tmp787_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp788_ = _tmp787_;
				_tmp789_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp790_ = _tmp789_;
				_tmp791_ = ccall;
				_tmp792_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp793_ = _tmp792_;
				_tmp794_ = vala_get_ccode_name ((ValaCodeNode*) _tmp793_);
				_tmp795_ = _tmp794_;
				_tmp796_ = g_strconcat (_tmp795_, "*", NULL);
				_tmp797_ = _tmp796_;
				_tmp798_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp791_, _tmp797_);
				_tmp799_ = _tmp798_;
				vala_ccode_function_add_assignment (_tmp788_, _tmp790_, (ValaCCodeExpression*) _tmp799_);
				_vala_ccode_node_unref0 (_tmp799_);
				_g_free0 (_tmp797_);
				_g_free0 (_tmp795_);
				_vala_ccode_node_unref0 (_tmp790_);
				_tmp800_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp801_ = _tmp800_;
				_tmp802_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp801_);
				_tmp803_ = _tmp802_;
				_tmp804_ = vala_block_get_captured (_tmp803_);
				_tmp805_ = _tmp804_;
				if (_tmp805_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp806_;
					ValaClass* _tmp807_;
					ValaObjectType* _tmp808_;
					ValaObjectType* _tmp809_;
					ValaSourceReference* _tmp810_;
					ValaSourceReference* _tmp811_;
					ValaCCodeExpression* _tmp812_;
					ValaCCodeExpression* _tmp813_;
					ValaCCodeFunctionCall* _tmp814_;
					ValaCCodeFunctionCall* _tmp815_;
					ValaCCodeFunctionCall* _tmp816_;
					ValaCCodeExpression* _tmp817_;
					ValaCCodeExpression* _tmp818_;
					ValaCCodeFunction* _tmp819_;
					ValaCCodeFunction* _tmp820_;
					ValaMethod* _tmp821_;
					ValaMethod* _tmp822_;
					ValaBlock* _tmp823_;
					ValaBlock* _tmp824_;
					gchar* _tmp825_;
					gchar* _tmp826_;
					ValaCCodeExpression* _tmp827_;
					ValaCCodeExpression* _tmp828_;
					ValaCCodeMemberAccess* _tmp829_;
					ValaCCodeMemberAccess* _tmp830_;
					ValaCCodeFunctionCall* _tmp831_;
					_tmp806_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp807_ = _tmp806_;
					_tmp808_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp807_);
					_tmp809_ = _tmp808_;
					_tmp810_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp811_ = _tmp810_;
					_tmp812_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp809_, _tmp811_, FALSE);
					_tmp813_ = _tmp812_;
					_tmp814_ = vala_ccode_function_call_new (_tmp813_);
					_tmp815_ = _tmp814_;
					_vala_ccode_node_unref0 (_tmp813_);
					_vala_code_node_unref0 (_tmp809_);
					ref_call = _tmp815_;
					_tmp816_ = ref_call;
					_tmp817_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp818_ = _tmp817_;
					vala_ccode_function_call_add_argument (_tmp816_, _tmp818_);
					_vala_ccode_node_unref0 (_tmp818_);
					_tmp819_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp820_ = _tmp819_;
					_tmp821_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp822_ = _tmp821_;
					_tmp823_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp822_);
					_tmp824_ = _tmp823_;
					_tmp825_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp824_));
					_tmp826_ = _tmp825_;
					_tmp827_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp826_);
					_tmp828_ = _tmp827_;
					_tmp829_ = vala_ccode_member_access_new_pointer (_tmp828_, "self");
					_tmp830_ = _tmp829_;
					_tmp831_ = ref_call;
					vala_ccode_function_add_assignment (_tmp820_, (ValaCCodeExpression*) _tmp830_, (ValaCCodeExpression*) _tmp831_);
					_vala_ccode_node_unref0 (_tmp830_);
					_vala_ccode_node_unref0 (_tmp828_);
					_g_free0 (_tmp826_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp833_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp834_ = _tmp833_;
				_tmp835_ = vala_class_get_is_compact (_tmp834_);
				_tmp836_ = _tmp835_;
				if (!_tmp836_) {
					ValaClass* _tmp837_;
					ValaClass* _tmp838_;
					_tmp837_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp838_ = _tmp837_;
					_tmp832_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp838_);
				} else {
					_tmp832_ = FALSE;
				}
				if (_tmp832_) {
					gchar** suffices = NULL;
					gchar* _tmp839_;
					gchar* _tmp840_;
					gchar* _tmp841_;
					gchar** _tmp842_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp839_ = g_strdup ("type");
					_tmp840_ = g_strdup ("dup_func");
					_tmp841_ = g_strdup ("destroy_func");
					_tmp842_ = g_new0 (gchar*, 3 + 1);
					_tmp842_[0] = _tmp839_;
					_tmp842_[1] = _tmp840_;
					_tmp842_[2] = _tmp841_;
					suffices = _tmp842_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp843_;
						ValaClass* _tmp844_;
						ValaList* _tmp845_;
						ValaList* _tmp846_;
						gint _type_param_size = 0;
						ValaList* _tmp847_;
						gint _tmp848_;
						gint _tmp849_;
						gint _type_param_index = 0;
						_tmp843_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp844_ = _tmp843_;
						_tmp845_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp844_);
						_tmp846_ = _vala_iterable_ref0 (_tmp845_);
						_type_param_list = _tmp846_;
						_tmp847_ = _type_param_list;
						_tmp848_ = vala_collection_get_size ((ValaCollection*) _tmp847_);
						_tmp849_ = _tmp848_;
						_type_param_size = _tmp849_;
						_type_param_index = -1;
						while (TRUE) {
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp850_;
							gpointer _tmp851_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp852_;
							ValaCCodeIdentifier* _tmp853_;
							ValaCCodeMemberAccess* _tmp854_;
							ValaCCodeMemberAccess* _tmp855_;
							gchar** _tmp856_;
							gint _tmp856__length1;
							_type_param_index = _type_param_index + 1;
							if (!(_type_param_index < _type_param_size)) {
								break;
							}
							_tmp850_ = _type_param_list;
							_tmp851_ = vala_list_get (_tmp850_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp851_;
							_tmp852_ = vala_ccode_identifier_new ("self");
							_tmp853_ = _tmp852_;
							_tmp854_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp853_, "priv");
							_tmp855_ = _tmp854_;
							_vala_ccode_node_unref0 (_tmp853_);
							priv_access = _tmp855_;
							_tmp856_ = suffices;
							_tmp856__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp856_;
								suffix_collection_length1 = _tmp856__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp857_;
									gchar* suffix = NULL;
									_tmp857_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp857_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp858_;
										const gchar* _tmp859_;
										const gchar* _tmp860_;
										gchar* _tmp861_;
										gchar* _tmp862_;
										const gchar* _tmp863_;
										gchar* _tmp864_;
										gchar* _tmp865_;
										ValaCCodeIdentifier* _tmp866_;
										ValaCCodeIdentifier* _tmp867_;
										ValaCCodeFunction* _tmp868_;
										ValaCCodeFunction* _tmp869_;
										ValaCCodeMemberAccess* _tmp870_;
										ValaCCodeIdentifier* _tmp871_;
										const gchar* _tmp872_;
										const gchar* _tmp873_;
										ValaCCodeMemberAccess* _tmp874_;
										ValaCCodeMemberAccess* _tmp875_;
										ValaCCodeIdentifier* _tmp876_;
										_tmp858_ = type_param;
										_tmp859_ = vala_symbol_get_name ((ValaSymbol*) _tmp858_);
										_tmp860_ = _tmp859_;
										_tmp861_ = g_utf8_strdown (_tmp860_, (gssize) -1);
										_tmp862_ = _tmp861_;
										_tmp863_ = suffix;
										_tmp864_ = g_strdup_printf ("%s_%s", _tmp862_, _tmp863_);
										_tmp865_ = _tmp864_;
										_tmp866_ = vala_ccode_identifier_new (_tmp865_);
										_tmp867_ = _tmp866_;
										_g_free0 (_tmp865_);
										_g_free0 (_tmp862_);
										param_name = _tmp867_;
										_tmp868_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp869_ = _tmp868_;
										_tmp870_ = priv_access;
										_tmp871_ = param_name;
										_tmp872_ = vala_ccode_identifier_get_name (_tmp871_);
										_tmp873_ = _tmp872_;
										_tmp874_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp870_, _tmp873_);
										_tmp875_ = _tmp874_;
										_tmp876_ = param_name;
										vala_ccode_function_add_assignment (_tmp869_, (ValaCCodeExpression*) _tmp875_, (ValaCCodeExpression*) _tmp876_);
										_vala_ccode_node_unref0 (_tmp875_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp877_ = params;
	_tmp878_ = vala_iterable_iterator ((ValaIterable*) _tmp877_);
	params_it = _tmp878_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp879_;
		ValaList* _tmp880_;
		gint _arg_size = 0;
		ValaList* _tmp881_;
		gint _tmp882_;
		gint _tmp883_;
		gint _arg_index = 0;
		_tmp879_ = vala_method_call_get_argument_list (expr);
		_tmp880_ = _vala_iterable_ref0 (_tmp879_);
		_arg_list = _tmp880_;
		_tmp881_ = _arg_list;
		_tmp882_ = vala_collection_get_size ((ValaCollection*) _tmp881_);
		_tmp883_ = _tmp882_;
		_arg_size = _tmp883_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp884_;
			gpointer _tmp885_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp886_;
			ValaCCodeExpression* _tmp887_;
			ValaCCodeExpression* _tmp888_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp889_;
			ValaHashMap* _tmp890_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp891_;
			gboolean _tmp901_ = FALSE;
			ValaParameter* _tmp902_;
			gdouble _tmp1239_ = 0.0;
			gboolean _tmp1240_ = FALSE;
			ValaParameter* _tmp1241_;
			ValaHashMap* _tmp1243_;
			ValaCCodeExpression* _tmp1244_;
			gboolean _tmp1245_ = FALSE;
			ValaMethod* _tmp1246_;
			gboolean _tmp1271_ = FALSE;
			ValaExpression* _tmp1272_;
			gint _tmp1289_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp884_ = _arg_list;
			_tmp885_ = vala_list_get (_tmp884_, _arg_index);
			arg = (ValaExpression*) _tmp885_;
			_tmp886_ = arg;
			_tmp887_ = vala_get_cvalue (_tmp886_);
			_tmp888_ = _vala_ccode_node_ref0 (_tmp887_);
			cexpr = _tmp888_;
			_tmp889_ = in_arg_map;
			_tmp890_ = _vala_map_ref0 (_tmp889_);
			carg_map = _tmp890_;
			param = NULL;
			_tmp891_ = params_it;
			if (vala_iterator_next (_tmp891_)) {
				ValaIterator* _tmp892_;
				gpointer _tmp893_;
				gboolean _tmp894_ = FALSE;
				ValaParameter* _tmp895_;
				gboolean _tmp896_;
				gboolean _tmp897_;
				_tmp892_ = params_it;
				_tmp893_ = vala_iterator_get (_tmp892_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp893_;
				_tmp895_ = param;
				_tmp896_ = vala_parameter_get_params_array (_tmp895_);
				_tmp897_ = _tmp896_;
				if (_tmp897_) {
					_tmp894_ = TRUE;
				} else {
					ValaParameter* _tmp898_;
					gboolean _tmp899_;
					gboolean _tmp900_;
					_tmp898_ = param;
					_tmp899_ = vala_parameter_get_ellipsis (_tmp898_);
					_tmp900_ = _tmp899_;
					_tmp894_ = _tmp900_;
				}
				ellipsis = _tmp894_;
			}
			_tmp902_ = param;
			if (_tmp902_ != NULL) {
				_tmp901_ = !ellipsis;
			} else {
				_tmp901_ = FALSE;
			}
			if (_tmp901_) {
				ValaParameter* _tmp903_;
				ValaParameterDirection _tmp904_;
				ValaParameterDirection _tmp905_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp908_;
				ValaUnaryExpression* _tmp909_;
				gboolean _tmp910_ = FALSE;
				ValaUnaryExpression* _tmp911_;
				ValaParameter* _tmp1169_;
				gchar* _tmp1170_;
				gchar* _tmp1171_;
				gboolean _tmp1172_;
				_tmp903_ = param;
				_tmp904_ = vala_parameter_get_direction (_tmp903_);
				_tmp905_ = _tmp904_;
				if (_tmp905_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp906_;
					ValaHashMap* _tmp907_;
					_tmp906_ = out_arg_map;
					_tmp907_ = _vala_map_ref0 (_tmp906_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp907_;
				}
				_tmp908_ = arg;
				_tmp909_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp908_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp908_) : NULL);
				unary = _tmp909_;
				_tmp911_ = unary;
				if (_tmp911_ == NULL) {
					_tmp910_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp912_;
					ValaUnaryOperator _tmp913_;
					ValaUnaryOperator _tmp914_;
					_tmp912_ = unary;
					_tmp913_ = vala_unary_expression_get_operator (_tmp912_);
					_tmp914_ = _tmp913_;
					_tmp910_ = _tmp914_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp910_) {
					gboolean _tmp915_ = FALSE;
					gboolean _tmp916_ = FALSE;
					ValaParameter* _tmp917_;
					ValaParameter* _tmp1049_;
					ValaExpression* _tmp1050_;
					ValaCCodeExpression* _tmp1051_;
					ValaCCodeExpression* _tmp1052_;
					_tmp917_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp917_)) {
						ValaParameter* _tmp918_;
						ValaDataType* _tmp919_;
						ValaDataType* _tmp920_;
						_tmp918_ = param;
						_tmp919_ = vala_variable_get_variable_type ((ValaVariable*) _tmp918_);
						_tmp920_ = _tmp919_;
						_tmp916_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp920_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp916_ = FALSE;
					}
					if (_tmp916_) {
						ValaParameter* _tmp921_;
						ValaDataType* _tmp922_;
						ValaDataType* _tmp923_;
						gboolean _tmp924_;
						gboolean _tmp925_;
						_tmp921_ = param;
						_tmp922_ = vala_variable_get_variable_type ((ValaVariable*) _tmp921_);
						_tmp923_ = _tmp922_;
						_tmp924_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp923_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp925_ = _tmp924_;
						_tmp915_ = !_tmp925_;
					} else {
						_tmp915_ = FALSE;
					}
					if (_tmp915_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp926_;
						ValaDataType* _tmp927_;
						ValaDataType* _tmp928_;
						ValaArrayType* _tmp929_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp930_;
						gchar* _tmp931_;
						gboolean _tmp932_ = FALSE;
						ValaUnaryExpression* _tmp933_;
						_tmp926_ = param;
						_tmp927_ = vala_variable_get_variable_type ((ValaVariable*) _tmp926_);
						_tmp928_ = _tmp927_;
						_tmp929_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp928_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp929_;
						_tmp930_ = param;
						_tmp931_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp930_);
						length_ctype = _tmp931_;
						_tmp933_ = unary;
						if (_tmp933_ != NULL) {
							ValaUnaryExpression* _tmp934_;
							ValaUnaryOperator _tmp935_;
							ValaUnaryOperator _tmp936_;
							_tmp934_ = unary;
							_tmp935_ = vala_unary_expression_get_operator (_tmp934_);
							_tmp936_ = _tmp935_;
							_tmp932_ = _tmp936_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp932_ = FALSE;
						}
						if (_tmp932_) {
							const gchar* _tmp937_;
							gchar* _tmp938_;
							_tmp937_ = length_ctype;
							_tmp938_ = g_strdup_printf ("%s*", _tmp937_);
							_g_free0 (length_ctype);
							length_ctype = _tmp938_;
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp939_ = FALSE;
								_tmp939_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp941_;
									gint _tmp942_;
									gint _tmp943_;
									ValaCCodeCastExpression* array_length_expr = NULL;
									ValaExpression* _tmp944_;
									ValaCCodeExpression* _tmp945_;
									ValaCCodeExpression* _tmp946_;
									const gchar* _tmp947_;
									ValaCCodeCastExpression* _tmp948_;
									ValaCCodeCastExpression* _tmp949_;
									ValaHashMap* _tmp950_;
									ValaParameter* _tmp951_;
									ValaCCodeCastExpression* _tmp952_;
									if (!_tmp939_) {
										gint _tmp940_;
										_tmp940_ = dim;
										dim = _tmp940_ + 1;
									}
									_tmp939_ = FALSE;
									_tmp941_ = array_type;
									_tmp942_ = vala_array_type_get_rank (_tmp941_);
									_tmp943_ = _tmp942_;
									if (!(dim <= _tmp943_)) {
										break;
									}
									_tmp944_ = arg;
									_tmp945_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp944_, dim);
									_tmp946_ = _tmp945_;
									_tmp947_ = length_ctype;
									_tmp948_ = vala_ccode_cast_expression_new (_tmp946_, _tmp947_);
									_tmp949_ = _tmp948_;
									_vala_ccode_node_unref0 (_tmp946_);
									array_length_expr = _tmp949_;
									_tmp950_ = carg_map;
									_tmp951_ = param;
									_tmp952_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp950_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp951_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp952_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp953_ = FALSE;
						ValaParameter* _tmp954_;
						_tmp954_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp954_)) {
							ValaParameter* _tmp955_;
							ValaDataType* _tmp956_;
							ValaDataType* _tmp957_;
							_tmp955_ = param;
							_tmp956_ = vala_variable_get_variable_type ((ValaVariable*) _tmp955_);
							_tmp957_ = _tmp956_;
							_tmp953_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp957_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp953_ = FALSE;
						}
						if (_tmp953_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp958_;
							ValaDataType* _tmp959_;
							ValaDataType* _tmp960_;
							ValaDelegateType* _tmp961_;
							ValaDelegateType* _tmp962_;
							ValaDelegate* _tmp963_;
							ValaDelegate* _tmp964_;
							gboolean _tmp965_;
							gboolean _tmp966_;
							_tmp958_ = param;
							_tmp959_ = vala_variable_get_variable_type ((ValaVariable*) _tmp958_);
							_tmp960_ = _tmp959_;
							_tmp961_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp960_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp961_;
							_tmp962_ = deleg_type;
							_tmp963_ = vala_delegate_type_get_delegate_symbol (_tmp962_);
							_tmp964_ = _tmp963_;
							_tmp965_ = vala_delegate_get_has_target (_tmp964_);
							_tmp966_ = _tmp965_;
							if (_tmp966_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp967_;
								ValaCCodeExpression* _tmp968_ = NULL;
								ValaCCodeExpression* _tmp969_;
								ValaCCodeExpression* _tmp970_;
								ValaParameter* _tmp971_;
								gchar* _tmp972_;
								gchar* _tmp973_;
								gboolean _tmp974_;
								_tmp967_ = arg;
								_tmp969_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp967_, &_tmp968_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp968_;
								delegate_target = _tmp969_;
								_tmp970_ = delegate_target;
								_vala_assert (_tmp970_ != NULL, "delegate_target != null");
								_tmp971_ = param;
								_tmp972_ = vala_get_ccode_type ((ValaCodeNode*) _tmp971_);
								_tmp973_ = _tmp972_;
								_tmp974_ = g_strcmp0 (_tmp973_, "GClosure*") == 0;
								_g_free0 (_tmp973_);
								if (_tmp974_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp975_;
									ValaCCodeIdentifier* _tmp976_;
									ValaCCodeFunctionCall* _tmp977_;
									ValaCCodeFunctionCall* _tmp978_;
									ValaCCodeFunctionCall* _tmp979_;
									ValaCCodeExpression* _tmp980_;
									ValaCCodeCastExpression* _tmp981_;
									ValaCCodeCastExpression* _tmp982_;
									ValaCCodeFunctionCall* _tmp983_;
									ValaCCodeExpression* _tmp984_;
									ValaCCodeFunctionCall* _tmp985_;
									ValaCCodeExpression* _tmp986_;
									ValaCCodeCastExpression* _tmp987_;
									ValaCCodeCastExpression* _tmp988_;
									ValaCCodeExpression* _tmp989_;
									ValaCCodeIdentifier* _tmp990_;
									ValaCCodeIdentifier* _tmp991_;
									ValaCCodeBinaryExpression* _tmp992_;
									ValaCCodeBinaryExpression* _tmp993_;
									ValaCCodeIdentifier* _tmp994_;
									ValaCCodeIdentifier* _tmp995_;
									ValaCCodeFunctionCall* _tmp996_;
									ValaCCodeConditionalExpression* _tmp997_;
									_tmp975_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp976_ = _tmp975_;
									_tmp977_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp976_);
									_tmp978_ = _tmp977_;
									_vala_ccode_node_unref0 (_tmp976_);
									closure_new = _tmp978_;
									_tmp979_ = closure_new;
									_tmp980_ = cexpr;
									_tmp981_ = vala_ccode_cast_expression_new (_tmp980_, "GCallback");
									_tmp982_ = _tmp981_;
									vala_ccode_function_call_add_argument (_tmp979_, (ValaCCodeExpression*) _tmp982_);
									_vala_ccode_node_unref0 (_tmp982_);
									_tmp983_ = closure_new;
									_tmp984_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp983_, _tmp984_);
									_tmp985_ = closure_new;
									_tmp986_ = delegate_target_destroy_notify;
									_tmp987_ = vala_ccode_cast_expression_new (_tmp986_, "GClosureNotify");
									_tmp988_ = _tmp987_;
									vala_ccode_function_call_add_argument (_tmp985_, (ValaCCodeExpression*) _tmp988_);
									_vala_ccode_node_unref0 (_tmp988_);
									_tmp989_ = cexpr;
									_tmp990_ = vala_ccode_identifier_new ("NULL");
									_tmp991_ = _tmp990_;
									_tmp992_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp989_, (ValaCCodeExpression*) _tmp991_);
									_tmp993_ = _tmp992_;
									_tmp994_ = vala_ccode_identifier_new ("NULL");
									_tmp995_ = _tmp994_;
									_tmp996_ = closure_new;
									_tmp997_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp993_, (ValaCCodeExpression*) _tmp995_, (ValaCCodeExpression*) _tmp996_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp997_;
									_vala_ccode_node_unref0 (_tmp995_);
									_vala_ccode_node_unref0 (_tmp993_);
									_vala_ccode_node_unref0 (_tmp991_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaHashMap* _tmp998_;
									ValaParameter* _tmp999_;
									ValaCCodeExpression* _tmp1000_;
									ValaDelegateType* _tmp1001_;
									_tmp998_ = carg_map;
									_tmp999_ = param;
									_tmp1000_ = delegate_target;
									vala_map_set ((ValaMap*) _tmp998_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp999_), FALSE)), _tmp1000_);
									_tmp1001_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1001_)) {
										ValaCCodeExpression* _tmp1002_;
										ValaHashMap* _tmp1003_;
										ValaParameter* _tmp1004_;
										ValaCCodeExpression* _tmp1005_;
										_tmp1002_ = delegate_target_destroy_notify;
										_vala_assert (_tmp1002_ != NULL, "delegate_target_destroy_notify != null");
										_tmp1003_ = carg_map;
										_tmp1004_ = param;
										_tmp1005_ = delegate_target_destroy_notify;
										vala_map_set ((ValaMap*) _tmp1003_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1004_) + 0.01, FALSE)), _tmp1005_);
									}
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1006_;
							ValaDataType* _tmp1007_;
							ValaDataType* _tmp1008_;
							_tmp1006_ = param;
							_tmp1007_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1006_);
							_tmp1008_ = _tmp1007_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1008_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1009_;
								ValaParameter* _tmp1010_;
								ValaExpression* _tmp1011_;
								ValaCCodeExpression* _tmp1012_ = NULL;
								ValaCCodeExpression* _tmp1013_;
								ValaCCodeExpression* _tmp1014_;
								_tmp1009_ = carg_map;
								_tmp1010_ = param;
								_tmp1011_ = arg;
								_tmp1013_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1011_, &_tmp1012_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1012_;
								_tmp1014_ = _tmp1013_;
								vala_map_set ((ValaMap*) _tmp1009_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1010_), FALSE)), _tmp1014_);
								_vala_ccode_node_unref0 (_tmp1014_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1015_;
								ValaDataType* _tmp1016_;
								ValaDataType* _tmp1017_;
								_tmp1015_ = param;
								_tmp1016_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1015_);
								_tmp1017_ = _tmp1016_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1017_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1018_ = FALSE;
									ValaMethod* _tmp1019_;
									_tmp1019_ = m;
									if (_tmp1019_ != NULL) {
										ValaMethod* _tmp1020_;
										_tmp1020_ = m;
										_tmp1018_ = vala_get_ccode_simple_generics (_tmp1020_);
									} else {
										_tmp1018_ = FALSE;
									}
									if (_tmp1018_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1021_;
										ValaDataType* _tmp1022_;
										ValaDataType* _tmp1023_;
										ValaGenericType* _tmp1024_;
										gint type_param_index = 0;
										ValaMethod* _tmp1025_;
										ValaGenericType* _tmp1026_;
										ValaTypeParameter* _tmp1027_;
										ValaTypeParameter* _tmp1028_;
										const gchar* _tmp1029_;
										const gchar* _tmp1030_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1031_;
										ValaList* _tmp1032_;
										gpointer _tmp1033_;
										ValaParameter* _tmp1034_;
										ValaDataType* _tmp1035_;
										ValaDataType* _tmp1036_;
										gboolean _tmp1037_;
										gboolean _tmp1038_;
										_tmp1021_ = param;
										_tmp1022_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1021_);
										_tmp1023_ = _tmp1022_;
										_tmp1024_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1023_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1024_;
										_tmp1025_ = m;
										_tmp1026_ = generic_type;
										_tmp1027_ = vala_generic_type_get_type_parameter (_tmp1026_);
										_tmp1028_ = _tmp1027_;
										_tmp1029_ = vala_symbol_get_name ((ValaSymbol*) _tmp1028_);
										_tmp1030_ = _tmp1029_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1025_, _tmp1030_);
										_tmp1031_ = ma;
										_tmp1032_ = vala_member_access_get_type_arguments (_tmp1031_);
										_tmp1033_ = vala_list_get (_tmp1032_, type_param_index);
										type_arg = (ValaDataType*) _tmp1033_;
										_tmp1034_ = param;
										_tmp1035_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1034_);
										_tmp1036_ = _tmp1035_;
										_tmp1037_ = vala_data_type_get_value_owned (_tmp1036_);
										_tmp1038_ = _tmp1037_;
										if (_tmp1038_) {
											ValaDataType* _tmp1039_;
											_tmp1039_ = type_arg;
											if (vala_ccode_base_module_requires_copy (_tmp1039_)) {
												ValaHashMap* _tmp1040_;
												ValaParameter* _tmp1041_;
												ValaDataType* _tmp1042_;
												ValaCCodeExpression* _tmp1043_;
												ValaCCodeExpression* _tmp1044_;
												_tmp1040_ = carg_map;
												_tmp1041_ = param;
												_tmp1042_ = type_arg;
												_tmp1043_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1042_, FALSE);
												_tmp1044_ = _tmp1043_;
												vala_map_set ((ValaMap*) _tmp1040_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1041_), FALSE)), _tmp1044_);
												_vala_ccode_node_unref0 (_tmp1044_);
											} else {
												ValaHashMap* _tmp1045_;
												ValaParameter* _tmp1046_;
												ValaCCodeConstant* _tmp1047_;
												ValaCCodeConstant* _tmp1048_;
												_tmp1045_ = carg_map;
												_tmp1046_ = param;
												_tmp1047_ = vala_ccode_constant_new ("NULL");
												_tmp1048_ = _tmp1047_;
												vala_map_set ((ValaMap*) _tmp1045_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1046_), FALSE)), (ValaCCodeExpression*) _tmp1048_);
												_vala_ccode_node_unref0 (_tmp1048_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1049_ = param;
					_tmp1050_ = arg;
					_tmp1051_ = cexpr;
					_tmp1052_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1049_, _tmp1050_, _tmp1051_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1052_;
				} else {
					ValaExpression* _tmp1053_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1054_;
					ValaDataType* _tmp1055_;
					ValaDataType* _tmp1056_;
					ValaParameter* _tmp1057_;
					ValaDataType* _tmp1058_;
					ValaDataType* _tmp1059_;
					gboolean _tmp1060_;
					gboolean _tmp1061_;
					ValaLocalVariable* _tmp1062_;
					ValaLocalVariable* _tmp1063_;
					ValaExpression* _tmp1064_;
					ValaLocalVariable* _tmp1065_;
					const gchar* _tmp1066_;
					const gchar* _tmp1067_;
					ValaCCodeExpression* _tmp1068_;
					ValaCCodeExpression* _tmp1069_;
					ValaExpression* _tmp1070_;
					ValaTargetValue* _tmp1071_;
					ValaTargetValue* _tmp1072_;
					ValaExpression* _tmp1073_;
					ValaDataType* _tmp1074_;
					ValaDataType* _tmp1075_;
					ValaExpression* _tmp1076_;
					ValaCCodeExpression* _tmp1077_;
					ValaCCodeUnaryExpression* _tmp1078_;
					gboolean _tmp1079_ = FALSE;
					gboolean _tmp1080_ = FALSE;
					ValaParameter* _tmp1081_;
					_tmp1053_ = arg;
					vala_expression_set_target_value (_tmp1053_, NULL);
					_tmp1054_ = param;
					_tmp1055_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1054_);
					_tmp1056_ = _tmp1055_;
					_tmp1057_ = param;
					_tmp1058_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1057_);
					_tmp1059_ = _tmp1058_;
					_tmp1060_ = vala_data_type_get_value_owned (_tmp1059_);
					_tmp1061_ = _tmp1060_;
					_tmp1062_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1056_, _tmp1061_, NULL, TRUE);
					temp_var = _tmp1062_;
					_tmp1063_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1063_, FALSE);
					_tmp1064_ = arg;
					_tmp1065_ = temp_var;
					_tmp1066_ = vala_symbol_get_name ((ValaSymbol*) _tmp1065_);
					_tmp1067_ = _tmp1066_;
					_tmp1068_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1067_);
					_tmp1069_ = _tmp1068_;
					vala_set_cvalue (_tmp1064_, _tmp1069_);
					_vala_ccode_node_unref0 (_tmp1069_);
					_tmp1070_ = arg;
					_tmp1071_ = vala_expression_get_target_value (_tmp1070_);
					_tmp1072_ = _tmp1071_;
					_tmp1073_ = arg;
					_tmp1074_ = vala_expression_get_target_type (_tmp1073_);
					_tmp1075_ = _tmp1074_;
					vala_target_value_set_value_type (_tmp1072_, _tmp1075_);
					_tmp1076_ = arg;
					_tmp1077_ = vala_get_cvalue (_tmp1076_);
					_tmp1078_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1077_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1078_;
					_tmp1081_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1081_)) {
						ValaParameter* _tmp1082_;
						ValaDataType* _tmp1083_;
						ValaDataType* _tmp1084_;
						_tmp1082_ = param;
						_tmp1083_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1082_);
						_tmp1084_ = _tmp1083_;
						_tmp1080_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1084_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1080_ = FALSE;
					}
					if (_tmp1080_) {
						ValaParameter* _tmp1085_;
						ValaDataType* _tmp1086_;
						ValaDataType* _tmp1087_;
						gboolean _tmp1088_;
						gboolean _tmp1089_;
						_tmp1085_ = param;
						_tmp1086_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1085_);
						_tmp1087_ = _tmp1086_;
						_tmp1088_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1087_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1089_ = _tmp1088_;
						_tmp1079_ = !_tmp1089_;
					} else {
						_tmp1079_ = FALSE;
					}
					if (_tmp1079_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1090_;
						ValaDataType* _tmp1091_;
						ValaDataType* _tmp1092_;
						ValaArrayType* _tmp1093_;
						gchar* length_ctype = NULL;
						ValaParameter* _tmp1094_;
						gchar* _tmp1095_;
						_tmp1090_ = param;
						_tmp1091_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1090_);
						_tmp1092_ = _tmp1091_;
						_tmp1093_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1092_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1093_;
						_tmp1094_ = param;
						_tmp1095_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1094_);
						length_ctype = _tmp1095_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1096_ = FALSE;
								_tmp1096_ = TRUE;
								while (TRUE) {
									ValaArrayType* _tmp1098_;
									gint _tmp1099_;
									gint _tmp1100_;
									ValaLocalVariable* temp_array_length = NULL;
									const gchar* _tmp1101_;
									ValaCType* _tmp1102_;
									ValaCType* _tmp1103_;
									ValaLocalVariable* _tmp1104_;
									ValaLocalVariable* _tmp1105_;
									ValaLocalVariable* _tmp1106_;
									ValaExpression* _tmp1107_;
									ValaLocalVariable* _tmp1108_;
									const gchar* _tmp1109_;
									const gchar* _tmp1110_;
									ValaCCodeExpression* _tmp1111_;
									ValaCCodeExpression* _tmp1112_;
									ValaHashMap* _tmp1113_;
									ValaParameter* _tmp1114_;
									ValaExpression* _tmp1115_;
									ValaList* _tmp1116_;
									gpointer _tmp1117_;
									ValaCCodeExpression* _tmp1118_;
									ValaCCodeUnaryExpression* _tmp1119_;
									ValaCCodeUnaryExpression* _tmp1120_;
									if (!_tmp1096_) {
										gint _tmp1097_;
										_tmp1097_ = dim;
										dim = _tmp1097_ + 1;
									}
									_tmp1096_ = FALSE;
									_tmp1098_ = array_type;
									_tmp1099_ = vala_array_type_get_rank (_tmp1098_);
									_tmp1100_ = _tmp1099_;
									if (!(dim <= _tmp1100_)) {
										break;
									}
									_tmp1101_ = length_ctype;
									_tmp1102_ = vala_ctype_new (_tmp1101_, "0");
									_tmp1103_ = _tmp1102_;
									_tmp1104_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1103_, TRUE, NULL, TRUE);
									_tmp1105_ = _tmp1104_;
									_vala_code_node_unref0 (_tmp1103_);
									temp_array_length = _tmp1105_;
									_tmp1106_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1106_, FALSE);
									_tmp1107_ = arg;
									_tmp1108_ = temp_array_length;
									_tmp1109_ = vala_symbol_get_name ((ValaSymbol*) _tmp1108_);
									_tmp1110_ = _tmp1109_;
									_tmp1111_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1110_);
									_tmp1112_ = _tmp1111_;
									vala_append_array_length (_tmp1107_, _tmp1112_);
									_vala_ccode_node_unref0 (_tmp1112_);
									_tmp1113_ = carg_map;
									_tmp1114_ = param;
									_tmp1115_ = arg;
									_tmp1116_ = vala_get_array_lengths (_tmp1115_);
									_tmp1117_ = vala_list_get (_tmp1116_, dim - 1);
									_tmp1118_ = (ValaCCodeExpression*) _tmp1117_;
									_tmp1119_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1118_);
									_tmp1120_ = _tmp1119_;
									vala_map_set ((ValaMap*) _tmp1113_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1114_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1120_);
									_vala_ccode_node_unref0 (_tmp1120_);
									_vala_ccode_node_unref0 (_tmp1118_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_g_free0 (length_ctype);
						_vala_code_node_unref0 (array_type);
					} else {
						gboolean _tmp1121_ = FALSE;
						ValaParameter* _tmp1122_;
						_tmp1122_ = param;
						if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1122_)) {
							ValaParameter* _tmp1123_;
							ValaDataType* _tmp1124_;
							ValaDataType* _tmp1125_;
							_tmp1123_ = param;
							_tmp1124_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1123_);
							_tmp1125_ = _tmp1124_;
							_tmp1121_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1125_, VALA_TYPE_DELEGATE_TYPE);
						} else {
							_tmp1121_ = FALSE;
						}
						if (_tmp1121_) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1126_;
							ValaDataType* _tmp1127_;
							ValaDataType* _tmp1128_;
							ValaDelegateType* _tmp1129_;
							ValaDelegateType* _tmp1130_;
							ValaDelegate* _tmp1131_;
							ValaDelegate* _tmp1132_;
							gboolean _tmp1133_;
							gboolean _tmp1134_;
							_tmp1126_ = param;
							_tmp1127_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1126_);
							_tmp1128_ = _tmp1127_;
							_tmp1129_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1128_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1129_;
							_tmp1130_ = deleg_type;
							_tmp1131_ = vala_delegate_type_get_delegate_symbol (_tmp1130_);
							_tmp1132_ = _tmp1131_;
							_tmp1133_ = vala_delegate_get_has_target (_tmp1132_);
							_tmp1134_ = _tmp1133_;
							if (_tmp1134_) {
								ValaVoidType* _tmp1135_;
								ValaVoidType* _tmp1136_;
								ValaPointerType* _tmp1137_;
								ValaPointerType* _tmp1138_;
								ValaLocalVariable* _tmp1139_;
								ValaLocalVariable* _tmp1140_;
								ValaExpression* _tmp1141_;
								ValaLocalVariable* _tmp1142_;
								const gchar* _tmp1143_;
								const gchar* _tmp1144_;
								ValaCCodeExpression* _tmp1145_;
								ValaCCodeExpression* _tmp1146_;
								ValaHashMap* _tmp1147_;
								ValaParameter* _tmp1148_;
								ValaExpression* _tmp1149_;
								ValaCCodeExpression* _tmp1150_;
								ValaCCodeUnaryExpression* _tmp1151_;
								ValaCCodeUnaryExpression* _tmp1152_;
								ValaDelegateType* _tmp1153_;
								_tmp1135_ = vala_void_type_new (NULL);
								_tmp1136_ = _tmp1135_;
								_tmp1137_ = vala_pointer_type_new ((ValaDataType*) _tmp1136_, NULL);
								_tmp1138_ = _tmp1137_;
								_tmp1139_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1138_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1139_;
								_vala_code_node_unref0 (_tmp1138_);
								_vala_code_node_unref0 (_tmp1136_);
								_tmp1140_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1140_, FALSE);
								_tmp1141_ = arg;
								_tmp1142_ = temp_var;
								_tmp1143_ = vala_symbol_get_name ((ValaSymbol*) _tmp1142_);
								_tmp1144_ = _tmp1143_;
								_tmp1145_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1144_);
								_tmp1146_ = _tmp1145_;
								vala_set_delegate_target (_tmp1141_, _tmp1146_);
								_vala_ccode_node_unref0 (_tmp1146_);
								_tmp1147_ = carg_map;
								_tmp1148_ = param;
								_tmp1149_ = arg;
								_tmp1150_ = vala_get_delegate_target (_tmp1149_);
								_tmp1151_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1150_);
								_tmp1152_ = _tmp1151_;
								vala_map_set ((ValaMap*) _tmp1147_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1148_), FALSE)), (ValaCCodeExpression*) _tmp1152_);
								_vala_ccode_node_unref0 (_tmp1152_);
								_tmp1153_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1153_)) {
									ValaDataType* _tmp1154_;
									ValaLocalVariable* _tmp1155_;
									ValaLocalVariable* _tmp1156_;
									ValaExpression* _tmp1157_;
									ValaLocalVariable* _tmp1158_;
									const gchar* _tmp1159_;
									const gchar* _tmp1160_;
									ValaCCodeExpression* _tmp1161_;
									ValaCCodeExpression* _tmp1162_;
									ValaHashMap* _tmp1163_;
									ValaParameter* _tmp1164_;
									ValaExpression* _tmp1165_;
									ValaCCodeExpression* _tmp1166_;
									ValaCCodeUnaryExpression* _tmp1167_;
									ValaCCodeUnaryExpression* _tmp1168_;
									_tmp1154_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
									_tmp1155_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1154_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1155_;
									_tmp1156_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1156_, FALSE);
									_tmp1157_ = arg;
									_tmp1158_ = temp_var;
									_tmp1159_ = vala_symbol_get_name ((ValaSymbol*) _tmp1158_);
									_tmp1160_ = _tmp1159_;
									_tmp1161_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1160_);
									_tmp1162_ = _tmp1161_;
									vala_set_delegate_target_destroy_notify (_tmp1157_, _tmp1162_);
									_vala_ccode_node_unref0 (_tmp1162_);
									_tmp1163_ = carg_map;
									_tmp1164_ = param;
									_tmp1165_ = arg;
									_tmp1166_ = vala_get_delegate_target_destroy_notify (_tmp1165_);
									_tmp1167_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1166_);
									_tmp1168_ = _tmp1167_;
									vala_map_set ((ValaMap*) _tmp1163_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1164_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1168_);
									_vala_ccode_node_unref0 (_tmp1168_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1169_ = param;
				_tmp1170_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1169_);
				_tmp1171_ = _tmp1170_;
				_tmp1172_ = _tmp1171_ != NULL;
				_g_free0 (_tmp1171_);
				if (_tmp1172_) {
					ValaCCodeExpression* _tmp1173_;
					ValaParameter* _tmp1174_;
					gchar* _tmp1175_;
					gchar* _tmp1176_;
					ValaCCodeCastExpression* _tmp1177_;
					_tmp1173_ = cexpr;
					_tmp1174_ = param;
					_tmp1175_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1174_);
					_tmp1176_ = _tmp1175_;
					_tmp1177_ = vala_ccode_cast_expression_new (_tmp1173_, _tmp1176_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1177_;
					_g_free0 (_tmp1176_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1178_;
				ValaUnaryExpression* _tmp1179_;
				gboolean _tmp1180_ = FALSE;
				gboolean _tmp1181_ = FALSE;
				_tmp1178_ = arg;
				_tmp1179_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1178_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1178_) : NULL);
				unary = _tmp1179_;
				if (ellipsis) {
					ValaUnaryExpression* _tmp1182_;
					_tmp1182_ = unary;
					_tmp1181_ = _tmp1182_ != NULL;
				} else {
					_tmp1181_ = FALSE;
				}
				if (_tmp1181_) {
					ValaUnaryExpression* _tmp1183_;
					ValaUnaryOperator _tmp1184_;
					ValaUnaryOperator _tmp1185_;
					_tmp1183_ = unary;
					_tmp1184_ = vala_unary_expression_get_operator (_tmp1183_);
					_tmp1185_ = _tmp1184_;
					_tmp1180_ = _tmp1185_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1180_ = FALSE;
				}
				if (_tmp1180_) {
					ValaHashMap* _tmp1186_;
					ValaHashMap* _tmp1187_;
					ValaExpression* _tmp1188_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1189_;
					ValaDataType* _tmp1190_;
					ValaDataType* _tmp1191_;
					ValaExpression* _tmp1192_;
					ValaDataType* _tmp1193_;
					ValaDataType* _tmp1194_;
					gboolean _tmp1195_;
					gboolean _tmp1196_;
					ValaLocalVariable* _tmp1197_;
					ValaLocalVariable* _tmp1198_;
					ValaExpression* _tmp1199_;
					ValaLocalVariable* _tmp1200_;
					const gchar* _tmp1201_;
					const gchar* _tmp1202_;
					ValaCCodeExpression* _tmp1203_;
					ValaCCodeExpression* _tmp1204_;
					ValaExpression* _tmp1205_;
					ValaTargetValue* _tmp1206_;
					ValaTargetValue* _tmp1207_;
					ValaExpression* _tmp1208_;
					ValaDataType* _tmp1209_;
					ValaDataType* _tmp1210_;
					gboolean _tmp1211_ = FALSE;
					ValaExpression* _tmp1212_;
					ValaDataType* _tmp1213_;
					ValaDataType* _tmp1214_;
					ValaExpression* _tmp1233_;
					ValaCCodeExpression* _tmp1234_;
					ValaCCodeUnaryExpression* _tmp1235_;
					_tmp1186_ = out_arg_map;
					_tmp1187_ = _vala_map_ref0 (_tmp1186_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1187_;
					_tmp1188_ = arg;
					vala_expression_set_target_value (_tmp1188_, NULL);
					_tmp1189_ = arg;
					_tmp1190_ = vala_expression_get_value_type (_tmp1189_);
					_tmp1191_ = _tmp1190_;
					_tmp1192_ = arg;
					_tmp1193_ = vala_expression_get_value_type (_tmp1192_);
					_tmp1194_ = _tmp1193_;
					_tmp1195_ = vala_data_type_get_value_owned (_tmp1194_);
					_tmp1196_ = _tmp1195_;
					_tmp1197_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1191_, _tmp1196_, NULL, TRUE);
					temp_var = _tmp1197_;
					_tmp1198_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1198_, FALSE);
					_tmp1199_ = arg;
					_tmp1200_ = temp_var;
					_tmp1201_ = vala_symbol_get_name ((ValaSymbol*) _tmp1200_);
					_tmp1202_ = _tmp1201_;
					_tmp1203_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1202_);
					_tmp1204_ = _tmp1203_;
					vala_set_cvalue (_tmp1199_, _tmp1204_);
					_vala_ccode_node_unref0 (_tmp1204_);
					_tmp1205_ = arg;
					_tmp1206_ = vala_expression_get_target_value (_tmp1205_);
					_tmp1207_ = _tmp1206_;
					_tmp1208_ = arg;
					_tmp1209_ = vala_expression_get_value_type (_tmp1208_);
					_tmp1210_ = _tmp1209_;
					vala_target_value_set_value_type (_tmp1207_, _tmp1210_);
					_tmp1212_ = arg;
					_tmp1213_ = vala_expression_get_value_type (_tmp1212_);
					_tmp1214_ = _tmp1213_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1214_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaExpression* _tmp1215_;
						ValaDataType* _tmp1216_;
						ValaDataType* _tmp1217_;
						ValaDelegate* _tmp1218_;
						ValaDelegate* _tmp1219_;
						gboolean _tmp1220_;
						gboolean _tmp1221_;
						_tmp1215_ = arg;
						_tmp1216_ = vala_expression_get_value_type (_tmp1215_);
						_tmp1217_ = _tmp1216_;
						_tmp1218_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1217_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp1219_ = _tmp1218_;
						_tmp1220_ = vala_delegate_get_has_target (_tmp1219_);
						_tmp1221_ = _tmp1220_;
						_tmp1211_ = _tmp1221_;
					} else {
						_tmp1211_ = FALSE;
					}
					if (_tmp1211_) {
						ValaGLibValue* arg_value = NULL;
						ValaExpression* _tmp1222_;
						ValaTargetValue* _tmp1223_;
						ValaTargetValue* _tmp1224_;
						ValaGLibValue* _tmp1225_;
						ValaCCodeExpression* _tmp1226_;
						ValaGLibValue* _tmp1229_;
						ValaCCodeExpression* _tmp1230_;
						_tmp1222_ = arg;
						_tmp1223_ = vala_expression_get_target_value (_tmp1222_);
						_tmp1224_ = _tmp1223_;
						arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp1224_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
						_tmp1225_ = arg_value;
						_tmp1226_ = _tmp1225_->delegate_target_cvalue;
						if (_tmp1226_ == NULL) {
							ValaGLibValue* _tmp1227_;
							ValaCCodeConstant* _tmp1228_;
							_tmp1227_ = arg_value;
							_tmp1228_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1227_->delegate_target_cvalue);
							_tmp1227_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp1228_;
						}
						_tmp1229_ = arg_value;
						_tmp1230_ = _tmp1229_->delegate_target_destroy_notify_cvalue;
						if (_tmp1230_ == NULL) {
							ValaGLibValue* _tmp1231_;
							ValaCCodeConstant* _tmp1232_;
							_tmp1231_ = arg_value;
							_tmp1232_ = vala_ccode_constant_new ("NULL");
							_vala_ccode_node_unref0 (_tmp1231_->delegate_target_destroy_notify_cvalue);
							_tmp1231_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp1232_;
						}
					}
					_tmp1233_ = arg;
					_tmp1234_ = vala_get_cvalue (_tmp1233_);
					_tmp1235_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1234_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1235_;
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1236_;
					ValaCCodeExpression* _tmp1237_;
					ValaCCodeExpression* _tmp1238_;
					_tmp1236_ = arg;
					_tmp1237_ = cexpr;
					_tmp1238_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1236_, _tmp1237_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1238_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1241_ = param;
			if (_tmp1241_ != NULL) {
				_tmp1240_ = !ellipsis;
			} else {
				_tmp1240_ = FALSE;
			}
			if (_tmp1240_) {
				ValaParameter* _tmp1242_;
				_tmp1242_ = param;
				_tmp1239_ = vala_get_ccode_pos (_tmp1242_);
			} else {
				_tmp1239_ = (gdouble) i;
			}
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1239_, ellipsis);
			_tmp1243_ = carg_map;
			_tmp1244_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1243_, (gpointer) ((gintptr) arg_pos), _tmp1244_);
			_tmp1246_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1246_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
				ValaCodeContext* _tmp1247_;
				ValaCodeContext* _tmp1248_;
				ValaProfile _tmp1249_;
				ValaProfile _tmp1250_;
				_tmp1247_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp1248_ = _tmp1247_;
				_tmp1249_ = vala_code_context_get_profile (_tmp1248_);
				_tmp1250_ = _tmp1249_;
				_tmp1245_ = _tmp1250_ == VALA_PROFILE_POSIX;
			} else {
				_tmp1245_ = FALSE;
			}
			if (_tmp1245_) {
				ValaCCodeIdentifier* csizeof = NULL;
				ValaMemberAccess* _tmp1251_;
				ValaExpression* _tmp1252_;
				ValaExpression* _tmp1253_;
				ValaDataType* _tmp1254_;
				ValaDataType* _tmp1255_;
				ValaDataType* _tmp1256_;
				ValaDataType* _tmp1257_;
				gchar* _tmp1258_;
				gchar* _tmp1259_;
				gchar* _tmp1260_;
				gchar* _tmp1261_;
				ValaCCodeIdentifier* _tmp1262_;
				ValaCCodeIdentifier* _tmp1263_;
				ValaHashMap* _tmp1264_;
				ValaCCodeIdentifier* _tmp1265_;
				ValaCCodeExpression* _tmp1266_;
				ValaCCodeBinaryExpression* _tmp1267_;
				ValaCCodeBinaryExpression* _tmp1268_;
				_tmp1251_ = ma;
				_tmp1252_ = vala_member_access_get_inner (_tmp1251_);
				_tmp1253_ = _tmp1252_;
				_tmp1254_ = vala_expression_get_value_type (_tmp1253_);
				_tmp1255_ = _tmp1254_;
				_tmp1256_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp1255_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp1257_ = _tmp1256_;
				_tmp1258_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1257_);
				_tmp1259_ = _tmp1258_;
				_tmp1260_ = g_strdup_printf ("sizeof (%s)", _tmp1259_);
				_tmp1261_ = _tmp1260_;
				_tmp1262_ = vala_ccode_identifier_new (_tmp1261_);
				_tmp1263_ = _tmp1262_;
				_g_free0 (_tmp1261_);
				_g_free0 (_tmp1259_);
				csizeof = _tmp1263_;
				_tmp1264_ = carg_map;
				_tmp1265_ = csizeof;
				_tmp1266_ = cexpr;
				_tmp1267_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1265_, _tmp1266_);
				_tmp1268_ = _tmp1267_;
				vala_map_set ((ValaMap*) _tmp1264_, (gpointer) ((gintptr) arg_pos), (ValaCCodeExpression*) _tmp1268_);
				_vala_ccode_node_unref0 (_tmp1268_);
				_vala_ccode_node_unref0 (csizeof);
			} else {
				ValaHashMap* _tmp1269_;
				ValaCCodeExpression* _tmp1270_;
				_tmp1269_ = carg_map;
				_tmp1270_ = cexpr;
				vala_map_set ((ValaMap*) _tmp1269_, (gpointer) ((gintptr) arg_pos), _tmp1270_);
			}
			_tmp1272_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1272_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1271_ = ellipsis;
			} else {
				_tmp1271_ = FALSE;
			}
			if (_tmp1271_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1273_;
				ValaNamedArgument* _tmp1274_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1275_;
				const gchar* _tmp1276_;
				const gchar* _tmp1277_;
				gchar** _tmp1278_;
				gchar** _tmp1279_;
				gchar** _tmp1280_;
				gint _tmp1280__length1;
				gchar* _tmp1281_;
				gchar* _tmp1282_;
				ValaHashMap* _tmp1283_;
				const gchar* _tmp1284_;
				gchar* _tmp1285_;
				gchar* _tmp1286_;
				ValaCCodeConstant* _tmp1287_;
				ValaCCodeConstant* _tmp1288_;
				_tmp1273_ = arg;
				_tmp1274_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1273_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1274_;
				_tmp1275_ = named_arg;
				_tmp1276_ = vala_named_argument_get_name (_tmp1275_);
				_tmp1277_ = _tmp1276_;
				_tmp1279_ = _tmp1278_ = g_strsplit (_tmp1277_, "_", 0);
				_tmp1280_ = _tmp1279_;
				_tmp1280__length1 = _vala_array_length (_tmp1278_);
				_tmp1281_ = _vala_g_strjoinv ("-", _tmp1280_, (gint) _vala_array_length (_tmp1278_));
				_tmp1282_ = _tmp1281_;
				_tmp1280_ = (_vala_array_free (_tmp1280_, _tmp1280__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1282_;
				_tmp1283_ = carg_map;
				_tmp1284_ = name;
				_tmp1285_ = g_strdup_printf ("\"%s\"", _tmp1284_);
				_tmp1286_ = _tmp1285_;
				_tmp1287_ = vala_ccode_constant_new (_tmp1286_);
				_tmp1288_ = _tmp1287_;
				vala_map_set ((ValaMap*) _tmp1283_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1288_);
				_vala_ccode_node_unref0 (_tmp1288_);
				_g_free0 (_tmp1286_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1289_ = i;
			i = _tmp1289_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1290_ = params_it;
	if (vala_iterator_next (_tmp1290_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1291_;
		gpointer _tmp1292_;
		gboolean _tmp1293_ = FALSE;
		ValaParameter* _tmp1294_;
		gboolean _tmp1295_;
		gboolean _tmp1296_;
		_tmp1291_ = params_it;
		_tmp1292_ = vala_iterator_get (_tmp1291_);
		param = (ValaParameter*) _tmp1292_;
		_tmp1294_ = param;
		_tmp1295_ = vala_parameter_get_params_array (_tmp1294_);
		_tmp1296_ = _tmp1295_;
		if (_tmp1296_) {
			_tmp1293_ = TRUE;
		} else {
			ValaParameter* _tmp1297_;
			gboolean _tmp1298_;
			gboolean _tmp1299_;
			_tmp1297_ = param;
			_tmp1298_ = vala_parameter_get_ellipsis (_tmp1297_);
			_tmp1299_ = _tmp1298_;
			_tmp1293_ = _tmp1299_;
		}
		_vala_assert (_tmp1293_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1302_ = m;
	if (_tmp1302_ != NULL) {
		ValaMethod* _tmp1303_;
		ValaDataType* _tmp1304_;
		ValaDataType* _tmp1305_;
		_tmp1303_ = m;
		_tmp1304_ = vala_callable_get_return_type ((ValaCallable*) _tmp1303_);
		_tmp1305_ = _tmp1304_;
		_tmp1301_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1305_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1301_ = FALSE;
	}
	if (_tmp1301_) {
		ValaCCodeFunctionCall* _tmp1306_;
		ValaCCodeFunctionCall* _tmp1307_;
		_tmp1306_ = async_call;
		_tmp1307_ = ccall;
		_tmp1300_ = _tmp1306_ != _tmp1307_;
	} else {
		_tmp1300_ = FALSE;
	}
	if (_tmp1300_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1308_;
		ValaDataType* _tmp1309_;
		ValaDataType* _tmp1310_;
		ValaArrayType* _tmp1311_;
		_tmp1308_ = m;
		_tmp1309_ = vala_callable_get_return_type ((ValaCallable*) _tmp1308_);
		_tmp1310_ = _tmp1309_;
		_tmp1311_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1310_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1311_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1312_ = FALSE;
				_tmp1312_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1314_;
					gint _tmp1315_;
					gint _tmp1316_;
					ValaMethod* _tmp1317_;
					if (!_tmp1312_) {
						gint _tmp1313_;
						_tmp1313_ = dim;
						dim = _tmp1313_ + 1;
					}
					_tmp1312_ = FALSE;
					_tmp1314_ = array_type;
					_tmp1315_ = vala_array_type_get_rank (_tmp1314_);
					_tmp1316_ = _tmp1315_;
					if (!(dim <= _tmp1316_)) {
						break;
					}
					_tmp1317_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1317_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1318_;
						ValaDataType* _tmp1319_;
						ValaLocalVariable* _tmp1320_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1321_;
						const gchar* _tmp1322_;
						const gchar* _tmp1323_;
						ValaCCodeExpression* _tmp1324_;
						ValaLocalVariable* _tmp1325_;
						ValaCCodeExpression* _tmp1326_;
						ValaCCodeExpression* _tmp1327_;
						ValaCCodeAssignment* _tmp1328_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1329_;
						ValaCCodeIdentifier* _tmp1330_;
						ValaCCodeFunctionCall* _tmp1331_;
						ValaCCodeFunctionCall* _tmp1332_;
						ValaCCodeFunctionCall* _tmp1333_;
						ValaCCodeExpression* _tmp1334_;
						ValaCCodeFunctionCall* _tmp1335_;
						_tmp1318_ = itype;
						_tmp1319_ = vala_data_type_get_return_type (_tmp1318_);
						_tmp1320_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1319_, TRUE, NULL, FALSE);
						temp_var = _tmp1320_;
						_tmp1321_ = temp_var;
						_tmp1322_ = vala_symbol_get_name ((ValaSymbol*) _tmp1321_);
						_tmp1323_ = _tmp1322_;
						_tmp1324_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1323_);
						temp_ref = _tmp1324_;
						_tmp1325_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1325_, FALSE);
						_tmp1326_ = temp_ref;
						_tmp1327_ = ccall_expr;
						_tmp1328_ = vala_ccode_assignment_new (_tmp1326_, _tmp1327_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1328_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1329_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1330_ = _tmp1329_;
						_tmp1331_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1330_);
						_tmp1332_ = _tmp1331_;
						_vala_ccode_node_unref0 (_tmp1330_);
						len_call = _tmp1332_;
						_tmp1333_ = len_call;
						_tmp1334_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1333_, _tmp1334_);
						_tmp1335_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1335_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1336_;
						_tmp1336_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1336_)) {
							gchar* length_ctype = NULL;
							ValaMethod* _tmp1337_;
							gchar* _tmp1338_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1339_;
							ValaCType* _tmp1340_;
							ValaCType* _tmp1341_;
							ValaLocalVariable* _tmp1342_;
							ValaLocalVariable* _tmp1343_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1344_;
							const gchar* _tmp1345_;
							const gchar* _tmp1346_;
							ValaCCodeExpression* _tmp1347_;
							ValaLocalVariable* _tmp1348_;
							ValaHashMap* _tmp1349_;
							ValaMethod* _tmp1350_;
							ValaCCodeExpression* _tmp1351_;
							ValaCCodeUnaryExpression* _tmp1352_;
							ValaCCodeUnaryExpression* _tmp1353_;
							ValaCCodeExpression* _tmp1354_;
							_tmp1337_ = m;
							_tmp1338_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1337_);
							length_ctype = _tmp1338_;
							_tmp1339_ = length_ctype;
							_tmp1340_ = vala_ctype_new (_tmp1339_, "0");
							_tmp1341_ = _tmp1340_;
							_tmp1342_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1341_, TRUE, NULL, TRUE);
							_tmp1343_ = _tmp1342_;
							_vala_code_node_unref0 (_tmp1341_);
							temp_var = _tmp1343_;
							_tmp1344_ = temp_var;
							_tmp1345_ = vala_symbol_get_name ((ValaSymbol*) _tmp1344_);
							_tmp1346_ = _tmp1345_;
							_tmp1347_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1346_);
							temp_ref = _tmp1347_;
							_tmp1348_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1348_, FALSE);
							_tmp1349_ = out_arg_map;
							_tmp1350_ = m;
							_tmp1351_ = temp_ref;
							_tmp1352_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1351_);
							_tmp1353_ = _tmp1352_;
							vala_map_set ((ValaMap*) _tmp1349_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1350_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1353_);
							_vala_ccode_node_unref0 (_tmp1353_);
							_tmp1354_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1354_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaMethod* _tmp1355_;
							gchar* _tmp1356_;
							gchar* _tmp1357_;
							gboolean _tmp1358_;
							_tmp1355_ = m;
							_tmp1356_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1355_);
							_tmp1357_ = _tmp1356_;
							_tmp1358_ = _tmp1357_ != NULL;
							_g_free0 (_tmp1357_);
							if (_tmp1358_) {
								ValaMethod* _tmp1359_;
								gchar* _tmp1360_;
								gchar* _tmp1361_;
								ValaCCodeConstant* _tmp1362_;
								ValaCCodeConstant* _tmp1363_;
								_tmp1359_ = m;
								_tmp1360_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1359_);
								_tmp1361_ = _tmp1360_;
								_tmp1362_ = vala_ccode_constant_new (_tmp1361_);
								_tmp1363_ = _tmp1362_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1363_);
								_vala_ccode_node_unref0 (_tmp1363_);
								_g_free0 (_tmp1361_);
							} else {
								ValaCCodeConstant* _tmp1364_;
								ValaCCodeConstant* _tmp1365_;
								_tmp1364_ = vala_ccode_constant_new ("-1");
								_tmp1365_ = _tmp1364_;
								vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1365_);
								_vala_ccode_node_unref0 (_tmp1365_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1366_ = FALSE;
		gboolean _tmp1367_ = FALSE;
		ValaMethod* _tmp1368_;
		_tmp1368_ = m;
		if (_tmp1368_ != NULL) {
			ValaMethod* _tmp1369_;
			ValaDataType* _tmp1370_;
			ValaDataType* _tmp1371_;
			_tmp1369_ = m;
			_tmp1370_ = vala_callable_get_return_type ((ValaCallable*) _tmp1369_);
			_tmp1371_ = _tmp1370_;
			_tmp1367_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1371_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1367_ = FALSE;
		}
		if (_tmp1367_) {
			ValaCCodeFunctionCall* _tmp1372_;
			ValaCCodeFunctionCall* _tmp1373_;
			_tmp1372_ = async_call;
			_tmp1373_ = ccall;
			_tmp1366_ = _tmp1372_ != _tmp1373_;
		} else {
			_tmp1366_ = FALSE;
		}
		if (_tmp1366_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1374_;
			ValaDataType* _tmp1375_;
			ValaDataType* _tmp1376_;
			ValaDelegateType* _tmp1377_;
			gboolean _tmp1378_ = FALSE;
			ValaMethod* _tmp1379_;
			_tmp1374_ = m;
			_tmp1375_ = vala_callable_get_return_type ((ValaCallable*) _tmp1374_);
			_tmp1376_ = _tmp1375_;
			_tmp1377_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1376_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1377_;
			_tmp1379_ = m;
			if (vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1379_)) {
				ValaDelegateType* _tmp1380_;
				ValaDelegate* _tmp1381_;
				ValaDelegate* _tmp1382_;
				gboolean _tmp1383_;
				gboolean _tmp1384_;
				_tmp1380_ = deleg_type;
				_tmp1381_ = vala_delegate_type_get_delegate_symbol (_tmp1380_);
				_tmp1382_ = _tmp1381_;
				_tmp1383_ = vala_delegate_get_has_target (_tmp1382_);
				_tmp1384_ = _tmp1383_;
				_tmp1378_ = _tmp1384_;
			} else {
				_tmp1378_ = FALSE;
			}
			if (_tmp1378_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1385_;
				ValaVoidType* _tmp1386_;
				ValaPointerType* _tmp1387_;
				ValaPointerType* _tmp1388_;
				ValaLocalVariable* _tmp1389_;
				ValaLocalVariable* _tmp1390_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1391_;
				const gchar* _tmp1392_;
				const gchar* _tmp1393_;
				ValaCCodeExpression* _tmp1394_;
				ValaLocalVariable* _tmp1395_;
				ValaHashMap* _tmp1396_;
				ValaMethod* _tmp1397_;
				ValaCCodeExpression* _tmp1398_;
				ValaCCodeUnaryExpression* _tmp1399_;
				ValaCCodeUnaryExpression* _tmp1400_;
				ValaCCodeExpression* _tmp1401_;
				ValaDelegateType* _tmp1402_;
				_tmp1385_ = vala_void_type_new (NULL);
				_tmp1386_ = _tmp1385_;
				_tmp1387_ = vala_pointer_type_new ((ValaDataType*) _tmp1386_, NULL);
				_tmp1388_ = _tmp1387_;
				_tmp1389_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1388_, TRUE, NULL, TRUE);
				_tmp1390_ = _tmp1389_;
				_vala_code_node_unref0 (_tmp1388_);
				_vala_code_node_unref0 (_tmp1386_);
				temp_var = _tmp1390_;
				_tmp1391_ = temp_var;
				_tmp1392_ = vala_symbol_get_name ((ValaSymbol*) _tmp1391_);
				_tmp1393_ = _tmp1392_;
				_tmp1394_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1393_);
				temp_ref = _tmp1394_;
				_tmp1395_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1395_, FALSE);
				_tmp1396_ = out_arg_map;
				_tmp1397_ = m;
				_tmp1398_ = temp_ref;
				_tmp1399_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1398_);
				_tmp1400_ = _tmp1399_;
				vala_map_set ((ValaMap*) _tmp1396_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1397_), FALSE)), (ValaCCodeExpression*) _tmp1400_);
				_vala_ccode_node_unref0 (_tmp1400_);
				_tmp1401_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1401_);
				_tmp1402_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1402_)) {
					ValaDataType* _tmp1403_;
					ValaLocalVariable* _tmp1404_;
					ValaLocalVariable* _tmp1405_;
					const gchar* _tmp1406_;
					const gchar* _tmp1407_;
					ValaCCodeExpression* _tmp1408_;
					ValaLocalVariable* _tmp1409_;
					ValaHashMap* _tmp1410_;
					ValaMethod* _tmp1411_;
					ValaCCodeExpression* _tmp1412_;
					ValaCCodeUnaryExpression* _tmp1413_;
					ValaCCodeUnaryExpression* _tmp1414_;
					ValaCCodeExpression* _tmp1415_;
					_tmp1403_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1404_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1403_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1404_;
					_tmp1405_ = temp_var;
					_tmp1406_ = vala_symbol_get_name ((ValaSymbol*) _tmp1405_);
					_tmp1407_ = _tmp1406_;
					_tmp1408_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1407_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1408_;
					_tmp1409_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1409_, FALSE);
					_tmp1410_ = out_arg_map;
					_tmp1411_ = m;
					_tmp1412_ = temp_ref;
					_tmp1413_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1412_);
					_tmp1414_ = _tmp1413_;
					vala_map_set ((ValaMap*) _tmp1410_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1411_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1414_);
					_vala_ccode_node_unref0 (_tmp1414_);
					_tmp1415_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1415_);
				} else {
					ValaCCodeConstant* _tmp1416_;
					ValaCCodeConstant* _tmp1417_;
					_tmp1416_ = vala_ccode_constant_new ("NULL");
					_tmp1417_ = _tmp1416_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1417_);
					_vala_ccode_node_unref0 (_tmp1417_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1418_;
				ValaCCodeConstant* _tmp1419_;
				ValaDelegateType* _tmp1420_;
				ValaDelegate* _tmp1421_;
				ValaDelegate* _tmp1422_;
				gboolean _tmp1423_;
				gboolean _tmp1424_;
				_tmp1418_ = vala_ccode_constant_new ("NULL");
				_tmp1419_ = _tmp1418_;
				vala_set_delegate_target ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1419_);
				_vala_ccode_node_unref0 (_tmp1419_);
				_tmp1420_ = deleg_type;
				_tmp1421_ = vala_delegate_type_get_delegate_symbol (_tmp1420_);
				_tmp1422_ = _tmp1421_;
				_tmp1423_ = vala_delegate_get_has_target (_tmp1422_);
				_tmp1424_ = _tmp1423_;
				if (_tmp1424_) {
					ValaCCodeConstant* _tmp1425_;
					ValaCCodeConstant* _tmp1426_;
					_tmp1425_ = vala_ccode_constant_new ("NULL");
					_tmp1426_ = _tmp1425_;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1426_);
					_vala_ccode_node_unref0 (_tmp1426_);
				}
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1428_ = deleg;
	if (_tmp1428_ != NULL) {
		ValaDelegate* _tmp1429_;
		ValaDataType* _tmp1430_;
		ValaDataType* _tmp1431_;
		_tmp1429_ = deleg;
		_tmp1430_ = vala_callable_get_return_type ((ValaCallable*) _tmp1429_);
		_tmp1431_ = _tmp1430_;
		_tmp1427_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1431_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1427_ = FALSE;
	}
	if (_tmp1427_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1432_;
		ValaDataType* _tmp1433_;
		ValaDataType* _tmp1434_;
		ValaArrayType* _tmp1435_;
		_tmp1432_ = deleg;
		_tmp1433_ = vala_callable_get_return_type ((ValaCallable*) _tmp1432_);
		_tmp1434_ = _tmp1433_;
		_tmp1435_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1434_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1435_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1436_ = FALSE;
				_tmp1436_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1438_;
					gint _tmp1439_;
					gint _tmp1440_;
					ValaDelegate* _tmp1441_;
					if (!_tmp1436_) {
						gint _tmp1437_;
						_tmp1437_ = dim;
						dim = _tmp1437_ + 1;
					}
					_tmp1436_ = FALSE;
					_tmp1438_ = array_type;
					_tmp1439_ = vala_array_type_get_rank (_tmp1438_);
					_tmp1440_ = _tmp1439_;
					if (!(dim <= _tmp1440_)) {
						break;
					}
					_tmp1441_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1441_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1442_;
						ValaDataType* _tmp1443_;
						ValaLocalVariable* _tmp1444_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1445_;
						const gchar* _tmp1446_;
						const gchar* _tmp1447_;
						ValaCCodeExpression* _tmp1448_;
						ValaLocalVariable* _tmp1449_;
						ValaCCodeExpression* _tmp1450_;
						ValaCCodeExpression* _tmp1451_;
						ValaCCodeAssignment* _tmp1452_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1453_;
						ValaCCodeIdentifier* _tmp1454_;
						ValaCCodeFunctionCall* _tmp1455_;
						ValaCCodeFunctionCall* _tmp1456_;
						ValaCCodeFunctionCall* _tmp1457_;
						ValaCCodeExpression* _tmp1458_;
						ValaCCodeFunctionCall* _tmp1459_;
						_tmp1442_ = itype;
						_tmp1443_ = vala_data_type_get_return_type (_tmp1442_);
						_tmp1444_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1443_, TRUE, NULL, FALSE);
						temp_var = _tmp1444_;
						_tmp1445_ = temp_var;
						_tmp1446_ = vala_symbol_get_name ((ValaSymbol*) _tmp1445_);
						_tmp1447_ = _tmp1446_;
						_tmp1448_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1447_);
						temp_ref = _tmp1448_;
						_tmp1449_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1449_, FALSE);
						_tmp1450_ = temp_ref;
						_tmp1451_ = ccall_expr;
						_tmp1452_ = vala_ccode_assignment_new (_tmp1450_, _tmp1451_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1452_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1453_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1454_ = _tmp1453_;
						_tmp1455_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1454_);
						_tmp1456_ = _tmp1455_;
						_vala_ccode_node_unref0 (_tmp1454_);
						len_call = _tmp1456_;
						_tmp1457_ = len_call;
						_tmp1458_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1457_, _tmp1458_);
						_tmp1459_ = len_call;
						vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1459_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1460_;
						_tmp1460_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1460_)) {
							gchar* length_ctype = NULL;
							ValaDelegate* _tmp1461_;
							gchar* _tmp1462_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1463_;
							ValaCType* _tmp1464_;
							ValaCType* _tmp1465_;
							ValaLocalVariable* _tmp1466_;
							ValaLocalVariable* _tmp1467_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1468_;
							const gchar* _tmp1469_;
							const gchar* _tmp1470_;
							ValaCCodeExpression* _tmp1471_;
							ValaLocalVariable* _tmp1472_;
							ValaHashMap* _tmp1473_;
							ValaDelegate* _tmp1474_;
							ValaCCodeExpression* _tmp1475_;
							ValaCCodeUnaryExpression* _tmp1476_;
							ValaCCodeUnaryExpression* _tmp1477_;
							ValaCCodeExpression* _tmp1478_;
							_tmp1461_ = deleg;
							_tmp1462_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1461_);
							length_ctype = _tmp1462_;
							_tmp1463_ = length_ctype;
							_tmp1464_ = vala_ctype_new (_tmp1463_, "0");
							_tmp1465_ = _tmp1464_;
							_tmp1466_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1465_, TRUE, NULL, TRUE);
							_tmp1467_ = _tmp1466_;
							_vala_code_node_unref0 (_tmp1465_);
							temp_var = _tmp1467_;
							_tmp1468_ = temp_var;
							_tmp1469_ = vala_symbol_get_name ((ValaSymbol*) _tmp1468_);
							_tmp1470_ = _tmp1469_;
							_tmp1471_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1470_);
							temp_ref = _tmp1471_;
							_tmp1472_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1472_, FALSE);
							_tmp1473_ = out_arg_map;
							_tmp1474_ = deleg;
							_tmp1475_ = temp_ref;
							_tmp1476_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1475_);
							_tmp1477_ = _tmp1476_;
							vala_map_set ((ValaMap*) _tmp1473_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1474_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1477_);
							_vala_ccode_node_unref0 (_tmp1477_);
							_tmp1478_ = temp_ref;
							vala_append_array_length ((ValaExpression*) expr, _tmp1478_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
						} else {
							ValaCCodeConstant* _tmp1479_;
							ValaCCodeConstant* _tmp1480_;
							_tmp1479_ = vala_ccode_constant_new ("-1");
							_tmp1480_ = _tmp1479_;
							vala_append_array_length ((ValaExpression*) expr, (ValaCCodeExpression*) _tmp1480_);
							_vala_ccode_node_unref0 (_tmp1480_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1481_ = FALSE;
		gboolean _tmp1482_ = FALSE;
		ValaDelegate* _tmp1483_;
		_tmp1483_ = deleg;
		if (_tmp1483_ != NULL) {
			ValaDelegate* _tmp1484_;
			ValaDataType* _tmp1485_;
			ValaDataType* _tmp1486_;
			_tmp1484_ = deleg;
			_tmp1485_ = vala_callable_get_return_type ((ValaCallable*) _tmp1484_);
			_tmp1486_ = _tmp1485_;
			_tmp1482_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1486_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1482_ = FALSE;
		}
		if (_tmp1482_) {
			ValaDelegate* _tmp1487_;
			_tmp1487_ = deleg;
			_tmp1481_ = vala_get_ccode_delegate_target ((ValaCodeNode*) _tmp1487_);
		} else {
			_tmp1481_ = FALSE;
		}
		if (_tmp1481_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1488_;
			ValaDataType* _tmp1489_;
			ValaDataType* _tmp1490_;
			ValaDelegateType* _tmp1491_;
			ValaDelegateType* _tmp1492_;
			ValaDelegate* _tmp1493_;
			ValaDelegate* _tmp1494_;
			gboolean _tmp1495_;
			gboolean _tmp1496_;
			_tmp1488_ = deleg;
			_tmp1489_ = vala_callable_get_return_type ((ValaCallable*) _tmp1488_);
			_tmp1490_ = _tmp1489_;
			_tmp1491_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1490_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1491_;
			_tmp1492_ = deleg_type;
			_tmp1493_ = vala_delegate_type_get_delegate_symbol (_tmp1492_);
			_tmp1494_ = _tmp1493_;
			_tmp1495_ = vala_delegate_get_has_target (_tmp1494_);
			_tmp1496_ = _tmp1495_;
			if (_tmp1496_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1497_;
				ValaVoidType* _tmp1498_;
				ValaPointerType* _tmp1499_;
				ValaPointerType* _tmp1500_;
				ValaLocalVariable* _tmp1501_;
				ValaLocalVariable* _tmp1502_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1503_;
				const gchar* _tmp1504_;
				const gchar* _tmp1505_;
				ValaCCodeExpression* _tmp1506_;
				ValaLocalVariable* _tmp1507_;
				ValaHashMap* _tmp1508_;
				ValaDelegate* _tmp1509_;
				ValaCCodeExpression* _tmp1510_;
				ValaCCodeUnaryExpression* _tmp1511_;
				ValaCCodeUnaryExpression* _tmp1512_;
				ValaCCodeExpression* _tmp1513_;
				ValaDelegateType* _tmp1514_;
				_tmp1497_ = vala_void_type_new (NULL);
				_tmp1498_ = _tmp1497_;
				_tmp1499_ = vala_pointer_type_new ((ValaDataType*) _tmp1498_, NULL);
				_tmp1500_ = _tmp1499_;
				_tmp1501_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1500_, TRUE, NULL, TRUE);
				_tmp1502_ = _tmp1501_;
				_vala_code_node_unref0 (_tmp1500_);
				_vala_code_node_unref0 (_tmp1498_);
				temp_var = _tmp1502_;
				_tmp1503_ = temp_var;
				_tmp1504_ = vala_symbol_get_name ((ValaSymbol*) _tmp1503_);
				_tmp1505_ = _tmp1504_;
				_tmp1506_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1505_);
				temp_ref = _tmp1506_;
				_tmp1507_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1507_, FALSE);
				_tmp1508_ = out_arg_map;
				_tmp1509_ = deleg;
				_tmp1510_ = temp_ref;
				_tmp1511_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1510_);
				_tmp1512_ = _tmp1511_;
				vala_map_set ((ValaMap*) _tmp1508_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1509_), FALSE)), (ValaCCodeExpression*) _tmp1512_);
				_vala_ccode_node_unref0 (_tmp1512_);
				_tmp1513_ = temp_ref;
				vala_set_delegate_target ((ValaExpression*) expr, _tmp1513_);
				_tmp1514_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1514_)) {
					ValaDataType* _tmp1515_;
					ValaLocalVariable* _tmp1516_;
					ValaLocalVariable* _tmp1517_;
					const gchar* _tmp1518_;
					const gchar* _tmp1519_;
					ValaCCodeExpression* _tmp1520_;
					ValaLocalVariable* _tmp1521_;
					ValaHashMap* _tmp1522_;
					ValaDelegate* _tmp1523_;
					ValaCCodeExpression* _tmp1524_;
					ValaCCodeUnaryExpression* _tmp1525_;
					ValaCCodeUnaryExpression* _tmp1526_;
					ValaCCodeExpression* _tmp1527_;
					_tmp1515_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1516_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1515_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1516_;
					_tmp1517_ = temp_var;
					_tmp1518_ = vala_symbol_get_name ((ValaSymbol*) _tmp1517_);
					_tmp1519_ = _tmp1518_;
					_tmp1520_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1519_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1520_;
					_tmp1521_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1521_, FALSE);
					_tmp1522_ = out_arg_map;
					_tmp1523_ = deleg;
					_tmp1524_ = temp_ref;
					_tmp1525_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1524_);
					_tmp1526_ = _tmp1525_;
					vala_map_set ((ValaMap*) _tmp1522_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1523_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1526_);
					_vala_ccode_node_unref0 (_tmp1526_);
					_tmp1527_ = temp_ref;
					vala_set_delegate_target_destroy_notify ((ValaExpression*) expr, _tmp1527_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1529_ = m;
	if (_tmp1529_ != NULL) {
		ValaMethod* _tmp1530_;
		gboolean _tmp1531_;
		gboolean _tmp1532_;
		_tmp1530_ = m;
		_tmp1531_ = vala_method_get_coroutine (_tmp1530_);
		_tmp1532_ = _tmp1531_;
		_tmp1528_ = _tmp1532_;
	} else {
		_tmp1528_ = FALSE;
	}
	if (_tmp1528_) {
		gboolean _tmp1533_;
		gboolean _tmp1534_;
		_tmp1533_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1534_ = _tmp1533_;
		if (_tmp1534_) {
			ValaHashMap* _tmp1535_;
			ValaMethod* _tmp1536_;
			ValaMethod* _tmp1537_;
			gchar* _tmp1538_;
			gchar* _tmp1539_;
			ValaCCodeIdentifier* _tmp1540_;
			ValaCCodeIdentifier* _tmp1541_;
			ValaHashMap* _tmp1542_;
			ValaCCodeIdentifier* _tmp1543_;
			ValaCCodeIdentifier* _tmp1544_;
			_tmp1535_ = in_arg_map;
			_tmp1536_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1537_ = _tmp1536_;
			_tmp1538_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1537_);
			_tmp1539_ = _tmp1538_;
			_tmp1540_ = vala_ccode_identifier_new (_tmp1539_);
			_tmp1541_ = _tmp1540_;
			vala_map_set ((ValaMap*) _tmp1535_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1541_);
			_vala_ccode_node_unref0 (_tmp1541_);
			_g_free0 (_tmp1539_);
			_tmp1542_ = in_arg_map;
			_tmp1543_ = vala_ccode_identifier_new ("_data_");
			_tmp1544_ = _tmp1543_;
			vala_map_set ((ValaMap*) _tmp1542_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1544_);
			_vala_ccode_node_unref0 (_tmp1544_);
		}
	}
	_tmp1545_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1546_ = _tmp1545_;
	if (_tmp1546_) {
		ValaCallable* _tmp1547_ = NULL;
		ValaMethod* _tmp1548_;
		ValaHashMap* _tmp1550_;
		ValaCCodeExpression* _tmp1551_;
		ValaCCodeExpression* _tmp1552_;
		ValaCCodeUnaryExpression* _tmp1553_;
		ValaCCodeUnaryExpression* _tmp1554_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1548_ = m;
		_tmp1547_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1548_, VALA_TYPE_CALLABLE, ValaCallable);
		if (_tmp1547_ == NULL) {
			ValaDelegate* _tmp1549_;
			_tmp1549_ = deleg;
			_tmp1547_ = (ValaCallable*) _tmp1549_;
		}
		_tmp1550_ = out_arg_map;
		_tmp1551_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1552_ = _tmp1551_;
		_tmp1553_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1552_);
		_tmp1554_ = _tmp1553_;
		vala_map_set ((ValaMap*) _tmp1550_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos (_tmp1547_), FALSE)), (ValaCCodeExpression*) _tmp1554_);
		_vala_ccode_node_unref0 (_tmp1554_);
		_vala_ccode_node_unref0 (_tmp1552_);
	} else {
		gboolean _tmp1555_ = FALSE;
		gboolean _tmp1556_ = FALSE;
		ValaMethod* _tmp1557_;
		_tmp1557_ = m;
		if (_tmp1557_ != NULL) {
			ValaMethod* _tmp1558_;
			_tmp1558_ = m;
			_tmp1556_ = vala_method_has_error_type_parameter (_tmp1558_);
		} else {
			_tmp1556_ = FALSE;
		}
		if (_tmp1556_) {
			ValaCCodeFunctionCall* _tmp1559_;
			ValaCCodeFunctionCall* _tmp1560_;
			_tmp1559_ = async_call;
			_tmp1560_ = ccall;
			_tmp1555_ = _tmp1559_ != _tmp1560_;
		} else {
			_tmp1555_ = FALSE;
		}
		if (_tmp1555_) {
			ValaHashMap* _tmp1561_;
			ValaMethod* _tmp1562_;
			ValaCCodeConstant* _tmp1563_;
			ValaCCodeConstant* _tmp1564_;
			_tmp1561_ = out_arg_map;
			_tmp1562_ = m;
			_tmp1563_ = vala_ccode_constant_new ("NULL");
			_tmp1564_ = _tmp1563_;
			vala_map_set ((ValaMap*) _tmp1561_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_error_pos ((ValaCallable*) _tmp1562_), FALSE)), (ValaCCodeExpression*) _tmp1564_);
			_vala_ccode_node_unref0 (_tmp1564_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1565_;
		_tmp1565_ = m;
		if (_tmp1565_ == NULL) {
			ValaHashMap* _tmp1566_;
			ValaCCodeConstant* _tmp1567_;
			ValaCCodeConstant* _tmp1568_;
			_tmp1566_ = in_arg_map;
			_tmp1567_ = vala_ccode_constant_new ("NULL");
			_tmp1568_ = _tmp1567_;
			vala_map_set ((ValaMap*) _tmp1566_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1568_);
			_vala_ccode_node_unref0 (_tmp1568_);
		} else {
			gboolean _tmp1569_ = FALSE;
			gboolean _tmp1570_ = FALSE;
			gboolean _tmp1571_ = FALSE;
			ValaMethod* _tmp1572_;
			gboolean _tmp1573_;
			gboolean _tmp1574_;
			_tmp1572_ = m;
			_tmp1573_ = vala_method_get_printf_format (_tmp1572_);
			_tmp1574_ = _tmp1573_;
			if (!_tmp1574_) {
				ValaMethod* _tmp1575_;
				gboolean _tmp1576_;
				gboolean _tmp1577_;
				_tmp1575_ = m;
				_tmp1576_ = vala_method_get_scanf_format (_tmp1575_);
				_tmp1577_ = _tmp1576_;
				_tmp1571_ = !_tmp1577_;
			} else {
				_tmp1571_ = FALSE;
			}
			if (_tmp1571_) {
				ValaMethod* _tmp1578_;
				gchar* _tmp1579_;
				gchar* _tmp1580_;
				_tmp1578_ = m;
				_tmp1579_ = vala_get_ccode_sentinel (_tmp1578_);
				_tmp1580_ = _tmp1579_;
				_tmp1570_ = g_strcmp0 (_tmp1580_, "") != 0;
				_g_free0 (_tmp1580_);
			} else {
				_tmp1570_ = FALSE;
			}
			if (_tmp1570_) {
				gboolean _tmp1581_;
				gboolean _tmp1582_;
				_tmp1581_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1582_ = _tmp1581_;
				_tmp1569_ = !_tmp1582_;
			} else {
				_tmp1569_ = FALSE;
			}
			if (_tmp1569_) {
				ValaHashMap* _tmp1583_;
				ValaMethod* _tmp1584_;
				gchar* _tmp1585_;
				gchar* _tmp1586_;
				ValaCCodeConstant* _tmp1587_;
				ValaCCodeConstant* _tmp1588_;
				_tmp1583_ = in_arg_map;
				_tmp1584_ = m;
				_tmp1585_ = vala_get_ccode_sentinel (_tmp1584_);
				_tmp1586_ = _tmp1585_;
				_tmp1587_ = vala_ccode_constant_new (_tmp1586_);
				_tmp1588_ = _tmp1587_;
				vala_map_set ((ValaMap*) _tmp1583_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1588_);
				_vala_ccode_node_unref0 (_tmp1588_);
				_g_free0 (_tmp1586_);
			}
		}
	}
	_tmp1590_ = deleg;
	if (_tmp1590_ != NULL) {
		ValaDelegate* _tmp1591_;
		gboolean _tmp1592_;
		gboolean _tmp1593_;
		_tmp1591_ = deleg;
		_tmp1592_ = vala_delegate_get_has_target (_tmp1591_);
		_tmp1593_ = _tmp1592_;
		_tmp1589_ = _tmp1593_;
	} else {
		_tmp1589_ = FALSE;
	}
	if (_tmp1589_) {
		ValaCCodeExpression* delegate_target_destroy_notify = NULL;
		ValaHashMap* _tmp1594_;
		ValaDelegate* _tmp1595_;
		ValaExpression* _tmp1596_;
		ValaExpression* _tmp1597_;
		ValaCCodeExpression* _tmp1598_ = NULL;
		ValaCCodeExpression* _tmp1599_;
		ValaCCodeExpression* _tmp1600_;
		ValaHashMap* _tmp1601_;
		ValaDelegate* _tmp1602_;
		ValaExpression* _tmp1603_;
		ValaExpression* _tmp1604_;
		ValaCCodeExpression* _tmp1605_ = NULL;
		ValaCCodeExpression* _tmp1606_;
		ValaCCodeExpression* _tmp1607_;
		_tmp1594_ = in_arg_map;
		_tmp1595_ = deleg;
		_tmp1596_ = vala_method_call_get_call (expr);
		_tmp1597_ = _tmp1596_;
		_tmp1599_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1597_, &_tmp1598_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1598_;
		_tmp1600_ = _tmp1599_;
		vala_map_set ((ValaMap*) _tmp1594_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1595_), FALSE)), _tmp1600_);
		_vala_ccode_node_unref0 (_tmp1600_);
		_tmp1601_ = out_arg_map;
		_tmp1602_ = deleg;
		_tmp1603_ = vala_method_call_get_call (expr);
		_tmp1604_ = _tmp1603_;
		_tmp1606_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1604_, &_tmp1605_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		delegate_target_destroy_notify = _tmp1605_;
		_tmp1607_ = _tmp1606_;
		vala_map_set ((ValaMap*) _tmp1601_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1602_), FALSE)), _tmp1607_);
		_vala_ccode_node_unref0 (_tmp1607_);
		_vala_ccode_node_unref0 (delegate_target_destroy_notify);
	}
	_tmp1608_ = itype;
	_tmp1609_ = vala_data_type_get_return_type (_tmp1608_);
	return_result_via_out_param = vala_data_type_is_real_non_null_struct_type (_tmp1609_);
	_tmp1611_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1611_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1612_;
		ValaDataType* _tmp1613_;
		_tmp1612_ = itype;
		_tmp1613_ = vala_data_type_get_return_type (_tmp1612_);
		_tmp1610_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1613_, VALA_TYPE_VOID_TYPE);
	} else {
		_tmp1610_ = FALSE;
	}
	if (_tmp1610_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1614_;
		ValaSignal* _tmp1615_;
		ValaSignal* _tmp1616_;
		ValaSignal* _tmp1617_;
		gboolean _tmp1618_ = FALSE;
		gboolean _tmp1619_ = FALSE;
		ValaMemberAccess* _tmp1620_;
		_tmp1614_ = itype;
		_tmp1615_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1614_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1616_ = _tmp1615_;
		_tmp1617_ = _vala_code_node_ref0 (_tmp1616_);
		sig = _tmp1617_;
		_tmp1620_ = ma;
		if (_tmp1620_ != NULL) {
			ValaMemberAccess* _tmp1621_;
			ValaExpression* _tmp1622_;
			ValaExpression* _tmp1623_;
			_tmp1621_ = ma;
			_tmp1622_ = vala_member_access_get_inner (_tmp1621_);
			_tmp1623_ = _tmp1622_;
			_tmp1619_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1623_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1619_ = FALSE;
		}
		if (_tmp1619_) {
			ValaSignal* _tmp1624_;
			gboolean _tmp1625_;
			gboolean _tmp1626_;
			_tmp1624_ = sig;
			_tmp1625_ = vala_signal_get_is_virtual (_tmp1624_);
			_tmp1626_ = _tmp1625_;
			_tmp1618_ = _tmp1626_;
		} else {
			_tmp1618_ = FALSE;
		}
		if (_tmp1618_) {
		} else {
			gboolean _tmp1627_ = FALSE;
			ValaSignal* _tmp1628_;
			_tmp1628_ = sig;
			if (!vala_get_ccode_has_emitter (_tmp1628_)) {
				_tmp1627_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1629_;
				ValaSourceReference* _tmp1630_;
				ValaSourceReference* _tmp1631_;
				ValaSourceFile* _tmp1632_;
				ValaSourceFile* _tmp1633_;
				ValaSignal* _tmp1634_;
				ValaSourceReference* _tmp1635_;
				ValaSourceReference* _tmp1636_;
				ValaSourceFile* _tmp1637_;
				ValaSourceFile* _tmp1638_;
				_tmp1629_ = ma;
				_tmp1630_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1629_);
				_tmp1631_ = _tmp1630_;
				_tmp1632_ = vala_source_reference_get_file (_tmp1631_);
				_tmp1633_ = _tmp1632_;
				_tmp1634_ = sig;
				_tmp1635_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1634_);
				_tmp1636_ = _tmp1635_;
				_tmp1637_ = vala_source_reference_get_file (_tmp1636_);
				_tmp1638_ = _tmp1637_;
				_tmp1627_ = _tmp1633_ == _tmp1638_;
			}
			if (_tmp1627_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1639_ = async_call;
	_tmp1640_ = ccall;
	if (_tmp1639_ == _tmp1640_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1641_;
		ValaDataType* _tmp1642_;
		ValaLocalVariable* _tmp1643_;
		ValaLocalVariable* _tmp1644_;
		const gchar* _tmp1645_;
		const gchar* _tmp1646_;
		ValaCCodeExpression* _tmp1647_;
		ValaLocalVariable* _tmp1648_;
		ValaHashMap* _tmp1649_;
		ValaCCodeExpression* _tmp1650_;
		ValaCCodeUnaryExpression* _tmp1651_;
		ValaCCodeUnaryExpression* _tmp1652_;
		_tmp1641_ = itype;
		_tmp1642_ = vala_data_type_get_return_type (_tmp1641_);
		_tmp1643_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1642_, TRUE, NULL, TRUE);
		out_param_var = _tmp1643_;
		_tmp1644_ = out_param_var;
		_tmp1645_ = vala_symbol_get_name ((ValaSymbol*) _tmp1644_);
		_tmp1646_ = _tmp1645_;
		_tmp1647_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1646_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1647_;
		_tmp1648_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1648_, FALSE);
		_tmp1649_ = out_arg_map;
		_tmp1650_ = out_param_ref;
		_tmp1651_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1650_);
		_tmp1652_ = _tmp1651_;
		vala_map_set ((ValaMap*) _tmp1649_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1652_);
		_vala_ccode_node_unref0 (_tmp1652_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1653_ = async_call;
	_tmp1654_ = ccall;
	if (_tmp1653_ != _tmp1654_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1665_;
			ValaHashMap* _tmp1666_;
			gpointer _tmp1667_;
			ValaCCodeExpression* _tmp1668_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1655_;
				ValaSet* _tmp1656_;
				ValaSet* _tmp1657_;
				ValaIterator* _tmp1658_;
				ValaIterator* _tmp1659_;
				_tmp1655_ = out_arg_map;
				_tmp1656_ = vala_map_get_keys ((ValaMap*) _tmp1655_);
				_tmp1657_ = _tmp1656_;
				_tmp1658_ = vala_iterable_iterator ((ValaIterable*) _tmp1657_);
				_tmp1659_ = _tmp1658_;
				_vala_iterable_unref0 (_tmp1657_);
				_pos_it = _tmp1659_;
				while (TRUE) {
					ValaIterator* _tmp1660_;
					gint pos = 0;
					ValaIterator* _tmp1661_;
					gpointer _tmp1662_;
					gboolean _tmp1663_ = FALSE;
					_tmp1660_ = _pos_it;
					if (!vala_iterator_next (_tmp1660_)) {
						break;
					}
					_tmp1661_ = _pos_it;
					_tmp1662_ = vala_iterator_get (_tmp1661_);
					pos = (gint) ((gintptr) _tmp1662_);
					if (pos > last_pos) {
						gboolean _tmp1664_ = FALSE;
						if (min_pos == -1) {
							_tmp1664_ = TRUE;
						} else {
							_tmp1664_ = pos < min_pos;
						}
						_tmp1663_ = _tmp1664_;
					} else {
						_tmp1663_ = FALSE;
					}
					if (_tmp1663_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1665_ = ccall;
			_tmp1666_ = out_arg_map;
			_tmp1667_ = vala_map_get ((ValaMap*) _tmp1666_, (gpointer) ((gintptr) min_pos));
			_tmp1668_ = (ValaCCodeExpression*) _tmp1667_;
			vala_ccode_function_call_add_argument (_tmp1665_, _tmp1668_);
			_vala_ccode_node_unref0 (_tmp1668_);
			last_pos = min_pos;
		}
	}
	_tmp1669_ = async_call;
	if (_tmp1669_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1680_;
			ValaHashMap* _tmp1681_;
			gpointer _tmp1682_;
			ValaCCodeExpression* _tmp1683_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1670_;
				ValaSet* _tmp1671_;
				ValaSet* _tmp1672_;
				ValaIterator* _tmp1673_;
				ValaIterator* _tmp1674_;
				_tmp1670_ = in_arg_map;
				_tmp1671_ = vala_map_get_keys ((ValaMap*) _tmp1670_);
				_tmp1672_ = _tmp1671_;
				_tmp1673_ = vala_iterable_iterator ((ValaIterable*) _tmp1672_);
				_tmp1674_ = _tmp1673_;
				_vala_iterable_unref0 (_tmp1672_);
				_pos_it = _tmp1674_;
				while (TRUE) {
					ValaIterator* _tmp1675_;
					gint pos = 0;
					ValaIterator* _tmp1676_;
					gpointer _tmp1677_;
					gboolean _tmp1678_ = FALSE;
					_tmp1675_ = _pos_it;
					if (!vala_iterator_next (_tmp1675_)) {
						break;
					}
					_tmp1676_ = _pos_it;
					_tmp1677_ = vala_iterator_get (_tmp1676_);
					pos = (gint) ((gintptr) _tmp1677_);
					if (pos > last_pos) {
						gboolean _tmp1679_ = FALSE;
						if (min_pos == -1) {
							_tmp1679_ = TRUE;
						} else {
							_tmp1679_ = pos < min_pos;
						}
						_tmp1678_ = _tmp1679_;
					} else {
						_tmp1678_ = FALSE;
					}
					if (_tmp1678_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1680_ = async_call;
			_tmp1681_ = in_arg_map;
			_tmp1682_ = vala_map_get ((ValaMap*) _tmp1681_, (gpointer) ((gintptr) min_pos));
			_tmp1683_ = (ValaCCodeExpression*) _tmp1682_;
			vala_ccode_function_call_add_argument (_tmp1680_, _tmp1683_);
			_vala_ccode_node_unref0 (_tmp1683_);
			last_pos = min_pos;
		}
	}
	_tmp1684_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1685_ = _tmp1684_;
	if (_tmp1685_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1686_;
		gint _tmp1687_;
		ValaCCodeFunction* _tmp1688_;
		ValaCCodeFunction* _tmp1689_;
		ValaCCodeIdentifier* _tmp1690_;
		ValaCCodeIdentifier* _tmp1691_;
		ValaCCodeMemberAccess* _tmp1692_;
		ValaCCodeMemberAccess* _tmp1693_;
		gchar* _tmp1694_;
		gchar* _tmp1695_;
		ValaCCodeConstant* _tmp1696_;
		ValaCCodeConstant* _tmp1697_;
		ValaCCodeFunction* _tmp1698_;
		ValaCCodeFunction* _tmp1699_;
		ValaCCodeFunctionCall* _tmp1700_;
		ValaCCodeFunction* _tmp1701_;
		ValaCCodeFunction* _tmp1702_;
		ValaCCodeConstant* _tmp1703_;
		ValaCCodeConstant* _tmp1704_;
		ValaCCodeFunction* _tmp1705_;
		ValaCCodeFunction* _tmp1706_;
		gchar* _tmp1707_;
		gchar* _tmp1708_;
		_tmp1686_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1687_ = _tmp1686_->next_coroutine_state;
		_tmp1686_->next_coroutine_state = _tmp1687_ + 1;
		state = _tmp1687_;
		_tmp1688_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1689_ = _tmp1688_;
		_tmp1690_ = vala_ccode_identifier_new ("_data_");
		_tmp1691_ = _tmp1690_;
		_tmp1692_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1691_, "_state_");
		_tmp1693_ = _tmp1692_;
		_tmp1694_ = g_strdup_printf ("%i", state);
		_tmp1695_ = _tmp1694_;
		_tmp1696_ = vala_ccode_constant_new (_tmp1695_);
		_tmp1697_ = _tmp1696_;
		vala_ccode_function_add_assignment (_tmp1689_, (ValaCCodeExpression*) _tmp1693_, (ValaCCodeExpression*) _tmp1697_);
		_vala_ccode_node_unref0 (_tmp1697_);
		_g_free0 (_tmp1695_);
		_vala_ccode_node_unref0 (_tmp1693_);
		_vala_ccode_node_unref0 (_tmp1691_);
		_tmp1698_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1699_ = _tmp1698_;
		_tmp1700_ = async_call;
		vala_ccode_function_add_expression (_tmp1699_, (ValaCCodeExpression*) _tmp1700_);
		_tmp1701_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1702_ = _tmp1701_;
		_tmp1703_ = vala_ccode_constant_new ("FALSE");
		_tmp1704_ = _tmp1703_;
		vala_ccode_function_add_return (_tmp1702_, (ValaCCodeExpression*) _tmp1704_);
		_vala_ccode_node_unref0 (_tmp1704_);
		_tmp1705_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1706_ = _tmp1705_;
		_tmp1707_ = g_strdup_printf ("_state_%d", state);
		_tmp1708_ = _tmp1707_;
		vala_ccode_function_add_label (_tmp1706_, _tmp1708_);
		_g_free0 (_tmp1708_);
	}
	_tmp1709_ = vala_method_call_get_is_assert (expr);
	_tmp1710_ = _tmp1709_;
	if (_tmp1710_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1711_;
		ValaSourceReference* _tmp1712_;
		ValaSourceLocation _tmp1713_ = {0};
		ValaSourceLocation _tmp1714_;
		gchar* _tmp1715_;
		ValaSourceReference* _tmp1716_;
		ValaSourceReference* _tmp1717_;
		ValaSourceLocation _tmp1718_ = {0};
		ValaSourceLocation _tmp1719_;
		gchar* _tmp1720_;
		ValaSourceReference* _tmp1721_;
		ValaSourceReference* _tmp1722_;
		ValaSourceLocation _tmp1723_ = {0};
		ValaSourceLocation _tmp1724_;
		gchar* _tmp1725_;
		gchar* _tmp1726_;
		ValaCCodeFunctionCall* _tmp1727_;
		ValaCCodeIdentifier* _tmp1728_;
		ValaCCodeIdentifier* _tmp1729_;
		ValaCCodeFunctionCall* _tmp1730_;
		const gchar* _tmp1731_;
		gchar* _tmp1732_;
		gchar* _tmp1733_;
		gchar* _tmp1734_;
		gchar* _tmp1735_;
		gchar* _tmp1736_;
		gchar* _tmp1737_;
		ValaCCodeConstant* _tmp1738_;
		ValaCCodeConstant* _tmp1739_;
		_tmp1711_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1712_ = _tmp1711_;
		vala_source_reference_get_begin (_tmp1712_, &_tmp1713_);
		_tmp1714_ = _tmp1713_;
		_tmp1715_ = _tmp1714_.pos;
		_tmp1716_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1717_ = _tmp1716_;
		vala_source_reference_get_end (_tmp1717_, &_tmp1718_);
		_tmp1719_ = _tmp1718_;
		_tmp1720_ = _tmp1719_.pos;
		_tmp1721_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1722_ = _tmp1721_;
		vala_source_reference_get_begin (_tmp1722_, &_tmp1723_);
		_tmp1724_ = _tmp1723_;
		_tmp1725_ = _tmp1724_.pos;
		_tmp1726_ = string_substring ((const gchar*) _tmp1715_, (glong) 0, (glong) ((gint) (_tmp1720_ - _tmp1725_)));
		message = _tmp1726_;
		_tmp1727_ = ccall;
		_tmp1728_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1729_ = _tmp1728_;
		vala_ccode_function_call_set_call (_tmp1727_, (ValaCCodeExpression*) _tmp1729_);
		_vala_ccode_node_unref0 (_tmp1729_);
		_tmp1730_ = ccall;
		_tmp1731_ = message;
		_tmp1732_ = string_replace (_tmp1731_, "\n", " ");
		_tmp1733_ = _tmp1732_;
		_tmp1734_ = g_strescape (_tmp1733_, "");
		_tmp1735_ = _tmp1734_;
		_tmp1736_ = g_strdup_printf ("\"%s\"", _tmp1735_);
		_tmp1737_ = _tmp1736_;
		_tmp1738_ = vala_ccode_constant_new (_tmp1737_);
		_tmp1739_ = _tmp1738_;
		vala_ccode_function_call_add_argument (_tmp1730_, (ValaCCodeExpression*) _tmp1739_);
		_vala_ccode_node_unref0 (_tmp1739_);
		_g_free0 (_tmp1737_);
		_g_free0 (_tmp1735_);
		_g_free0 (_tmp1733_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1740_;
		ValaCCodeFunction* _tmp1741_;
		ValaCCodeExpression* _tmp1742_;
		ValaCCodeExpression* _tmp1743_;
		ValaCCodeExpression* _tmp1744_;
		_tmp1740_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1741_ = _tmp1740_;
		_tmp1742_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1741_, _tmp1742_);
		_tmp1743_ = out_param_ref;
		_tmp1744_ = _vala_ccode_node_ref0 (_tmp1743_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1744_;
	}
	_tmp1747_ = m;
	if (_tmp1747_ != NULL) {
		ValaMethod* _tmp1748_;
		ValaMemberBinding _tmp1749_;
		ValaMemberBinding _tmp1750_;
		_tmp1748_ = m;
		_tmp1749_ = vala_method_get_binding (_tmp1748_);
		_tmp1750_ = _tmp1749_;
		_tmp1746_ = _tmp1750_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1746_ = FALSE;
	}
	if (_tmp1746_) {
		ValaMethod* _tmp1751_;
		gboolean _tmp1752_;
		gboolean _tmp1753_;
		_tmp1751_ = m;
		_tmp1752_ = vala_method_get_returns_modified_pointer (_tmp1751_);
		_tmp1753_ = _tmp1752_;
		_tmp1745_ = _tmp1753_;
	} else {
		_tmp1745_ = FALSE;
	}
	if (_tmp1745_) {
		gboolean _tmp1754_ = FALSE;
		gboolean _tmp1755_ = FALSE;
		ValaMemberAccess* _tmp1756_;
		_tmp1756_ = ma;
		if (_tmp1756_ != NULL) {
			ValaMemberAccess* _tmp1757_;
			ValaExpression* _tmp1758_;
			ValaExpression* _tmp1759_;
			ValaSymbol* _tmp1760_;
			ValaSymbol* _tmp1761_;
			_tmp1757_ = ma;
			_tmp1758_ = vala_member_access_get_inner (_tmp1757_);
			_tmp1759_ = _tmp1758_;
			_tmp1760_ = vala_expression_get_symbol_reference (_tmp1759_);
			_tmp1761_ = _tmp1760_;
			_tmp1755_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1761_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1755_ = FALSE;
		}
		if (_tmp1755_) {
			ValaMemberAccess* _tmp1762_;
			ValaExpression* _tmp1763_;
			ValaExpression* _tmp1764_;
			_tmp1762_ = ma;
			_tmp1763_ = vala_member_access_get_inner (_tmp1762_);
			_tmp1764_ = _tmp1763_;
			_tmp1754_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1764_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1754_ = FALSE;
		}
		if (_tmp1754_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1765_;
			ValaExpression* _tmp1766_;
			ValaExpression* _tmp1767_;
			ValaSymbol* _tmp1768_;
			ValaSymbol* _tmp1769_;
			ValaProperty* _tmp1770_;
			ValaProperty* _tmp1771_;
			ValaMemberAccess* _tmp1772_;
			ValaExpression* _tmp1773_;
			ValaExpression* _tmp1774_;
			ValaExpression* _tmp1775_;
			ValaExpression* _tmp1776_;
			ValaDataType* _tmp1777_;
			ValaDataType* _tmp1778_;
			ValaCCodeExpression* _tmp1779_;
			ValaGLibValue* _tmp1780_;
			ValaGLibValue* _tmp1781_;
			_tmp1765_ = ma;
			_tmp1766_ = vala_member_access_get_inner (_tmp1765_);
			_tmp1767_ = _tmp1766_;
			_tmp1768_ = vala_expression_get_symbol_reference (_tmp1767_);
			_tmp1769_ = _tmp1768_;
			_tmp1770_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1769_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1770_;
			_tmp1771_ = prop;
			_tmp1772_ = ma;
			_tmp1773_ = vala_member_access_get_inner (_tmp1772_);
			_tmp1774_ = _tmp1773_;
			_tmp1775_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1774_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1776_ = _tmp1775_;
			_tmp1777_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1778_ = _tmp1777_;
			_tmp1779_ = ccall_expr;
			_tmp1780_ = vala_glib_value_new (_tmp1778_, _tmp1779_, FALSE);
			_tmp1781_ = _tmp1780_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1771_, _tmp1776_, (ValaTargetValue*) _tmp1781_);
			_vala_target_value_unref0 (_tmp1781_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1782_;
			ValaCCodeExpression* _tmp1783_;
			ValaCCodeAssignment* _tmp1784_;
			_tmp1782_ = instance;
			_tmp1783_ = ccall_expr;
			_tmp1784_ = vala_ccode_assignment_new (_tmp1782_, _tmp1783_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1784_;
		}
	}
	_tmp1790_ = m;
	if (_tmp1790_ != NULL) {
		ValaMethod* _tmp1791_;
		_tmp1791_ = m;
		_tmp1789_ = vala_get_ccode_simple_generics (_tmp1791_);
	} else {
		_tmp1789_ = FALSE;
	}
	if (_tmp1789_) {
		ValaMethod* _tmp1792_;
		ValaDataType* _tmp1793_;
		ValaDataType* _tmp1794_;
		_tmp1792_ = m;
		_tmp1793_ = vala_callable_get_return_type ((ValaCallable*) _tmp1792_);
		_tmp1794_ = _tmp1793_;
		_tmp1788_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1794_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1788_ = FALSE;
	}
	if (_tmp1788_) {
		ValaDataType* _tmp1795_;
		ValaDataType* _tmp1796_;
		_tmp1795_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1796_ = _tmp1795_;
		_tmp1787_ = vala_data_type_is_real_struct_type (_tmp1796_);
	} else {
		_tmp1787_ = FALSE;
	}
	if (_tmp1787_) {
		ValaDataType* _tmp1797_;
		ValaDataType* _tmp1798_;
		gboolean _tmp1799_;
		gboolean _tmp1800_;
		_tmp1797_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1798_ = _tmp1797_;
		_tmp1799_ = vala_data_type_get_nullable (_tmp1798_);
		_tmp1800_ = _tmp1799_;
		_tmp1786_ = !_tmp1800_;
	} else {
		_tmp1786_ = FALSE;
	}
	if (_tmp1786_) {
		ValaDataType* _tmp1801_;
		ValaDataType* _tmp1802_;
		_tmp1801_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1802_ = _tmp1801_;
		_tmp1785_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1802_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1785_ = FALSE;
	}
	if (_tmp1785_) {
		ValaCCodeExpression* _tmp1803_;
		ValaCCodeParenthesizedExpression* _tmp1804_;
		ValaCCodeParenthesizedExpression* _tmp1805_;
		ValaCCodeUnaryExpression* _tmp1806_;
		_tmp1803_ = ccall_expr;
		_tmp1804_ = vala_ccode_parenthesized_expression_new (_tmp1803_);
		_tmp1805_ = _tmp1804_;
		_tmp1806_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1805_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1806_;
		_vala_ccode_node_unref0 (_tmp1805_);
	}
	_tmp1809_ = m;
	if (_tmp1809_ != NULL) {
		ValaMethod* _tmp1810_;
		gchar* _tmp1811_;
		gchar* _tmp1812_;
		_tmp1810_ = m;
		_tmp1811_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1810_);
		_tmp1812_ = _tmp1811_;
		_tmp1808_ = _tmp1812_ != NULL;
		_g_free0 (_tmp1812_);
	} else {
		_tmp1808_ = FALSE;
	}
	if (_tmp1808_) {
		ValaMethod* _tmp1813_;
		gchar* _tmp1814_;
		gchar* _tmp1815_;
		ValaMethod* _tmp1816_;
		ValaDataType* _tmp1817_;
		ValaDataType* _tmp1818_;
		gchar* _tmp1819_;
		gchar* _tmp1820_;
		_tmp1813_ = m;
		_tmp1814_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1813_);
		_tmp1815_ = _tmp1814_;
		_tmp1816_ = m;
		_tmp1817_ = vala_callable_get_return_type ((ValaCallable*) _tmp1816_);
		_tmp1818_ = _tmp1817_;
		_tmp1819_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1818_);
		_tmp1820_ = _tmp1819_;
		_tmp1807_ = g_strcmp0 (_tmp1815_, _tmp1820_) != 0;
		_g_free0 (_tmp1820_);
		_g_free0 (_tmp1815_);
	} else {
		_tmp1807_ = FALSE;
	}
	if (_tmp1807_) {
		ValaCCodeExpression* _tmp1821_;
		ValaMethod* _tmp1822_;
		ValaDataType* _tmp1823_;
		ValaDataType* _tmp1824_;
		gchar* _tmp1825_;
		gchar* _tmp1826_;
		ValaCCodeCastExpression* _tmp1827_;
		_tmp1821_ = ccall_expr;
		_tmp1822_ = m;
		_tmp1823_ = vala_callable_get_return_type ((ValaCallable*) _tmp1822_);
		_tmp1824_ = _tmp1823_;
		_tmp1825_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1824_);
		_tmp1826_ = _tmp1825_;
		_tmp1827_ = vala_ccode_cast_expression_new (_tmp1821_, _tmp1826_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1827_;
		_g_free0 (_tmp1826_);
	}
	_tmp1828_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1828_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1829_;
		ValaIterator* _tmp1830_;
		ValaIterator* _tmp1831_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1832_;
		gpointer _tmp1833_;
		ValaExpression* _tmp1834_;
		ValaCCodeExpression* _tmp1835_;
		ValaCCodeExpression* _tmp1836_;
		ValaCCodeExpression* _tmp1837_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1838_;
		ValaLocalVariable* _tmp1839_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1840_;
		const gchar* _tmp1841_;
		const gchar* _tmp1842_;
		ValaCCodeExpression* _tmp1843_;
		ValaLocalVariable* _tmp1844_;
		ValaCCodeFile* _tmp1845_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1846_;
		ValaExpression* _tmp1847_;
		ValaExpression* _tmp1848_;
		ValaCCodeExpression* _tmp1849_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1850_;
		ValaExpression* _tmp1851_;
		ValaExpression* _tmp1852_;
		ValaCCodeExpression* _tmp1853_;
		ValaCCodeExpression* _tmp1854_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1855_;
		ValaExpression* _tmp1856_;
		ValaExpression* _tmp1857_;
		ValaDataType* _tmp1858_;
		ValaDataType* _tmp1859_;
		ValaArrayType* _tmp1860_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1861_;
		ValaDataType* _tmp1862_;
		ValaDataType* _tmp1863_;
		gchar* _tmp1864_;
		gchar* _tmp1865_;
		gchar* _tmp1866_;
		gchar* _tmp1867_;
		ValaCCodeIdentifier* _tmp1868_;
		ValaCCodeIdentifier* _tmp1869_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1870_;
		ValaCCodeExpression* _tmp1871_;
		ValaCCodeBinaryExpression* _tmp1872_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1873_;
		ValaCCodeExpression* _tmp1874_;
		ValaCCodeBinaryExpression* _tmp1875_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1876_;
		ValaCCodeIdentifier* _tmp1877_;
		ValaCCodeFunctionCall* _tmp1878_;
		ValaCCodeFunctionCall* _tmp1879_;
		ValaCCodeFunctionCall* _tmp1880_;
		ValaCCodeExpression* _tmp1881_;
		ValaCCodeExpression* _tmp1882_;
		ValaCCodeBinaryExpression* _tmp1883_;
		ValaCCodeBinaryExpression* _tmp1884_;
		ValaCCodeFunctionCall* _tmp1885_;
		ValaCCodeConstant* _tmp1886_;
		ValaCCodeConstant* _tmp1887_;
		ValaCCodeFunctionCall* _tmp1888_;
		ValaCCodeIdentifier* _tmp1889_;
		ValaCCodeBinaryExpression* _tmp1890_;
		ValaCCodeBinaryExpression* _tmp1891_;
		ValaCCodeBinaryExpression* _tmp1892_;
		ValaCCodeFunction* _tmp1893_;
		ValaCCodeFunction* _tmp1894_;
		ValaCCodeExpression* _tmp1895_;
		ValaCCodeExpression* _tmp1896_;
		ValaCCodeFunction* _tmp1897_;
		ValaCCodeFunction* _tmp1898_;
		ValaCCodeExpression* _tmp1899_;
		ValaCCodeFunction* _tmp1900_;
		ValaCCodeFunction* _tmp1901_;
		ValaCCodeBinaryExpression* _tmp1902_;
		ValaCCodeFunctionCall* _tmp1903_;
		ValaCCodeConstant* _tmp1904_;
		ValaCCodeConstant* _tmp1905_;
		ValaCCodeConditionalExpression* _tmp1906_;
		ValaCCodeConditionalExpression* _tmp1907_;
		ValaCCodeFunction* _tmp1908_;
		ValaCCodeFunction* _tmp1909_;
		ValaMemberAccess* _tmp1910_;
		ValaExpression* _tmp1911_;
		ValaExpression* _tmp1912_;
		ValaCCodeExpression* _tmp1913_;
		ValaCCodeExpression* _tmp1914_;
		ValaCCodeExpression* _tmp1915_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1916_;
		ValaExpression* _tmp1917_;
		ValaExpression* _tmp1918_;
		ValaSymbol* _tmp1919_;
		ValaSymbol* _tmp1920_;
		ValaSymbol* _tmp1921_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1922_;
		ValaLocalVariable* _tmp1923_;
		gboolean _tmp1924_ = FALSE;
		gboolean _tmp1925_ = FALSE;
		ValaSymbol* _tmp1926_;
		_tmp1829_ = vala_method_call_get_argument_list (expr);
		_tmp1830_ = vala_iterable_iterator ((ValaIterable*) _tmp1829_);
		arg_it = _tmp1830_;
		_tmp1831_ = arg_it;
		vala_iterator_next (_tmp1831_);
		_tmp1832_ = arg_it;
		_tmp1833_ = vala_iterator_get (_tmp1832_);
		_tmp1834_ = (ValaExpression*) _tmp1833_;
		_tmp1835_ = vala_get_cvalue (_tmp1834_);
		_tmp1836_ = _vala_ccode_node_ref0 (_tmp1835_);
		_tmp1837_ = _tmp1836_;
		_vala_code_node_unref0 (_tmp1834_);
		new_size = _tmp1837_;
		_tmp1838_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1839_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1838_, TRUE, NULL, FALSE);
		temp_decl = _tmp1839_;
		_tmp1840_ = temp_decl;
		_tmp1841_ = vala_symbol_get_name ((ValaSymbol*) _tmp1840_);
		_tmp1842_ = _tmp1841_;
		_tmp1843_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1842_);
		temp_ref = _tmp1843_;
		_tmp1844_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1844_, FALSE);
		_tmp1845_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1845_, "string.h", FALSE);
		_tmp1846_ = ma;
		_tmp1847_ = vala_member_access_get_inner (_tmp1846_);
		_tmp1848_ = _tmp1847_;
		_tmp1849_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1848_, 1);
		clen = _tmp1849_;
		_tmp1850_ = ma;
		_tmp1851_ = vala_member_access_get_inner (_tmp1850_);
		_tmp1852_ = _tmp1851_;
		_tmp1853_ = vala_get_cvalue (_tmp1852_);
		_tmp1854_ = _vala_ccode_node_ref0 (_tmp1853_);
		celems = _tmp1854_;
		_tmp1855_ = ma;
		_tmp1856_ = vala_member_access_get_inner (_tmp1855_);
		_tmp1857_ = _tmp1856_;
		_tmp1858_ = vala_expression_get_value_type (_tmp1857_);
		_tmp1859_ = _tmp1858_;
		_tmp1860_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1859_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1860_;
		_tmp1861_ = array_type;
		_tmp1862_ = vala_array_type_get_element_type (_tmp1861_);
		_tmp1863_ = _tmp1862_;
		_tmp1864_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1863_);
		_tmp1865_ = _tmp1864_;
		_tmp1866_ = g_strdup_printf ("sizeof (%s)", _tmp1865_);
		_tmp1867_ = _tmp1866_;
		_tmp1868_ = vala_ccode_identifier_new (_tmp1867_);
		_tmp1869_ = _tmp1868_;
		_g_free0 (_tmp1867_);
		_g_free0 (_tmp1865_);
		csizeof = _tmp1869_;
		_tmp1870_ = temp_ref;
		_tmp1871_ = clen;
		_tmp1872_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1870_, _tmp1871_);
		cdelta = _tmp1872_;
		_tmp1873_ = temp_ref;
		_tmp1874_ = clen;
		_tmp1875_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1873_, _tmp1874_);
		ccheck = _tmp1875_;
		_tmp1876_ = vala_ccode_identifier_new ("memset");
		_tmp1877_ = _tmp1876_;
		_tmp1878_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1877_);
		_tmp1879_ = _tmp1878_;
		_vala_ccode_node_unref0 (_tmp1877_);
		czero = _tmp1879_;
		_tmp1880_ = czero;
		_tmp1881_ = celems;
		_tmp1882_ = clen;
		_tmp1883_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1881_, _tmp1882_);
		_tmp1884_ = _tmp1883_;
		vala_ccode_function_call_add_argument (_tmp1880_, (ValaCCodeExpression*) _tmp1884_);
		_vala_ccode_node_unref0 (_tmp1884_);
		_tmp1885_ = czero;
		_tmp1886_ = vala_ccode_constant_new ("0");
		_tmp1887_ = _tmp1886_;
		vala_ccode_function_call_add_argument (_tmp1885_, (ValaCCodeExpression*) _tmp1887_);
		_vala_ccode_node_unref0 (_tmp1887_);
		_tmp1888_ = czero;
		_tmp1889_ = csizeof;
		_tmp1890_ = cdelta;
		_tmp1891_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1889_, (ValaCCodeExpression*) _tmp1890_);
		_tmp1892_ = _tmp1891_;
		vala_ccode_function_call_add_argument (_tmp1888_, (ValaCCodeExpression*) _tmp1892_);
		_vala_ccode_node_unref0 (_tmp1892_);
		_tmp1893_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1894_ = _tmp1893_;
		_tmp1895_ = temp_ref;
		_tmp1896_ = new_size;
		vala_ccode_function_add_assignment (_tmp1894_, _tmp1895_, _tmp1896_);
		_tmp1897_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1898_ = _tmp1897_;
		_tmp1899_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1898_, _tmp1899_);
		_tmp1900_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1901_ = _tmp1900_;
		_tmp1902_ = ccheck;
		_tmp1903_ = czero;
		_tmp1904_ = vala_ccode_constant_new ("NULL");
		_tmp1905_ = _tmp1904_;
		_tmp1906_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1902_, (ValaCCodeExpression*) _tmp1903_, (ValaCCodeExpression*) _tmp1905_);
		_tmp1907_ = _tmp1906_;
		vala_ccode_function_add_expression (_tmp1901_, (ValaCCodeExpression*) _tmp1907_);
		_vala_ccode_node_unref0 (_tmp1907_);
		_vala_ccode_node_unref0 (_tmp1905_);
		_tmp1908_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1909_ = _tmp1908_;
		_tmp1910_ = ma;
		_tmp1911_ = vala_member_access_get_inner (_tmp1910_);
		_tmp1912_ = _tmp1911_;
		_tmp1913_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1912_, 1);
		_tmp1914_ = _tmp1913_;
		_tmp1915_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1909_, _tmp1914_, _tmp1915_);
		_vala_ccode_node_unref0 (_tmp1914_);
		_tmp1916_ = ma;
		_tmp1917_ = vala_member_access_get_inner (_tmp1916_);
		_tmp1918_ = _tmp1917_;
		_tmp1919_ = vala_expression_get_symbol_reference (_tmp1918_);
		_tmp1920_ = _tmp1919_;
		_tmp1921_ = _vala_code_node_ref0 (_tmp1920_);
		array_var = _tmp1921_;
		_tmp1922_ = array_var;
		_tmp1923_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1922_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1922_) : NULL);
		array_local = _tmp1923_;
		_tmp1926_ = array_var;
		if (_tmp1926_ != NULL) {
			ValaSymbol* _tmp1927_;
			_tmp1927_ = array_var;
			_tmp1925_ = vala_symbol_is_internal_symbol (_tmp1927_);
		} else {
			_tmp1925_ = FALSE;
		}
		if (_tmp1925_) {
			gboolean _tmp1928_ = FALSE;
			gboolean _tmp1929_ = FALSE;
			ValaSymbol* _tmp1930_;
			_tmp1930_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1930_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1931_;
				gboolean _tmp1932_;
				gboolean _tmp1933_;
				_tmp1931_ = array_local;
				_tmp1932_ = vala_local_variable_get_captured (_tmp1931_);
				_tmp1933_ = _tmp1932_;
				_tmp1929_ = !_tmp1933_;
			} else {
				_tmp1929_ = FALSE;
			}
			if (_tmp1929_) {
				_tmp1928_ = TRUE;
			} else {
				ValaSymbol* _tmp1934_;
				_tmp1934_ = array_var;
				_tmp1928_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1934_, VALA_TYPE_FIELD);
			}
			_tmp1924_ = _tmp1928_;
		} else {
			_tmp1924_ = FALSE;
		}
		if (_tmp1924_) {
			ValaCCodeFunction* _tmp1935_;
			ValaCCodeFunction* _tmp1936_;
			ValaMemberAccess* _tmp1937_;
			ValaExpression* _tmp1938_;
			ValaExpression* _tmp1939_;
			ValaTargetValue* _tmp1940_;
			ValaTargetValue* _tmp1941_;
			ValaCCodeExpression* _tmp1942_;
			ValaCCodeExpression* _tmp1943_;
			_tmp1935_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1936_ = _tmp1935_;
			_tmp1937_ = ma;
			_tmp1938_ = vala_member_access_get_inner (_tmp1937_);
			_tmp1939_ = _tmp1938_;
			_tmp1940_ = vala_expression_get_target_value (_tmp1939_);
			_tmp1941_ = _tmp1940_;
			_tmp1942_ = vala_get_array_size_cvalue (_tmp1941_);
			_tmp1943_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1936_, _tmp1942_, _tmp1943_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1945_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1946_ = _tmp1945_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1946_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1947_;
		ValaDataType* _tmp1948_;
		_tmp1947_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1948_ = _tmp1947_;
		_tmp1944_ = !vala_data_type_is_disposable (_tmp1948_);
	} else {
		_tmp1944_ = FALSE;
	}
	if (_tmp1944_) {
		gboolean _tmp1949_ = FALSE;
		ValaCCodeExpression* _tmp1950_;
		_tmp1950_ = ccall_expr;
		if (_tmp1950_ != NULL) {
			_tmp1949_ = !return_result_via_out_param;
		} else {
			_tmp1949_ = FALSE;
		}
		if (_tmp1949_) {
			ValaCCodeFunction* _tmp1951_;
			ValaCCodeFunction* _tmp1952_;
			ValaCCodeExpression* _tmp1953_;
			_tmp1951_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1952_ = _tmp1951_;
			_tmp1953_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1952_, _tmp1953_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1954_;
		ValaDataType* _tmp1955_;
		ValaDataType* _tmp1956_;
		gboolean _tmp1957_ = FALSE;
		ValaDataType* _tmp1958_;
		ValaDataType* _tmp1959_;
		gboolean _tmp2012_ = FALSE;
		ValaMethod* _tmp2013_;
		_tmp1954_ = itype;
		_tmp1955_ = vala_data_type_get_return_type (_tmp1954_);
		_tmp1956_ = _vala_code_node_ref0 (_tmp1955_);
		result_type = _tmp1956_;
		_tmp1958_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1959_ = _tmp1958_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1959_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1960_;
			ValaDataType* _tmp1961_;
			_tmp1960_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1961_ = _tmp1960_;
			_tmp1957_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1961_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1957_ = FALSE;
		}
		if (_tmp1957_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1962_;
			ValaDataType* _tmp1963_;
			ValaTypeParameter* _tmp1964_;
			ValaTypeParameter* _tmp1965_;
			ValaTypeParameter* _tmp1966_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1967_;
			ValaSymbol* _tmp1968_;
			ValaSymbol* _tmp1969_;
			ValaSymbol* _tmp1970_;
			ValaSymbol* _tmp1971_;
			ValaStruct* _tmp1972_;
			gboolean _tmp1973_ = FALSE;
			ValaTypeParameter* _tmp1974_;
			ValaSymbol* _tmp1975_;
			ValaSymbol* _tmp1976_;
			ValaTypeSymbol* _tmp1977_;
			gboolean _tmp1986_ = FALSE;
			gboolean _tmp1987_ = FALSE;
			ValaStruct* _tmp1988_;
			_tmp1962_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1963_ = _tmp1962_;
			_tmp1964_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1963_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1965_ = _tmp1964_;
			_tmp1966_ = _vala_code_node_ref0 (_tmp1965_);
			type_parameter = _tmp1966_;
			_tmp1967_ = type_parameter;
			_tmp1968_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1967_);
			_tmp1969_ = _tmp1968_;
			_tmp1970_ = vala_symbol_get_parent_symbol (_tmp1969_);
			_tmp1971_ = _tmp1970_;
			_tmp1972_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1971_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1971_) : NULL);
			st = _tmp1972_;
			_tmp1974_ = type_parameter;
			_tmp1975_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1974_);
			_tmp1976_ = _tmp1975_;
			_tmp1977_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1976_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1977_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1973_ = TRUE;
			} else {
				gboolean _tmp1978_ = FALSE;
				ValaStruct* _tmp1979_;
				_tmp1979_ = st;
				if (_tmp1979_ != NULL) {
					ValaStruct* _tmp1980_;
					gchar* _tmp1981_;
					gchar* _tmp1982_;
					_tmp1980_ = st;
					_tmp1981_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1980_);
					_tmp1982_ = _tmp1981_;
					_tmp1978_ = g_strcmp0 (_tmp1982_, "va_list") == 0;
					_g_free0 (_tmp1982_);
				} else {
					_tmp1978_ = FALSE;
				}
				_tmp1973_ = _tmp1978_;
			}
			if (_tmp1973_) {
				ValaDataType* _tmp1983_;
				ValaDataType* _tmp1984_;
				ValaDataType* _tmp1985_;
				_tmp1983_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1984_ = _tmp1983_;
				_tmp1985_ = _vala_code_node_ref0 (_tmp1984_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1985_;
			}
			_tmp1988_ = st;
			if (_tmp1988_ != NULL) {
				ValaStruct* _tmp1989_;
				gchar* _tmp1990_;
				gchar* _tmp1991_;
				_tmp1989_ = st;
				_tmp1990_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1989_);
				_tmp1991_ = _tmp1990_;
				_tmp1987_ = g_strcmp0 (_tmp1991_, "va_list") == 0;
				_g_free0 (_tmp1991_);
			} else {
				_tmp1987_ = FALSE;
			}
			if (_tmp1987_) {
				ValaMemberAccess* _tmp1992_;
				const gchar* _tmp1993_;
				const gchar* _tmp1994_;
				_tmp1992_ = ma;
				_tmp1993_ = vala_member_access_get_member_name (_tmp1992_);
				_tmp1994_ = _tmp1993_;
				_tmp1986_ = g_strcmp0 (_tmp1994_, "arg") == 0;
			} else {
				_tmp1986_ = FALSE;
			}
			if (_tmp1986_) {
				gboolean _tmp1995_ = FALSE;
				ValaDataType* _tmp1996_;
				_tmp1996_ = result_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1996_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDataType* _tmp1997_;
					ValaDelegate* _tmp1998_;
					ValaDelegate* _tmp1999_;
					gboolean _tmp2000_;
					gboolean _tmp2001_;
					_tmp1997_ = result_type;
					_tmp1998_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1997_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp1999_ = _tmp1998_;
					_tmp2000_ = vala_delegate_get_has_target (_tmp1999_);
					_tmp2001_ = _tmp2000_;
					_tmp1995_ = _tmp2001_;
				} else {
					_tmp1995_ = FALSE;
				}
				if (_tmp1995_) {
					ValaGLibValue* arg_value = NULL;
					ValaTargetValue* _tmp2002_;
					ValaTargetValue* _tmp2003_;
					ValaGLibValue* _tmp2004_;
					ValaCCodeExpression* _tmp2005_;
					ValaGLibValue* _tmp2008_;
					ValaCCodeExpression* _tmp2009_;
					vala_set_cvalue ((ValaExpression*) expr, NULL);
					_tmp2002_ = vala_expression_get_target_value ((ValaExpression*) expr);
					_tmp2003_ = _tmp2002_;
					arg_value = G_TYPE_CHECK_INSTANCE_CAST (_tmp2003_, VALA_TYPE_GLIB_VALUE, ValaGLibValue);
					_tmp2004_ = arg_value;
					_tmp2005_ = _tmp2004_->delegate_target_cvalue;
					if (_tmp2005_ == NULL) {
						ValaGLibValue* _tmp2006_;
						ValaCCodeConstant* _tmp2007_;
						_tmp2006_ = arg_value;
						_tmp2007_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2006_->delegate_target_cvalue);
						_tmp2006_->delegate_target_cvalue = (ValaCCodeExpression*) _tmp2007_;
					}
					_tmp2008_ = arg_value;
					_tmp2009_ = _tmp2008_->delegate_target_destroy_notify_cvalue;
					if (_tmp2009_ == NULL) {
						ValaGLibValue* _tmp2010_;
						ValaCCodeConstant* _tmp2011_;
						_tmp2010_ = arg_value;
						_tmp2011_ = vala_ccode_constant_new ("NULL");
						_vala_ccode_node_unref0 (_tmp2010_->delegate_target_destroy_notify_cvalue);
						_tmp2010_->delegate_target_destroy_notify_cvalue = (ValaCCodeExpression*) _tmp2011_;
					}
				}
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp2013_ = m;
		if (_tmp2013_ != NULL) {
			ValaMethod* _tmp2014_;
			_tmp2014_ = m;
			_tmp2012_ = vala_method_get_format_arg_index (_tmp2014_) >= 0;
		} else {
			_tmp2012_ = FALSE;
		}
		if (_tmp2012_) {
			ValaCCodeExpression* _tmp2015_;
			_tmp2015_ = ccall_expr;
			vala_set_cvalue ((ValaExpression*) expr, _tmp2015_);
		} else {
			gboolean _tmp2016_ = FALSE;
			ValaMethod* _tmp2017_;
			_tmp2017_ = m;
			if (_tmp2017_ != NULL) {
				ValaMethod* _tmp2018_;
				_tmp2018_ = m;
				_tmp2016_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp2018_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp2016_ = FALSE;
			}
			if (_tmp2016_) {
				ValaCCodeExpression* _tmp2019_;
				_tmp2019_ = ccall_expr;
				vala_set_cvalue ((ValaExpression*) expr, _tmp2019_);
			} else {
				gboolean _tmp2020_ = FALSE;
				gboolean _tmp2021_ = FALSE;
				if (!return_result_via_out_param) {
					_tmp2021_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp2021_ = FALSE;
				}
				if (_tmp2021_) {
					gboolean _tmp2022_ = FALSE;
					ValaDataType* _tmp2023_;
					_tmp2023_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2023_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2024_;
						_tmp2024_ = result_type;
						_tmp2022_ = !vala_data_type_is_disposable (_tmp2024_);
					} else {
						_tmp2022_ = FALSE;
					}
					_tmp2020_ = _tmp2022_;
				} else {
					_tmp2020_ = FALSE;
				}
				if (_tmp2020_) {
					ValaCCodeExpression* _tmp2025_;
					_tmp2025_ = ccall_expr;
					vala_set_cvalue ((ValaExpression*) expr, _tmp2025_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2026_;
						ValaDataType* _tmp2027_;
						gboolean _tmp2028_;
						gboolean _tmp2029_;
						ValaLocalVariable* _tmp2030_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2031_;
						const gchar* _tmp2032_;
						const gchar* _tmp2033_;
						ValaCCodeExpression* _tmp2034_;
						ValaLocalVariable* _tmp2035_;
						ValaCCodeFunction* _tmp2036_;
						ValaCCodeFunction* _tmp2037_;
						ValaCCodeExpression* _tmp2038_;
						ValaCCodeExpression* _tmp2039_;
						ValaCCodeExpression* _tmp2040_;
						ValaTargetValue* _tmp2041_;
						ValaTargetValue* _tmp2042_;
						_tmp2026_ = result_type;
						_tmp2027_ = result_type;
						_tmp2028_ = vala_data_type_get_value_owned (_tmp2027_);
						_tmp2029_ = _tmp2028_;
						_tmp2030_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2026_, _tmp2029_, NULL, FALSE);
						temp_var = _tmp2030_;
						_tmp2031_ = temp_var;
						_tmp2032_ = vala_symbol_get_name ((ValaSymbol*) _tmp2031_);
						_tmp2033_ = _tmp2032_;
						_tmp2034_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2033_);
						temp_ref = _tmp2034_;
						_tmp2035_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2035_, FALSE);
						_tmp2036_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2037_ = _tmp2036_;
						_tmp2038_ = temp_ref;
						_tmp2039_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2037_, _tmp2038_, _tmp2039_);
						_tmp2040_ = temp_ref;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2040_);
						_tmp2041_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2042_ = _tmp2041_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2042_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2043_;
						ValaTargetValue* _tmp2044_;
						ValaTargetValue* _tmp2045_;
						_tmp2043_ = ccall_expr;
						vala_set_cvalue ((ValaExpression*) expr, _tmp2043_);
						_tmp2044_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2045_ = _tmp2044_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2045_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2046_ = params;
	_tmp2047_ = vala_iterable_iterator ((ValaIterable*) _tmp2046_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2047_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2048_;
		ValaList* _tmp2049_;
		gint _arg_size = 0;
		ValaList* _tmp2050_;
		gint _tmp2051_;
		gint _tmp2052_;
		gint _arg_index = 0;
		_tmp2048_ = vala_method_call_get_argument_list (expr);
		_tmp2049_ = _vala_iterable_ref0 (_tmp2048_);
		_arg_list = _tmp2049_;
		_tmp2050_ = _arg_list;
		_tmp2051_ = vala_collection_get_size ((ValaCollection*) _tmp2050_);
		_tmp2052_ = _tmp2051_;
		_arg_size = _tmp2052_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp2053_;
			gpointer _tmp2054_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2055_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2058_;
			ValaUnaryExpression* _tmp2059_;
			gboolean _tmp2060_ = FALSE;
			ValaUnaryExpression* _tmp2061_;
			gboolean _tmp2114_ = FALSE;
			ValaUnaryExpression* _tmp2115_;
			ValaUnaryExpression* _tmp2119_;
			ValaExpression* _tmp2120_;
			ValaExpression* _tmp2121_;
			ValaDataType* _tmp2122_;
			ValaDataType* _tmp2123_;
			gboolean _tmp2133_ = FALSE;
			ValaMemberAccess* _tmp2134_;
			ValaSymbol* _tmp2135_;
			ValaSymbol* _tmp2136_;
			ValaUnaryExpression* _tmp2152_;
			ValaExpression* _tmp2153_;
			ValaExpression* _tmp2154_;
			ValaTargetValue* _tmp2155_;
			ValaTargetValue* _tmp2156_;
			ValaUnaryExpression* _tmp2157_;
			ValaTargetValue* _tmp2158_;
			ValaTargetValue* _tmp2159_;
			ValaUnaryExpression* _tmp2160_;
			ValaExpression* _tmp2161_;
			ValaExpression* _tmp2162_;
			ValaDataType* _tmp2163_;
			ValaDataType* _tmp2164_;
			ValaExpression* _tmp2165_;
			ValaTargetValue* _tmp2166_;
			ValaTargetValue* _tmp2167_;
			ValaSourceReference* _tmp2168_;
			ValaSourceReference* _tmp2169_;
			gboolean _tmp2170_ = FALSE;
			ValaParameter* _tmp2171_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp2053_ = _arg_list;
			_tmp2054_ = vala_list_get (_tmp2053_, _arg_index);
			arg = (ValaExpression*) _tmp2054_;
			param = NULL;
			_tmp2055_ = params_it;
			if (vala_iterator_next (_tmp2055_)) {
				ValaIterator* _tmp2056_;
				gpointer _tmp2057_;
				_tmp2056_ = params_it;
				_tmp2057_ = vala_iterator_get (_tmp2056_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2057_;
			}
			_tmp2058_ = arg;
			_tmp2059_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2058_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2058_) : NULL);
			unary = _tmp2059_;
			_tmp2061_ = unary;
			if (_tmp2061_ != NULL) {
				ValaUnaryExpression* _tmp2062_;
				ValaUnaryOperator _tmp2063_;
				ValaUnaryOperator _tmp2064_;
				_tmp2062_ = unary;
				_tmp2063_ = vala_unary_expression_get_operator (_tmp2062_);
				_tmp2064_ = _tmp2063_;
				_tmp2060_ = _tmp2064_ == VALA_UNARY_OPERATOR_REF;
			} else {
				_tmp2060_ = FALSE;
			}
			if (_tmp2060_) {
				gboolean _tmp2065_ = FALSE;
				gboolean _tmp2066_ = FALSE;
				gboolean _tmp2067_ = FALSE;
				ValaParameter* _tmp2068_;
				_tmp2068_ = param;
				if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp2068_)) {
					ValaParameter* _tmp2069_;
					ValaDataType* _tmp2070_;
					ValaDataType* _tmp2071_;
					_tmp2069_ = param;
					_tmp2070_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2069_);
					_tmp2071_ = _tmp2070_;
					_tmp2067_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2071_, VALA_TYPE_ARRAY_TYPE);
				} else {
					_tmp2067_ = FALSE;
				}
				if (_tmp2067_) {
					ValaParameter* _tmp2072_;
					ValaDataType* _tmp2073_;
					ValaDataType* _tmp2074_;
					gboolean _tmp2075_;
					gboolean _tmp2076_;
					_tmp2072_ = param;
					_tmp2073_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2072_);
					_tmp2074_ = _tmp2073_;
					_tmp2075_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp2074_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2076_ = _tmp2075_;
					_tmp2066_ = !_tmp2076_;
				} else {
					_tmp2066_ = FALSE;
				}
				if (_tmp2066_) {
					ValaParameter* _tmp2077_;
					ValaDataType* _tmp2078_;
					ValaDataType* _tmp2079_;
					gint _tmp2080_;
					gint _tmp2081_;
					_tmp2077_ = param;
					_tmp2078_ = vala_variable_get_variable_type ((ValaVariable*) _tmp2077_);
					_tmp2079_ = _tmp2078_;
					_tmp2080_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp2079_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
					_tmp2081_ = _tmp2080_;
					_tmp2065_ = _tmp2081_ == 1;
				} else {
					_tmp2065_ = FALSE;
				}
				if (_tmp2065_) {
					ValaSymbol* array_var = NULL;
					ValaUnaryExpression* _tmp2082_;
					ValaExpression* _tmp2083_;
					ValaExpression* _tmp2084_;
					ValaSymbol* _tmp2085_;
					ValaSymbol* _tmp2086_;
					ValaLocalVariable* array_local = NULL;
					ValaSymbol* _tmp2087_;
					gboolean _tmp2088_ = FALSE;
					gboolean _tmp2089_ = FALSE;
					ValaSymbol* _tmp2090_;
					_tmp2082_ = unary;
					_tmp2083_ = vala_unary_expression_get_inner (_tmp2082_);
					_tmp2084_ = _tmp2083_;
					_tmp2085_ = vala_expression_get_symbol_reference (_tmp2084_);
					_tmp2086_ = _tmp2085_;
					array_var = _tmp2086_;
					_tmp2087_ = array_var;
					array_local = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2087_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp2087_) : NULL;
					_tmp2090_ = array_var;
					if (_tmp2090_ != NULL) {
						ValaSymbol* _tmp2091_;
						_tmp2091_ = array_var;
						_tmp2089_ = vala_symbol_is_internal_symbol (_tmp2091_);
					} else {
						_tmp2089_ = FALSE;
					}
					if (_tmp2089_) {
						gboolean _tmp2092_ = FALSE;
						gboolean _tmp2093_ = FALSE;
						ValaLocalVariable* _tmp2094_;
						_tmp2094_ = array_local;
						if (_tmp2094_ != NULL) {
							ValaLocalVariable* _tmp2095_;
							gboolean _tmp2096_;
							gboolean _tmp2097_;
							_tmp2095_ = array_local;
							_tmp2096_ = vala_local_variable_get_captured (_tmp2095_);
							_tmp2097_ = _tmp2096_;
							_tmp2093_ = !_tmp2097_;
						} else {
							_tmp2093_ = FALSE;
						}
						if (_tmp2093_) {
							_tmp2092_ = TRUE;
						} else {
							ValaSymbol* _tmp2098_;
							_tmp2098_ = array_var;
							_tmp2092_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2098_, VALA_TYPE_FIELD);
						}
						_tmp2088_ = _tmp2092_;
					} else {
						_tmp2088_ = FALSE;
					}
					if (_tmp2088_) {
						ValaCCodeFunction* _tmp2099_;
						ValaCCodeFunction* _tmp2100_;
						ValaUnaryExpression* _tmp2101_;
						ValaExpression* _tmp2102_;
						ValaExpression* _tmp2103_;
						ValaTargetValue* _tmp2104_;
						ValaTargetValue* _tmp2105_;
						ValaCCodeExpression* _tmp2106_;
						ValaUnaryExpression* _tmp2107_;
						ValaExpression* _tmp2108_;
						ValaExpression* _tmp2109_;
						ValaTargetValue* _tmp2110_;
						ValaTargetValue* _tmp2111_;
						ValaCCodeExpression* _tmp2112_;
						ValaCCodeExpression* _tmp2113_;
						_tmp2099_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2100_ = _tmp2099_;
						_tmp2101_ = unary;
						_tmp2102_ = vala_unary_expression_get_inner (_tmp2101_);
						_tmp2103_ = _tmp2102_;
						_tmp2104_ = vala_expression_get_target_value (_tmp2103_);
						_tmp2105_ = _tmp2104_;
						_tmp2106_ = vala_get_array_size_cvalue (_tmp2105_);
						_tmp2107_ = unary;
						_tmp2108_ = vala_unary_expression_get_inner (_tmp2107_);
						_tmp2109_ = _tmp2108_;
						_tmp2110_ = vala_expression_get_target_value (_tmp2109_);
						_tmp2111_ = _tmp2110_;
						_tmp2112_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2111_, 1);
						_tmp2113_ = _tmp2112_;
						vala_ccode_function_add_assignment (_tmp2100_, _tmp2106_, _tmp2113_);
						_vala_ccode_node_unref0 (_tmp2113_);
					}
				}
			}
			_tmp2115_ = unary;
			if (_tmp2115_ == NULL) {
				_tmp2114_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2116_;
				ValaUnaryOperator _tmp2117_;
				ValaUnaryOperator _tmp2118_;
				_tmp2116_ = unary;
				_tmp2117_ = vala_unary_expression_get_operator (_tmp2116_);
				_tmp2118_ = _tmp2117_;
				_tmp2114_ = _tmp2118_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2114_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2119_ = unary;
			_tmp2120_ = vala_unary_expression_get_inner (_tmp2119_);
			_tmp2121_ = _tmp2120_;
			_tmp2122_ = vala_expression_get_value_type (_tmp2121_);
			_tmp2123_ = _tmp2122_;
			if (vala_ccode_base_module_requires_destroy (_tmp2123_)) {
				ValaCCodeFunction* _tmp2124_;
				ValaCCodeFunction* _tmp2125_;
				ValaUnaryExpression* _tmp2126_;
				ValaExpression* _tmp2127_;
				ValaExpression* _tmp2128_;
				ValaTargetValue* _tmp2129_;
				ValaTargetValue* _tmp2130_;
				ValaCCodeExpression* _tmp2131_;
				ValaCCodeExpression* _tmp2132_;
				_tmp2124_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2125_ = _tmp2124_;
				_tmp2126_ = unary;
				_tmp2127_ = vala_unary_expression_get_inner (_tmp2126_);
				_tmp2128_ = _tmp2127_;
				_tmp2129_ = vala_expression_get_target_value (_tmp2128_);
				_tmp2130_ = _tmp2129_;
				_tmp2131_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2130_, FALSE);
				_tmp2132_ = _tmp2131_;
				vala_ccode_function_add_expression (_tmp2125_, _tmp2132_);
				_vala_ccode_node_unref0 (_tmp2132_);
			}
			_tmp2134_ = ma;
			_tmp2135_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp2134_);
			_tmp2136_ = _tmp2135_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2136_, VALA_TYPE_DYNAMIC_METHOD)) {
				ValaUnaryExpression* _tmp2137_;
				ValaTargetValue* _tmp2138_;
				ValaTargetValue* _tmp2139_;
				ValaDataType* _tmp2140_;
				ValaDataType* _tmp2141_;
				_tmp2137_ = unary;
				_tmp2138_ = vala_expression_get_target_value ((ValaExpression*) _tmp2137_);
				_tmp2139_ = _tmp2138_;
				_tmp2140_ = vala_target_value_get_value_type (_tmp2139_);
				_tmp2141_ = _tmp2140_;
				_tmp2133_ = _tmp2141_ == NULL;
			} else {
				_tmp2133_ = FALSE;
			}
			if (_tmp2133_) {
				ValaUnaryExpression* _tmp2142_;
				ValaTargetValue* _tmp2143_;
				ValaTargetValue* _tmp2144_;
				ValaUnaryExpression* _tmp2145_;
				ValaExpression* _tmp2146_;
				ValaExpression* _tmp2147_;
				ValaDataType* _tmp2148_;
				ValaDataType* _tmp2149_;
				ValaDataType* _tmp2150_;
				ValaDataType* _tmp2151_;
				_tmp2142_ = unary;
				_tmp2143_ = vala_expression_get_target_value ((ValaExpression*) _tmp2142_);
				_tmp2144_ = _tmp2143_;
				_tmp2145_ = unary;
				_tmp2146_ = vala_unary_expression_get_inner (_tmp2145_);
				_tmp2147_ = _tmp2146_;
				_tmp2148_ = vala_expression_get_value_type (_tmp2147_);
				_tmp2149_ = _tmp2148_;
				_tmp2150_ = vala_data_type_copy (_tmp2149_);
				_tmp2151_ = _tmp2150_;
				vala_target_value_set_value_type (_tmp2144_, _tmp2151_);
				_vala_code_node_unref0 (_tmp2151_);
			}
			_tmp2152_ = unary;
			_tmp2153_ = vala_unary_expression_get_inner (_tmp2152_);
			_tmp2154_ = _tmp2153_;
			_tmp2155_ = vala_expression_get_target_value (_tmp2154_);
			_tmp2156_ = _tmp2155_;
			_tmp2157_ = unary;
			_tmp2158_ = vala_expression_get_target_value ((ValaExpression*) _tmp2157_);
			_tmp2159_ = _tmp2158_;
			_tmp2160_ = unary;
			_tmp2161_ = vala_unary_expression_get_inner (_tmp2160_);
			_tmp2162_ = _tmp2161_;
			_tmp2163_ = vala_expression_get_value_type (_tmp2162_);
			_tmp2164_ = _tmp2163_;
			_tmp2165_ = arg;
			_tmp2166_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2159_, _tmp2164_, (ValaCodeNode*) _tmp2165_);
			_tmp2167_ = _tmp2166_;
			_tmp2168_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2169_ = _tmp2168_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2156_, _tmp2167_, _tmp2169_);
			_vala_target_value_unref0 (_tmp2167_);
			_tmp2171_ = param;
			if (_tmp2171_ != NULL) {
				ValaParameter* _tmp2172_;
				_tmp2172_ = param;
				_tmp2170_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2172_);
			} else {
				_tmp2170_ = FALSE;
			}
			if (_tmp2170_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2173_;
				ValaCCodeIdentifier* _tmp2174_;
				ValaCCodeFunctionCall* _tmp2175_;
				ValaCCodeFunctionCall* _tmp2176_;
				ValaCCodeFunctionCall* _tmp2177_;
				ValaUnaryExpression* _tmp2178_;
				ValaExpression* _tmp2179_;
				ValaExpression* _tmp2180_;
				ValaTargetValue* _tmp2181_;
				ValaTargetValue* _tmp2182_;
				ValaCCodeExpression* _tmp2183_;
				ValaCCodeFunction* _tmp2184_;
				ValaCCodeFunction* _tmp2185_;
				ValaUnaryExpression* _tmp2186_;
				ValaExpression* _tmp2187_;
				ValaExpression* _tmp2188_;
				ValaTargetValue* _tmp2189_;
				ValaTargetValue* _tmp2190_;
				ValaCCodeExpression* _tmp2191_;
				ValaCCodeExpression* _tmp2192_;
				ValaCCodeFunctionCall* _tmp2193_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2173_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2174_ = _tmp2173_;
				_tmp2175_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2174_);
				_tmp2176_ = _tmp2175_;
				_vala_ccode_node_unref0 (_tmp2174_);
				len_call = _tmp2176_;
				_tmp2177_ = len_call;
				_tmp2178_ = unary;
				_tmp2179_ = vala_unary_expression_get_inner (_tmp2178_);
				_tmp2180_ = _tmp2179_;
				_tmp2181_ = vala_expression_get_target_value (_tmp2180_);
				_tmp2182_ = _tmp2181_;
				_tmp2183_ = vala_get_cvalue_ (_tmp2182_);
				vala_ccode_function_call_add_argument (_tmp2177_, _tmp2183_);
				_tmp2184_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2185_ = _tmp2184_;
				_tmp2186_ = unary;
				_tmp2187_ = vala_unary_expression_get_inner (_tmp2186_);
				_tmp2188_ = _tmp2187_;
				_tmp2189_ = vala_expression_get_target_value (_tmp2188_);
				_tmp2190_ = _tmp2189_;
				_tmp2191_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2190_, 1);
				_tmp2192_ = _tmp2191_;
				_tmp2193_ = len_call;
				vala_ccode_function_add_assignment (_tmp2185_, _tmp2192_, (ValaCCodeExpression*) _tmp2193_);
				_vala_ccode_node_unref0 (_tmp2192_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2196_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2196_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2197_;
		ValaSymbol* _tmp2198_;
		ValaSymbol* _tmp2199_;
		_tmp2197_ = m;
		_tmp2198_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2197_);
		_tmp2199_ = _tmp2198_;
		_tmp2195_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2199_, VALA_TYPE_CLASS);
	} else {
		_tmp2195_ = FALSE;
	}
	if (_tmp2195_) {
		gboolean _tmp2200_ = FALSE;
		gboolean _tmp2201_ = FALSE;
		ValaClass* _tmp2202_;
		ValaClass* _tmp2203_;
		gboolean _tmp2204_;
		gboolean _tmp2205_;
		_tmp2202_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2203_ = _tmp2202_;
		_tmp2204_ = vala_class_get_is_compact (_tmp2203_);
		_tmp2205_ = _tmp2204_;
		if (_tmp2205_) {
			ValaClass* _tmp2206_;
			ValaClass* _tmp2207_;
			ValaClass* _tmp2208_;
			ValaClass* _tmp2209_;
			_tmp2206_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2207_ = _tmp2206_;
			_tmp2208_ = vala_class_get_base_class (_tmp2207_);
			_tmp2209_ = _tmp2208_;
			_tmp2201_ = _tmp2209_ != NULL;
		} else {
			_tmp2201_ = FALSE;
		}
		if (_tmp2201_) {
			_tmp2200_ = TRUE;
		} else {
			ValaClass* _tmp2210_;
			ValaClass* _tmp2211_;
			ValaClass* _tmp2212_;
			ValaClass* _tmp2213_;
			ValaClass* _tmp2214_;
			_tmp2210_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2211_ = _tmp2210_;
			_tmp2212_ = vala_class_get_base_class (_tmp2211_);
			_tmp2213_ = _tmp2212_;
			_tmp2214_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2200_ = _tmp2213_ == _tmp2214_;
		}
		_tmp2194_ = _tmp2200_;
	} else {
		_tmp2194_ = FALSE;
	}
	if (_tmp2194_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2215_;
		ValaClass* _tmp2216_;
		gchar* _tmp2217_;
		gchar* _tmp2218_;
		gchar* _tmp2219_;
		gchar* _tmp2220_;
		ValaCCodeIdentifier* _tmp2221_;
		ValaCCodeIdentifier* _tmp2222_;
		ValaCCodeFunctionCall* _tmp2223_;
		ValaCCodeFunctionCall* _tmp2224_;
		ValaCCodeFunctionCall* _tmp2225_;
		ValaCCodeExpression* _tmp2226_;
		ValaCCodeExpression* _tmp2227_;
		ValaClass* _tmp2228_;
		ValaClass* _tmp2229_;
		gboolean _tmp2230_;
		gboolean _tmp2231_;
		ValaCCodeFunction* _tmp2235_;
		ValaCCodeFunction* _tmp2236_;
		ValaCCodeFunctionCall* _tmp2237_;
		_tmp2215_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2216_ = _tmp2215_;
		_tmp2217_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2216_, NULL);
		_tmp2218_ = _tmp2217_;
		_tmp2219_ = g_strdup_printf ("%s_instance_init", _tmp2218_);
		_tmp2220_ = _tmp2219_;
		_tmp2221_ = vala_ccode_identifier_new (_tmp2220_);
		_tmp2222_ = _tmp2221_;
		_tmp2223_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2222_);
		_tmp2224_ = _tmp2223_;
		_vala_ccode_node_unref0 (_tmp2222_);
		_g_free0 (_tmp2220_);
		_g_free0 (_tmp2218_);
		cinitcall = _tmp2224_;
		_tmp2225_ = cinitcall;
		_tmp2226_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2227_ = _tmp2226_;
		vala_ccode_function_call_add_argument (_tmp2225_, _tmp2227_);
		_vala_ccode_node_unref0 (_tmp2227_);
		_tmp2228_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2229_ = _tmp2228_;
		_tmp2230_ = vala_class_get_is_compact (_tmp2229_);
		_tmp2231_ = _tmp2230_;
		if (!_tmp2231_) {
			ValaCCodeFunctionCall* _tmp2232_;
			ValaCCodeConstant* _tmp2233_;
			ValaCCodeConstant* _tmp2234_;
			_tmp2232_ = cinitcall;
			_tmp2233_ = vala_ccode_constant_new ("NULL");
			_tmp2234_ = _tmp2233_;
			vala_ccode_function_call_add_argument (_tmp2232_, (ValaCCodeExpression*) _tmp2234_);
			_vala_ccode_node_unref0 (_tmp2234_);
		}
		_tmp2235_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2236_ = _tmp2235_;
		_tmp2237_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2236_, (ValaCCodeExpression*) _tmp2237_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_to_string_function (ValaCCodeMethodCallModule* self,
                                                                ValaEnum* en)
{
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp45_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeConstant* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeFile* _tmp51_;
	ValaCCodeFunction* _tmp52_;
	ValaCCodeFile* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _enum_value_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_enum_value_list = _tmp21_;
		_tmp22_ = _enum_value_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_enum_value_size = _tmp24_;
		_enum_value_index = -1;
		while (TRUE) {
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp25_;
			gpointer _tmp26_;
			ValaCCodeFunction* _tmp27_;
			ValaCCodeFunction* _tmp28_;
			ValaEnumValue* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeIdentifier* _tmp33_;
			ValaCCodeFunction* _tmp34_;
			ValaCCodeFunction* _tmp35_;
			ValaEnumValue* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			ValaCCodeConstant* _tmp43_;
			ValaCCodeConstant* _tmp44_;
			_enum_value_index = _enum_value_index + 1;
			if (!(_enum_value_index < _enum_value_size)) {
				break;
			}
			_tmp25_ = _enum_value_list;
			_tmp26_ = vala_list_get (_tmp25_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp26_;
			_tmp27_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp28_ = _tmp27_;
			_tmp29_ = enum_value;
			_tmp30_ = vala_get_ccode_name ((ValaCodeNode*) _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_ccode_identifier_new (_tmp31_);
			_tmp33_ = _tmp32_;
			vala_ccode_function_add_case (_tmp28_, (ValaCCodeExpression*) _tmp33_);
			_vala_ccode_node_unref0 (_tmp33_);
			_g_free0 (_tmp31_);
			_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp35_ = _tmp34_;
			_tmp36_ = enum_value;
			_tmp37_ = vala_get_ccode_name ((ValaCodeNode*) _tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = g_strconcat ("\"", _tmp38_, NULL);
			_tmp40_ = _tmp39_;
			_tmp41_ = g_strconcat (_tmp40_, "\"", NULL);
			_tmp42_ = _tmp41_;
			_tmp43_ = vala_ccode_constant_new (_tmp42_);
			_tmp44_ = _tmp43_;
			vala_ccode_function_add_return (_tmp35_, (ValaCCodeExpression*) _tmp44_);
			_vala_ccode_node_unref0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			_g_free0 (_tmp38_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp45_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp46_ = _tmp45_;
	vala_ccode_function_close (_tmp46_);
	_tmp47_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_ccode_constant_new ("NULL");
	_tmp50_ = _tmp49_;
	vala_ccode_function_add_return (_tmp48_, (ValaCCodeExpression*) _tmp50_);
	_vala_ccode_node_unref0 (_tmp50_);
	_tmp51_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp52_ = function;
	vala_ccode_file_add_function_declaration (_tmp51_, _tmp52_);
	_tmp53_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp54_ = function;
	vala_ccode_file_add_function (_tmp53_, _tmp54_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp7_;
			gboolean _tmp8_ = FALSE;
			ValaUnaryExpression* _tmp9_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp5_ = _arg_list;
			_tmp6_ = vala_list_get (_tmp5_, _arg_index);
			arg = (ValaExpression*) _tmp6_;
			_tmp7_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp7_) : NULL;
			_tmp9_ = unary;
			if (_tmp9_ != NULL) {
				gboolean _tmp10_ = FALSE;
				ValaUnaryExpression* _tmp11_;
				ValaUnaryOperator _tmp12_;
				ValaUnaryOperator _tmp13_;
				_tmp11_ = unary;
				_tmp12_ = vala_unary_expression_get_operator (_tmp11_);
				_tmp13_ = _tmp12_;
				if (_tmp13_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp10_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp14_;
					ValaUnaryOperator _tmp15_;
					ValaUnaryOperator _tmp16_;
					_tmp14_ = unary;
					_tmp15_ = vala_unary_expression_get_operator (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp10_ = _tmp16_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp8_ = _tmp10_;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCodeContext* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaProfile _tmp39_;
	ValaProfile _tmp40_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp42_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	ValaCCodeFunctionCall* _tmp46_;
	ValaCCodeConstant* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeFunctionCall* _tmp49_;
	ValaCCodeConstant* _tmp50_;
	ValaCCodeConstant* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp54_;
	ValaCCodeFunctionCall* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeIdentifier* _tmp60_;
	ValaCCodeIdentifier* _tmp61_;
	ValaCCodeFunctionCall* _tmp62_;
	ValaCCodeConstant* _tmp63_;
	ValaCCodeConstant* _tmp64_;
	ValaCCodeBinaryExpression* _tmp65_;
	ValaCCodeBinaryExpression* _tmp66_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunctionCall* _tmp69_;
	ValaCCodeFunctionCall* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunction* _tmp74_;
	ValaCCodeFunction* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeFunctionCall* _tmp80_;
	ValaCCodeFunctionCall* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeIdentifier* _tmp83_;
	ValaCCodeFunction* _tmp84_;
	ValaCCodeFunction* _tmp85_;
	ValaCCodeIdentifier* _tmp86_;
	ValaCCodeIdentifier* _tmp87_;
	ValaCCodeFunctionCall* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeIdentifier* _tmp90_;
	ValaCCodeFunctionCall* _tmp91_;
	ValaCCodeFunctionCall* _tmp92_;
	ValaCCodeIdentifier* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunction* _tmp98_;
	ValaCCodeFunction* _tmp99_;
	ValaCCodeFunctionCall* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeIdentifier* _tmp102_;
	ValaCCodeFunctionCall* _tmp103_;
	ValaCCodeFunctionCall* _tmp104_;
	ValaCCodeIdentifier* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeFunctionCall* _tmp107_;
	ValaCCodeIdentifier* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeFunctionCall* _tmp110_;
	ValaCCodeIdentifier* _tmp111_;
	ValaCCodeIdentifier* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunction* _tmp116_;
	ValaCCodeFunction* _tmp117_;
	ValaCCodeFunctionCall* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeIdentifier* _tmp120_;
	ValaCCodeFunctionCall* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeIdentifier* _tmp123_;
	ValaCCodeIdentifier* _tmp124_;
	ValaCCodeFunction* _tmp125_;
	ValaCCodeFunction* _tmp126_;
	ValaCCodeFunctionCall* _tmp127_;
	ValaCCodeFunction* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeIdentifier* _tmp130_;
	ValaCCodeIdentifier* _tmp131_;
	ValaCCodeFile* _tmp132_;
	ValaCCodeFile* _tmp133_;
	ValaCCodeFunction* _tmp134_;
	ValaCCodeFile* _tmp135_;
	ValaCCodeFunction* _tmp136_;
	gchar* _tmp137_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_code_context_get_profile (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PROFILE_POSIX) {
		ValaCCodeFile* _tmp41_;
		_tmp41_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp41_, "stdio.h", FALSE);
	}
	_tmp42_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp43_);
	_tmp45_ = _tmp44_;
	_vala_ccode_node_unref0 (_tmp43_);
	vsnprintf = _tmp45_;
	_tmp46_ = vsnprintf;
	_tmp47_ = vala_ccode_constant_new ("NULL");
	_tmp48_ = _tmp47_;
	vala_ccode_function_call_add_argument (_tmp46_, (ValaCCodeExpression*) _tmp48_);
	_vala_ccode_node_unref0 (_tmp48_);
	_tmp49_ = vsnprintf;
	_tmp50_ = vala_ccode_constant_new ("0");
	_tmp51_ = _tmp50_;
	vala_ccode_function_call_add_argument (_tmp49_, (ValaCCodeExpression*) _tmp51_);
	_vala_ccode_node_unref0 (_tmp51_);
	_tmp52_ = vsnprintf;
	_tmp53_ = vala_ccode_identifier_new ("format");
	_tmp54_ = _tmp53_;
	vala_ccode_function_call_add_argument (_tmp52_, (ValaCCodeExpression*) _tmp54_);
	_vala_ccode_node_unref0 (_tmp54_);
	_tmp55_ = vsnprintf;
	_tmp56_ = vala_ccode_identifier_new ("ap");
	_tmp57_ = _tmp56_;
	vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp57_);
	_vala_ccode_node_unref0 (_tmp57_);
	_tmp58_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_identifier_new ("length");
	_tmp61_ = _tmp60_;
	_tmp62_ = vsnprintf;
	_tmp63_ = vala_ccode_constant_new ("1");
	_tmp64_ = _tmp63_;
	_tmp65_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp62_, (ValaCCodeExpression*) _tmp64_);
	_tmp66_ = _tmp65_;
	vala_ccode_function_add_assignment (_tmp59_, (ValaCCodeExpression*) _tmp61_, (ValaCCodeExpression*) _tmp66_);
	_vala_ccode_node_unref0 (_tmp66_);
	_vala_ccode_node_unref0 (_tmp64_);
	_vala_ccode_node_unref0 (_tmp61_);
	_tmp67_ = vala_ccode_identifier_new ("va_end");
	_tmp68_ = _tmp67_;
	_tmp69_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp68_);
	_tmp70_ = _tmp69_;
	_vala_ccode_node_unref0 (_tmp68_);
	va_end = _tmp70_;
	_tmp71_ = va_end;
	_tmp72_ = vala_ccode_identifier_new ("ap");
	_tmp73_ = _tmp72_;
	vala_ccode_function_call_add_argument (_tmp71_, (ValaCCodeExpression*) _tmp73_);
	_vala_ccode_node_unref0 (_tmp73_);
	_tmp74_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = va_end;
	vala_ccode_function_add_expression (_tmp75_, (ValaCCodeExpression*) _tmp76_);
	_tmp77_ = vala_ccode_identifier_new ("malloc");
	_tmp78_ = _tmp77_;
	_tmp79_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp78_);
	_tmp80_ = _tmp79_;
	_vala_ccode_node_unref0 (_tmp78_);
	malloc = _tmp80_;
	_tmp81_ = malloc;
	_tmp82_ = vala_ccode_identifier_new ("length");
	_tmp83_ = _tmp82_;
	vala_ccode_function_call_add_argument (_tmp81_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp83_);
	_tmp84_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_identifier_new ("result");
	_tmp87_ = _tmp86_;
	_tmp88_ = malloc;
	vala_ccode_function_add_assignment (_tmp85_, (ValaCCodeExpression*) _tmp87_, (ValaCCodeExpression*) _tmp88_);
	_vala_ccode_node_unref0 (_tmp87_);
	_tmp89_ = vala_ccode_identifier_new ("va_start");
	_tmp90_ = _tmp89_;
	_tmp91_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp90_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp91_;
	_vala_ccode_node_unref0 (_tmp90_);
	_tmp92_ = va_start;
	_tmp93_ = vala_ccode_identifier_new ("ap");
	_tmp94_ = _tmp93_;
	vala_ccode_function_call_add_argument (_tmp92_, (ValaCCodeExpression*) _tmp94_);
	_vala_ccode_node_unref0 (_tmp94_);
	_tmp95_ = va_start;
	_tmp96_ = vala_ccode_identifier_new ("format");
	_tmp97_ = _tmp96_;
	vala_ccode_function_call_add_argument (_tmp95_, (ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp98_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp99_ = _tmp98_;
	_tmp100_ = va_start;
	vala_ccode_function_add_expression (_tmp99_, (ValaCCodeExpression*) _tmp100_);
	_tmp101_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp102_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp103_;
	_vala_ccode_node_unref0 (_tmp102_);
	_tmp104_ = vsnprintf;
	_tmp105_ = vala_ccode_identifier_new ("result");
	_tmp106_ = _tmp105_;
	vala_ccode_function_call_add_argument (_tmp104_, (ValaCCodeExpression*) _tmp106_);
	_vala_ccode_node_unref0 (_tmp106_);
	_tmp107_ = vsnprintf;
	_tmp108_ = vala_ccode_identifier_new ("length");
	_tmp109_ = _tmp108_;
	vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp109_);
	_vala_ccode_node_unref0 (_tmp109_);
	_tmp110_ = vsnprintf;
	_tmp111_ = vala_ccode_identifier_new ("format");
	_tmp112_ = _tmp111_;
	vala_ccode_function_call_add_argument (_tmp110_, (ValaCCodeExpression*) _tmp112_);
	_vala_ccode_node_unref0 (_tmp112_);
	_tmp113_ = vsnprintf;
	_tmp114_ = vala_ccode_identifier_new ("ap");
	_tmp115_ = _tmp114_;
	vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp116_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp117_, (ValaCCodeExpression*) _tmp118_);
	_tmp119_ = vala_ccode_identifier_new ("va_end");
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp120_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp121_;
	_vala_ccode_node_unref0 (_tmp120_);
	_tmp122_ = va_end;
	_tmp123_ = vala_ccode_identifier_new ("ap");
	_tmp124_ = _tmp123_;
	vala_ccode_function_call_add_argument (_tmp122_, (ValaCCodeExpression*) _tmp124_);
	_vala_ccode_node_unref0 (_tmp124_);
	_tmp125_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp126_ = _tmp125_;
	_tmp127_ = va_end;
	vala_ccode_function_add_expression (_tmp126_, (ValaCCodeExpression*) _tmp127_);
	_tmp128_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp129_ = _tmp128_;
	_tmp130_ = vala_ccode_identifier_new ("result");
	_tmp131_ = _tmp130_;
	vala_ccode_function_add_return (_tmp129_, (ValaCCodeExpression*) _tmp131_);
	_vala_ccode_node_unref0 (_tmp131_);
	_tmp132_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp132_, "stdarg.h", FALSE);
	_tmp133_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp134_ = function;
	vala_ccode_file_add_function_declaration (_tmp133_, _tmp134_);
	_tmp135_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp136_ = function;
	vala_ccode_file_add_function (_tmp135_, _tmp136_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp137_ = g_strdup ("string_printf");
	result = _tmp137_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass,
                                          gpointer klass_data)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self,
                                             gpointer klass)
{
}

static GType
vala_ccode_method_call_module_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
	GType vala_ccode_method_call_module_type_id;
	vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	return vala_ccode_method_call_module_type_id;
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = vala_ccode_method_call_module_get_type_once ();
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

