/*
 *      vdr-plugin-vnsi - KODI server plugin for VDR
 *
 *      Copyright (C) 2005-2012 Team XBMC
 *      Copyright (C) 2015 Team KODI
 *
 *      http://kodi.tv
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with KODI; see the file COPYING.  If not, see
 *  <http://www.gnu.org/licenses/>.
 *
 */

#ifndef VNSI_DEMUXER_MPEGVIDEO_H
#define VNSI_DEMUXER_MPEGVIDEO_H

#include <deque>
#include "parser.h"

class cBitstream;

// --- cParserMPEG2Video -------------------------------------------------

class cParserMPEG2Video : public cParser
{
private:
  uint32_t        m_StartCode;
  bool            m_NeedIFrame;
  bool            m_NeedSPS;
  int64_t         m_FrameDuration;
  int             m_vbvDelay;       /* -1 if CBR */
  int             m_vbvSize;        /* Video buffer size (in bytes) */
  int             m_Width;
  int             m_Height;
  float           m_Dar;
  int64_t         m_DTS;
  int64_t         m_PTS;
  int64_t         m_AuDTS, m_AuPTS, m_AuPrevDTS;
  int             m_TemporalReference;
  int             m_TrLastTime;
  int             m_PicNumber;
  int             m_FpsScale;

  int Parse_MPEG2Video(uint32_t startcode, int buf_ptr, bool &complete);
  bool Parse_MPEG2Video_SeqStart(uint8_t *buf);
  bool Parse_MPEG2Video_PicStart(uint8_t *buf);

public:
  cParserMPEG2Video(int pID, cTSStream *stream, sPtsWrap *ptsWrap, bool observePtsWraps);
  virtual ~cParserMPEG2Video();

  virtual void Parse(sStreamPacket *pkt, sStreamPacket *pkt_side_data);
  virtual void Reset();
};

#endif // VNSI_DEMUXER_MPEGVIDEO_H
