/*---------------------------------------------------------------------------*\

    FILE....: VPBERR.H
    TYPE....: C++ Header
    AUTHOR..: Voicetronix
    DATE....: 5/6/98

    Error codes for API functions.


         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2006 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
         MA  02110-1301  USA

\*---------------------------------------------------------------------------*/

#ifndef __VPBERR__
#define __VPBERR__

// General errors

//#define VPBAPI_CANT_ALLOCATE_MEMORY				1000
#define VPBAPI_INVALID_HANDLE					1001
#define	VPBAPI_BAD_OBJECT_ID					1002
#define	VPBAPI_BAD_TONED_EVENT					1003
#define	VPBAPI_DEVICE_BUSY					1004

// vpb_seterrormode

#define	VPBAPI_SETERRORMODE_MODE_INVALID			1030

// play functions 

#define	VPBAPI_PLAY_MULAW_NOT_SUPPORTED				1051
#define	VPBAPI_PLAY_NOT_SUPPORTED				1052
#define	VPBAPI_PLAY_OFFSET_TOO_BIG				1053
#define	VPBAPI_PLAY_BAD_LENGTH					1054
#define	VPBAPI_DEVICE_NOT_PREPARED				1055
#define	VPBAPI_PLAY_OKIADPCM_NOT_SUPPORTED			1056
#define	VPBAPI_GAIN_OUT_OF_RANGE				1057
#define	VPBAPI_PLAY_CANT_OPEN_VOXFILE				1058

// record functions

#define	VPBAPI_REC_MULAW_NOT_SUPPORTED				1081
#define	VPBAPI_REC_NOT_SUPPORTED				1082
#define	VPBAPI_REC_OFFSET_TOO_BIG				1083
#define	VPBAPI_REC_BAD_LENGTH					1084
#define	PLAYREC_DISK_FULL					1085
#define	VPBAPI_REC_OKIADPCM_NOT_SUPPORTED			1086
#define	VPBAPI_REC_CANT_OPEN_FILE				1087
#define	VPBAPI_RECORD_CANT_OPEN_VOXFILE				1088

// play and record "set" functions

//#define VPBAPI_TERM_DIGITS_STRING_TOO_LONG			1070
#define	VPBAPI_INVALID_TERM_DIGITS				1071

// vpb_dial, programmable tone generator

#define	VPBAPI_DIAL_INVALID_DIGIT				1090
#define	VPBAPI_DIAL_INVALID_FREQUENCY				1093
#define	VPBAPI_DIAL_INVALID_LEVEL				1094
#define	VPBAPI_DIAL_NO_TONE					1095

// programmable tone detector

#define	VPBAPI_DETECT_TOO_MANY_DETECTORS			1200
#define VPBAPI_DETECT_INVALID_FREQUENCY				1201
#define VPBAPI_DETECT_INVALID_LEVEL				1202
#define VPBAPI_DETECT_INVALID_SNR				1203
#define VPBAPI_DETECT_INVALID_TWIST				1204
#define VPBAPI_DETECT_INVALID_STATES				1205
#define VPBAPI_DETECT_INVALID_TONE				1206
#define	VPBAPI_DETECT_NTONES_ERROR				1207
#define VPBAPI_DETECT_TOO_MANY_STATES				1208
#define	VPBAPI_DETECT_ALREADY_LOGGING				1209
#define	VPBAPI_DETECT_BAD_LOG_FILE_NAME				1210
#define	VPBAPI_NOT_ENOUGH_STATES				1211

// timers

#define VPBAPI_TIMER_INVALID_TIMER				1300
#define	VPBAPI_TIMER_ALREADY_ACTIVE				1301
#define	VPBAPI_TIMER_NOT_ACTIVE					1302

// vox

#define VPBAPI_VOX_ONLEVEL_TOO_BIG				1310
#define VPBAPI_VOX_ONLEVEL_TOO_SMALL				1311
#define VPBAPI_VOX_OFFLEVEL_TOO_BIG				1312
#define VPBAPI_VOX_OFFLEVEL_TOO_SMALL				1313
#define VPBAPI_VOX_RUNON_TOO_BIG				1314
#define VPBAPI_VOX_RUNON_TOO_SMALL				1315


// adpcm

#define	VPBAPI_ADPCM_SIZE_ADPCM_MUST_BE_EVEN			1330

// wave

#define	VPBAPI_WAVE_CANT_OPEN_FILE				1340
#define VPBAPI_WAVE_FORMAT_NOT_SUPPORTED			1341

// digits

//#define VPBAPI_DIGITS_MAX_DIGITS_TOO_BIG			1350
#define VPBAPI_DIGITS_INVALID_TERM_DIGITS			1351
//#define VPBAPI_DIGITS_TERM_DIGITS_STRING_TOO_LONG		1352

// call progress

#define	VPBAPI_CALL_PROGRESS_ALREADY_ACTIVE			2200
#define	VPBAPI_CALL_BODGY_TONE_MAP				2201
#define	VPBAPI_CALL_MAX_TONE_MAP				2202
#define	VPBAPI_CALL_MAX_CALLS_PER_MIN				2203

// Caller ID

#define VPBAPI_CID_NO_SIGNAL					2300
#define VPBAPI_CID_BAD_MESS_TYPE				2301
#define VPBAPI_CID_BAD_CHECKSUM					2302

// Bridging

#define VPBAPI_BRIDGE_HANDLES_IDENTICAL	     		        2400
#define VPBAPI_BRIDGE_DIFFERENT_BOARDS                          2401

// Conferencing

#define VPBAPI_CONF_BOARD_NOT_SUPPORTED				2501

#endif	// __VPBERR__

