#!/usr/bin/env python

from distutils.version import StrictVersion
import os
import glob

try:
    import DistUtilsExtra.auto
except ImportError:
    import sys
    print >> sys.stderr, 'To build webservice-office-zoho you need https://launchpad.net/python-distutils-extra'
    sys.exit(1)

assert StrictVersion(DistUtilsExtra.auto.__version__) >= '2.4', 'needs DistUtilsExtra.auto >= 2.4'

packageFolder = 'share/webservice-office-zoho'

DistUtilsExtra.auto.setup(
    name='webservice-office-zoho',
    version='0.1',
    description='Ubuntu web service for office documents using Zoho',
    long_description='webservice-office-zoho allows office documents to be viewed online using the Zoho web services',
    url='http://launchpad.net/webservice-office-zoho',
    license='GPL v3',
    author='Jamie Bennett',
    author_email='jb@canonical.com',
    scripts=['bin/webservice-office-zoho'],
    data_files=[(packageFolder, ['doc/empty-zoho-document.odt', 
				 'doc/empty-zoho-document.ods',
				 'doc/empty-zoho-document.odp']),
                ('share/icons/hicolor/scalable/apps', glob.glob("images/icons/*.svg"))
    ]
)

