/*
 * Decompiled with CFR 0.152.
 */
package fr.ove.openmath.jome.model.processor;

import fr.ove.openmath.jome.ctrl.linear.LinearParser;
import fr.ove.openmath.jome.ctrlview.bidim.FormulaDisplay;
import fr.ove.openmath.jome.model.Formula;
import fr.ove.openmath.jome.model.FormulaTreeStructure;
import fr.ove.openmath.jome.model.Icon;
import fr.ove.openmath.jome.model.events.ModelEvent;
import fr.ove.openmath.jome.model.processor.ProcessorImpl;
import fr.ove.openmath.jome.model.processor.WidthProcessorInterface;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.util.Enumeration;
import java.util.Vector;

public class WidthProcessor
extends ProcessorImpl
implements WidthProcessorInterface {
    private Vector widthList = new Vector();
    private boolean isListValid = false;
    private int view = -1;

    public WidthProcessor(Formula formula) {
        super(formula);
    }

    public void setWidthLevel(int n) {
        this.setLevel(n);
    }

    public int getWidthLevel() {
        return this.getLevel();
    }

    public void setView(int n) {
        this.view = n;
    }

    public int getView() {
        return this.view;
    }

    public Vector getWidthList() {
        if (!this.isListValid) {
            this.buildWidthList(this.getFormula());
            this.isListValid = true;
        }
        return this.widthList;
    }

    public int getBiggestWidth() {
        return (Integer)this.widthList.lastElement();
    }

    public void doProcess() {
        Formula formula = this.getFormula();
        if (formula != null) {
            switch (this.getProcessingId()) {
                case 1: {
                    this.buildWidthList(formula);
                    break;
                }
                case 2: {
                    this.setUpdateDisplay(true);
                    this.iconifyTheFTS(formula, this.getLevel());
                    this.setUpdateDisplay(false);
                    break;
                }
                case 3: {
                    this.setUpdateDisplay(true);
                    this.iconifyAllTheFTS(formula, this.getLevel());
                    this.setUpdateDisplay(false);
                    break;
                }
                case 4: {
                    this.buildWidthList(formula);
                    int n = this.getBiggestWidth() / 2;
                    int n2 = this.widthList.size();
                    for (int i = 0; i < n2; ++i) {
                        int n3 = (Integer)this.widthList.elementAt(i);
                        if (n3 <= n) continue;
                        n = n3;
                        break;
                    }
                    this.setLevel(n);
                    this.view = n / 2;
                    this.iconifyAllTheFTS(formula, n);
                }
            }
        }
    }

    private void iconifyTheFTS(FormulaTreeStructure formulaTreeStructure, int n) {
        Object var3_3 = null;
        int n2 = formulaTreeStructure.getNbChildren();
        if (n2 > 0 && n2 >= n) {
            this.iconify(formulaTreeStructure, n);
        }
        int n3 = formulaTreeStructure.getNbChildren();
        for (int i = 0; i < n3; ++i) {
            this.iconifyTheFTS((FormulaTreeStructure)formulaTreeStructure.getChild(i), n);
        }
    }

    private void iconifyAllTheFTS(FormulaTreeStructure formulaTreeStructure, int n) {
        int n2 = formulaTreeStructure.getNbChildren();
        if (n2 > 0) {
            Enumeration enumeration = formulaTreeStructure.getChildren().elements();
            while (enumeration.hasMoreElements()) {
                this.iconifyAllTheFTS((FormulaTreeStructure)enumeration.nextElement(), n);
            }
            if (n2 >= n) {
                this.iconify(formulaTreeStructure, n);
            }
        }
    }

    private void iconify(FormulaTreeStructure formulaTreeStructure, int n) {
        int n2;
        int n3 = formulaTreeStructure.getNbChildren();
        Icon icon = new Icon(formulaTreeStructure);
        formulaTreeStructure.addChild(icon);
        for (n2 = this.view; n2 < n3; ++n2) {
            icon.addIconified((FormulaTreeStructure)formulaTreeStructure.getChild(n2));
        }
        n2 = this.view;
        while (n2 < n3) {
            formulaTreeStructure.removeChild((FormulaTreeStructure)formulaTreeStructure.getChild(n2));
            --n3;
        }
        if (this.getUpdateDisplay()) {
            ModelEvent modelEvent = new ModelEvent(formulaTreeStructure);
            modelEvent.setAction(0, icon);
            formulaTreeStructure.fireModelEvent(modelEvent);
        }
    }

    private void buildWidthList(FormulaTreeStructure formulaTreeStructure) {
        int n = formulaTreeStructure.getNbChildren();
        if (n > 1) {
            this.addNewWidth(n);
        }
        for (int i = 0; i < n; ++i) {
            this.buildWidthList((FormulaTreeStructure)formulaTreeStructure.getChild(i));
        }
    }

    private void addNewWidth(int n) {
        if (this.widthList.size() == 0) {
            this.widthList.addElement(new Integer(n));
        } else {
            for (int i = 0; i < this.widthList.size(); ++i) {
                int n2 = (Integer)this.widthList.elementAt(i);
                if (n == n2) {
                    return;
                }
                if (n >= n2) continue;
                this.widthList.insertElementAt(new Integer(n), i);
                return;
            }
            this.widthList.addElement(new Integer(n));
        }
    }

    public static void main(String[] stringArray) {
        String string = "a*z*e*r*r*t*(t+2+2+2+2+2+2+2+6+6+6+6+6+6)*1*6*6*6*6*6*6+2+3+4+5+6+7+8+9+10+11+12+13+14";
        Formula formula = new Formula();
        formula.setDoProcessing(true);
        WidthProcessor widthProcessor = new WidthProcessor(formula);
        formula.setProcessor(widthProcessor);
        FormulaDisplay formulaDisplay = new FormulaDisplay();
        formula.addModelListener(formulaDisplay);
        formulaDisplay.addControlListener(formula);
        Frame frame = new Frame();
        frame.setLayout(new BorderLayout());
        frame.setBounds(50, 50, 250, 80);
        frame.add("Center", formulaDisplay);
        frame.setVisible(true);
        LinearParser linearParser = new LinearParser();
        linearParser.addLinearParserListener(formula);
        linearParser.parse(string);
        System.out.println("la formule saisie est : \t\t" + string);
        System.out.println("la formule construite est : \t\t" + formula.getLinear());
    }
}

