/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.constructors;

import java.awt.event.MouseEvent;
import rene.util.xml.XmlTag;
import rene.util.xml.XmlTree;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Construction;
import rene.zirkel.construction.ConstructionException;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.QuadricObject;

public class QuadricConstructor
extends ObjectConstructor {
    PointObject[] P;
    int NPoints;

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        if (!zirkelCanvas.Visual) {
            return;
        }
        PointObject pointObject = zirkelCanvas.selectCreatePoint(mouseEvent.getX(), mouseEvent.getY());
        if (pointObject != null) {
            this.P[this.NPoints++] = pointObject;
            pointObject.setSelected(true);
            zirkelCanvas.repaint();
        }
        this.showStatus(zirkelCanvas);
        if (this.NPoints == 5) {
            QuadricObject quadricObject = new QuadricObject(zirkelCanvas.getConstruction(), this.P);
            zirkelCanvas.addObject(quadricObject);
            quadricObject.setDefaults();
            zirkelCanvas.clearSelected();
            this.reset(zirkelCanvas);
            zirkelCanvas.repaint();
        }
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.showStatus(Zirkel.name("message.quadric") + " " + (this.NPoints + 1));
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        if (zirkelCanvas.Visual) {
            this.P = new PointObject[5];
            this.NPoints = 0;
            this.showStatus(zirkelCanvas);
        } else {
            zirkelCanvas.setPrompt(Zirkel.name("prompt.quadric"));
        }
    }

    public boolean construct(XmlTree xmlTree, Construction construction) throws ConstructionException {
        if (!this.testTree(xmlTree, "Quadric")) {
            return false;
        }
        XmlTag xmlTag = xmlTree.getTag();
        for (int i = 0; i < 5; ++i) {
            if (xmlTag.hasParam("point" + (i + 1))) continue;
            throw new ConstructionException("Quadric points missing!");
        }
        try {
            PointObject[] pointObjectArray = new PointObject[5];
            for (int i = 0; i < 5; ++i) {
                pointObjectArray[i] = (PointObject)construction.find(xmlTag.getValue("point" + (i + 1)));
            }
            QuadricObject quadricObject = new QuadricObject(construction, pointObjectArray);
            this.setName(xmlTag, quadricObject);
            this.set(xmlTree, quadricObject);
            construction.add(quadricObject);
            this.setConditionals(xmlTree, construction, quadricObject);
        }
        catch (ConstructionException constructionException) {
            throw constructionException;
        }
        catch (Exception exception) {
            throw new ConstructionException("Quadric points illegal!");
        }
        return true;
    }

    public String getPrompt() {
        return Zirkel.name("prompt.quadric");
    }

    public String getTag() {
        return "Quadric";
    }

    public void construct(Construction construction, String string, String[] stringArray, int n) throws ConstructionException {
        if (n != 5) {
            throw new ConstructionException(Zirkel.name("exception.nparams"));
        }
        PointObject[] pointObjectArray = new PointObject[5];
        for (int i = 0; i < 5; ++i) {
            pointObjectArray[i] = construction.find(stringArray[i]);
            if (pointObjectArray[i] == null) {
                throw new ConstructionException(Zirkel.name("exception.notfound") + " " + stringArray[i]);
            }
            if (pointObjectArray[i] instanceof PointObject) continue;
            throw new ConstructionException(Zirkel.name("exception.type") + " " + stringArray[i]);
        }
        QuadricObject quadricObject = new QuadricObject(construction, pointObjectArray);
        if (!string.equals("")) {
            quadricObject.setNameCheck(string);
        }
        construction.add(quadricObject);
        quadricObject.setDefaults();
    }
}

