/*
 *========================================================================
 * $Id: startup.c 72 2006-07-20 18:04:33Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

/*
 *========================================================================
 *  wulflogger startup inherits the parsed command line and the does the
 * derived bookkeeping and initialization.  In particular it 
 *   a) allocates space for the important vectors and structures ;
 *   b) opens sockets to the list of hosts in hostfile (if possible);
 *   c) sends baseline init to all of those xmlsysd's.  This needs to
 * be done in startup because eventually the init process will be used to
 * mask the subset of all fields actually needed to generate the wulflogger
 * results (only);
 *   d) delay one second, and then pass control on to wulfstat_work for
 * an infinite loop of updates.  The one second will allow reasonably
 * accurate rates to be displayed from the beginning.
 *========================================================================
 */

#include "wulflogger.h"

void startup()
{

 /* loop index */
 int i;


 /* length of io buffer in use */
 int buflen,readcnt;

 /* pointer to return from xmltract */
 char *xpval;

 if((verbose == D_ALL) || (verbose == D_STARTUP)){
   printf("D_STARTUP:  XML initialization.  Use -v %d to focus.\n",D_STARTUP);
 }

 /*
  * Need to do this so it doesn't mess up use in scripts?
 fclose(stdin);
  */

 /*
  * XML setup.
  * I like keeping blanks in the XML that is parsed and printed if I'm
  * going to read it.  One has to initialize the xpath parser as
  * well.
  */
 LIBXML_TEST_VERSION
 xmlKeepBlanksDefault(0);
 xmlXPathInit();

 /*
  * OK, we'll try something ELSE to free us from the nasty blocking
  * properties of bash if stdin is left open.
 ioctl(0,TIOCNOTTY);
  */

 /*
  * allocate all the various hostlist linked lists with a
  * libwulf library call.
  */
 allocate_hostlists();

 /*
  * Read in/parse the xml wulfhost file with a single libwulf call.
  */
 if((verbose == D_ALL) || (verbose == D_STARTUP)){
   printf("D_STARTUP: Read in the hostfile %s.\n",hostfile);
 }
 numhosts = read_wulfhosts(hostfile);

 /*
  * Set the dctl struct to the state associated with the initial
  * display type.  Each xmlsysd connection will then be started
  * up correctly.
  */
 set_display_dctl_state();

 /*
  * This libwulf function establishes a connection to all hosts in a
  * separate thread, initializes them according to the current dctl state.
  * It polls the list of hosts every connect_delay seconds and if any are
  * marked down, it tries to restart their connections.  In this way
  * downed hosts that come back up are automagically restored.
  * Connectlist is a struct because a thread call can have only a single
  * void* argument.
  */
 if((verbose == D_ALL) || (verbose == D_STARTUP)){
   printf("D_STARTUP: Connect to the hosts in hostlist = %0x.\n",hostlist);
   printf("D_STARTUP: hostlist->head = %0x\n",hostlist->head);
 }
 connectlist.hostlist = hostlist;
 connectlist.connect_delay = connect_delay;
 pthread_create(&connecttid,NULL,(void*)connect_to_all_hosts,&connectlist);

 if((verbose == D_ALL) || (verbose == D_STARTUP)){
   printf("D_STARTUP: All done with startup().\n");
 }

}
