/*
 *========================================================================
 * $Id: xml_display_values.c 167 2002-11-01 22:15:57Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include "wulfstat.h"

/*
 *========================================================================
 * xml_display routines all work according to the following general 
 * recipe:
 *
 * We walk the (linked) list of hosts.  For each host we read its xml
 * return from the already-completed send_to_all command (if possible)
 * and convert it into an xpath context to make extracting data as easy
 * as possible.  We then walk ITS list of pid's, displaying each value
 * as we go.  
 *
 * In this way we don't NEED much extra storage.  hostptr->doc "is" the
 * actual data structure displayed for everything but rates, and the
 * overhead of allocating it and freeing it each pass through is
 * inescapable.  xpath is actually a redirection structure and we
 * could (if we wished) avoid its use altogether and parse the data out
 * of the xml doc itself.  This also gives us a clear place to focus
 * optimization energy -- we "could" make the document walker as close to
 * single pass (per host) as possible by doing the entire list of possible
 * values to be parsed all at once and using ncurses a bit more.
 *
 * To develop this as reusably as possible, we're going to split off the
 * general formatting of the window from the parse/display part, and
 * TRY to work out routines that do "all" the parsing, ncurses locating,
 * and printing of a result with a single line of arguments.  That way
 * building a display should be very easy.
 *========================================================================
 */
void xml_display_pids()
{

 /* Loop indices */
 int i,j,k;
 /* 
  * A buffer to aid in truncating names.  One extra space for terminating
  * null.  The second one is to hold output from scale_k().
  */
 char namebuf[10];
 char row_out[10][10];
 /* scratch space for positioning and counters both */
 int row = 0,col = 0;
 /* controls the hosts loop so we can page */
 int imin_col,imax_col;
 /* 
  * We need these to define EACH host as we walk the list of hosts for 
  * display.
  */
 Host *hostptr;
 ListElement *element;
 

 if((verbose == D_ALL) || (verbose == D_DISPLAY_VALUES)){
   wprintw(debugpad,"D_DISPLAY_VALUES: Starting display_user().  Use -v %d to focus.\n",D_DISPLAY_VALUES);
   wrefresh(debugpad);
 }

 mvwprintw(headerwin,0,1,"%-9s|%5s|%7s|%7s|%7s|%5s|%7s|%7s|%5s|%5s|%5s|",
      "hostname",
      "PID",
      "User",
      "RSS",
      "Size",
      "Share",
      "Stat",
      "%CPU",
      "%Mem",
      "Time",
      "Command"
   );


   /*
    * Loop over all hosts in THIS column.  Note that we have to basically
    * walk the list of hosts, but we do so inside an i-loop based on
    * numhosts.  It is therefore important that numhosts be kept accurate.
    */
   element = hostlist->head;
   for(i=0;i<numhosts;i++){
     if(element == NULL) break;	/* For whatever reason, out of hosts */
     hostptr = element->data;
     if(hostptr->connected) {
       /*
        * This display is going to be fundamentally different from
        * the others in that one cannot predict how many (if any)
        * tasks that match the specified criteria will be running
        * on any host in the list.  These numbers can also jump
        * up or down without warning as tasks are started or die or
        * or stopped.  To manage this sort of free form data presentation
        * we will collect the pid data in a linked list of structs
        * indexed per host.  That is, hostptr->var.runlist will be
        * a linked list of tasks that match the specified task criteria
        * Filling it will be tricky, but is handled elsewhere.  Here
        * we simply walk the list for each host and displace a line
        * for each entry found.
       sprintf(row_out[0],"%5.5s",scale_k(hostptr->val.mem_total,5,0));
        */
     mvwprintw(displaywin,i,0,"%-9.9s|",
         hostptr->hostname
       );

   } else {
     mvwprintw(displaywin,i,j,"%-9.9s| Not connected...",
         hostptr->hostname);
   }
   element = element->next;

 }

 prefresh(displaypad,display.showline_displaypad,0,display.line_displaypad,1,display.lines_displaypad,COLS-2);

}

