/*
 *========================================================================
 * $Id: parsecl.c 139 2004-07-06 14:01:42Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */


#include "xmlsysd.h"

/*
 *========================================================================
 * parsecl() is a "reusable" command line parser designed to parse global
 * variables.  There should be an include file with these globals and the
 * required standard includes (including getopt stuff) above.
 *========================================================================
 */

void Usage();

void parsecl(argc, argv)
char **argv;
int argc;
{			/* Start of parsecl() */

 int imax,i,c,errflg=0;
 extern char *optarg;
 extern int optind, opterr, optopt;

/*
 if (argc > 2) {
   printf("argc = %d\n",argc);
   Usage();
   exit(0);
 }
*/

/*
 *========================================================================
 * Set globals from command line or defaults.  We set a lot of the
 * global control variables here in case we ever want to create a
 * command line option to control them.
 *
 * There MUST be a one-to-one correspondance between every global
 * variable given a default.
 *========================================================================
 */
 verbose = 0;		/* default is quiet.  1 is maximally verbose. */
 daemonmode = FORK;	/* default is run as a forking daemon... */
 port = 7887;		/* ...on port 7887 */
 nconnxns = 10;		/* Run up to 10 daemons simultaneously */
 initialized = 0;	/* Reset to 1 when init is run */
 /* daemon control flags */
 dctl.compress = 0;	/* Don't compress */
 dctl.whitespace = 1;	/* Leave in whitespace indentation */
 dctl.identity = 1;	/* send identity */
 dctl.time = 1;		/* send time */
 dctl.users = 1;	/* send users */
 dctl.cpuinfo = 1;	/* send cpuinfo */
 dctl.loadavg = 1;	/* send loadavg */
 dctl.meminfo = 1;	/* send meminfo */
 dctl.net = 1;		/* send net */
 dctl.stat = 1;		/* send stat */
 dctl.sysvipc = 1;	/* send sysvipc */
 dctl.uptime = 1;	/* send uptime */
 dctl.version = 1;	/* send version */
 dctl.pids = 0;		/* don't send pids yet */
 dctl.running = 1;	/* but when I do send only running pids */
 dctl.root = 0;		/* that don't belong to root */
 dctl.pidstats = 0;	/* without sending stat, statm */
 dctl.cmdline = 0;	/* without sending cmdline */
 dctl.min_runtime = 0;	/* and that have been running any amount of time */

 while ((c = getopt(argc,argv,"d:hi:mn:v:")) != EOF){
   switch (c){
     case 'd':
       daemonmode = FORK;
       port = atoi(optarg);
       break;
     case 'h':
       Usage();
       exit(0);
       break;
     case 'i':
       daemonmode = INETD;
       port = atoi(optarg);
       break;
     case 'm':
       daemonmode = MCAST;
       port = 0;
       break;
     case 'n':
       nconnxns = atoi(optarg);
       break;
     case 'v':
       if(optarg){
         verbose = atoi(optarg);
       }
       break;
     case '?':
       errflg++;
   }
 }

 if(errflg || (argc - optind != 0)) {
   Usage();
   exit(0);
 }

 if(verbose){
   printf("D_PARSECL: Completing parsecl().  verbose = %d\n",verbose);
 }
}


void Usage()
{

/*
 *==========================================================================
 * Usage message describes command.  Can be called on flag or error.
 *==========================================================================
 */
 fprintf(stderr,"Usage:\n");
 fprintf(stderr,"  procd  [-i [port]] [-d port] [-m] [-n nconnect] [-v verbosity]\n");
 fprintf(stderr,"Options:\n");
 fprintf(stderr,"  -i: run xmlsysd as inetd daemon on port (default, port 7887)\n");
 fprintf(stderr,"  -d: run xmlsysd as forking daemon on port\n");
/* fprintf(stderr,"  -m: run xmlsysd as multicast daemon (no port)\n"); */
 fprintf(stderr,"  -n: allow nconnect simultaneous (forking) daemon connections.\n");
 fprintf(stderr,"  -v: make xmlsysd verbose for debugging (forking mode only) \n");
 fprintf(stderr,"\n");

}
