#define ANIMATE 1
/*
 * @(#)Triangles.h
 *
 * Copyright 1994 - 2012  David A. Bagley, bagleyd@tux.org
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Public header file for Triangles */

#ifndef _XtTriangles_h
#define _XtTriangles_h

/***********************************************************************
 *
 * Triangles Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNtileColor ((char *) "tileColor")
#define XtNtextColor ((char *) "textColor")
#define XtNinstall ((char *) "install")
#define XtNpicture ((char *) "picture")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNbumpSound ((char *) "bumpSound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNsize ((char *) "size")
#define XtNbase ((char *) "base")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNpixmapSize ((char *) "pixmapSize")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCInstall ((char *) "Install")
#define XtCPicture ((char *) "Picture")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCBumpSound ((char *) "BumpSound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCSize ((char *) "Size")
#define XtCBase ((char *) "Base")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")
#define XtCPixmapSize ((char *) "PixmapSize")

typedef struct _TrianglesClassRec *TrianglesWidgetClass;

extern WidgetClass trianglesWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} trianglesCallbackStruct;
#endif

#define ACTION_READ 100
#define ACTION_WRITE 101
#define ACTION_EXIT 102
#define ACTION_HIDE 103
#define ACTION_CLEAR_QUERY 104
#define ACTION_SOLVE_MESSAGE 105
#define ACTION_RESTORE 106
#define ACTION_RESET 107
#define ACTION_BLOCKED 108
#define ACTION_SPACE 109
#define ACTION_MOVED 110
#define ACTION_SOLVED 111
#define ACTION_COMPUTED 112
#define ACTION_UNDO 200
#define ACTION_REDO 201
#define ACTION_CLEAR 202
#define ACTION_RANDOMIZE 203
#define ACTION_SOLVE 204
#define ACTION_INCREMENT 205
#define ACTION_DECREMENT 206
#define ACTION_SPEED 207
#define ACTION_SLOW 208
#define ACTION_SOUND 209
#define ACTION_TR 300
#define ACTION_RIGHT 301
#define ACTION_BR 302
#define ACTION_BL 303
#define ACTION_LEFT 304
#define ACTION_TL 305
#define ACTION_DESCRIPTION 900
#define ACTION_FEATURES 901
#define ACTION_REFERENCES 902
#define ACTION_ABOUT 903
#define ACTION_IGNORE 999

#define MIN_TILES 1
#define DEFAULT_TILES 4
#define DEFAULT_DELAY 10
#ifdef MONOTEST
#define DEFAULT_MONO TRUE
#else
#define DEFAULT_MONO FALSE
#endif
#define DEFAULT_REVERSE FALSE
#define MIN_BASE 2 /* Base 1 is rediculous :) */
#define MAX_BASE 36 /* 10 numbers + 26 letters (ASCII) */
#define DEFAULT_BASE 10

#define BOOL_STRING(a) ((a==0)?"false":"true")

typedef struct _TrianglesRec *TrianglesWidget;

#endif /* _XtTriangles_h */
/* DON'T ADD STUFF AFTER THIS #endif */
