#!/bin/sh
# Example for use of GNU gettext.
# Copyright (C) 2003 Free Software Foundation, Inc.
# This file is in the public domain.
#
# Script for regenerating all autogenerated files.

rm -f po/Makevars.template
rm -f po/Rules-quot
rm -f po/boldquot.sed
rm -f po/en@boldquot.header
rm -f po/en@quot.header
rm -f po/insert-header.sin
rm -f po/quot.sed

aclocal -I macros

autoconf

automake -a -c

cd po
for f in *.po; do
  if test -r "$f"; then
    lang=`echo $f | sed -e 's,\.po$,,'`
    msgfmt -c -o $lang.gmo $lang.po
  fi
done
cd ..
