#import "ExpectationCounterTest.h"

@implementation ExpectationCounterTest

- (void)testUnsuccessfulExpectation {
    ExpectationCounter *expectationCounter = [[[ExpectationCounter alloc] initWithName:@"My Counter"] autorelease];
    NSException *exception = nil;

    [expectationCounter setExpectedCount:14];
    [expectationCounter increment];

    NS_DURING
        [expectationCounter verify];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"Should raise exception"];
    [self assertString:[exception name] equals:@"AssertionFailedException"];
    [self assertString:[exception reason] equals:@"My Counter expected 14, was 1"];
}

- (void)testSuccessfulExpectation {
    ExpectationCounter *expectationCounter = [[[ExpectationCounter alloc] initWithName:@"My Counter"] autorelease];
    
    [expectationCounter setExpectedCount:2];
    [expectationCounter increment];
    [expectationCounter increment];

    NS_DURING
        [expectationCounter verify];
    NS_HANDLER
        [self fail:@"Should not raise exception"];
    NS_ENDHANDLER
}

- (void)testFailsImmediatelyOnTooManyIncrements {
    ExpectationCounter *expectationCounter = [[[ExpectationCounter alloc] initWithName:@"My Counter"] autorelease];
    NSException *exception = nil;

    [expectationCounter setExpectedCount:0];

    NS_DURING
        [expectationCounter increment];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"Should raise exception"];
    [self assertString:[exception name] equals:@"AssertionFailedException"];
    [self assertString:[exception reason] equals:@"My Counter expected no more than 0 increments"];
}

- (void)testFailsOnVerify {
    ExpectationCounter *expectationCounter = [[[ExpectationCounter alloc] initWithName:@"My Counter"] autorelease];
    NSException *exception = nil;

    [expectationCounter setExpectedCount:0];
    [expectationCounter setFailsOnVerify:YES];

    NS_DURING
        [expectationCounter increment];
    NS_HANDLER
        [self fail:@"Should not raise exception"];
    NS_ENDHANDLER

    NS_DURING
        [expectationCounter verify];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER
    
    [self assertNotNil:exception message:@"Should raise exception"];
    [self assertString:[exception name] equals:@"AssertionFailedException"];
    [self assertString:[exception reason] equals:@"My Counter expected 0, was 1"];
}

- (void)testVerifyPassesOnNoExpectation {
    ExpectationCounter *expectationCounter = [[[ExpectationCounter alloc] initWithName:@"My Counter"] autorelease];

    NS_DURING
        [expectationCounter verify];
    NS_HANDLER
        [self fail:@"Shouldn't raise exception"];
    NS_ENDHANDLER
}

- (void)testIncrementPassesOnNoExpectation {
    ExpectationCounter *expectationCounter = [[[ExpectationCounter alloc] initWithName:@"My Counter"] autorelease];

    NS_DURING
        [expectationCounter increment];
    NS_HANDLER
        [self fail:@"Shouldn't raise exception"];
    NS_ENDHANDLER
}

- (void)testVerifyPassesAfterIncrementOnNoExpectation {
    ExpectationCounter *expectationCounter = [[[ExpectationCounter alloc] initWithName:@"My Counter"] autorelease];

    [expectationCounter increment];
    
    NS_DURING
        [expectationCounter verify];
    NS_HANDLER
        [self fail:@"Shouldn't raise exception"];
    NS_ENDHANDLER
}

@end
