package ONVIF::Media::Types::Behaviour;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Removed_of :ATTR(:get<Removed>);
my %Idle_of :ATTR(:get<Idle>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Removed
        Idle
        Extension

    ) ],
    {
        'Removed' => \%Removed_of,
        'Idle' => \%Idle_of,
        'Extension' => \%Extension_of,
    },
    {

        'Removed' => 'ONVIF::Media::Types::Behaviour::_Removed',

        'Idle' => 'ONVIF::Media::Types::Behaviour::_Idle',
        'Extension' => 'ONVIF::Media::Types::BehaviourExtension',
    },
    {

        'Removed' => 'Removed',
        'Idle' => 'Idle',
        'Extension' => 'Extension',
    }
);

} # end BLOCK




package ONVIF::Media::Types::Behaviour::_Idle;
use strict;
use warnings;
{
our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables


__PACKAGE__->_factory(
    [ qw(
    ) ],
    {
    },
    {
    },
    {

    }
);

} # end BLOCK







}



package ONVIF::Media::Types::Behaviour::_Removed;
use strict;
use warnings;
{
our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables


__PACKAGE__->_factory(
    [ qw(
    ) ],
    {
    },
    {
    },
    {

    }
);

} # end BLOCK







}







1;


=pod

=head1 NAME

ONVIF::Media::Types::Behaviour

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Behaviour from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Removed


=item * Idle


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::Behaviour
   Removed =>  {
   },
   Idle =>  {
   },
   Extension =>  { # ONVIF::Media::Types::BehaviourExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

