package ONVIF::Device::Types::RecordingInformation;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %RecordingToken_of :ATTR(:get<RecordingToken>);
my %Source_of :ATTR(:get<Source>);
my %EarliestRecording_of :ATTR(:get<EarliestRecording>);
my %LatestRecording_of :ATTR(:get<LatestRecording>);
my %Content_of :ATTR(:get<Content>);
my %Track_of :ATTR(:get<Track>);
my %RecordingStatus_of :ATTR(:get<RecordingStatus>);

__PACKAGE__->_factory(
    [ qw(        RecordingToken
        Source
        EarliestRecording
        LatestRecording
        Content
        Track
        RecordingStatus

    ) ],
    {
        'RecordingToken' => \%RecordingToken_of,
        'Source' => \%Source_of,
        'EarliestRecording' => \%EarliestRecording_of,
        'LatestRecording' => \%LatestRecording_of,
        'Content' => \%Content_of,
        'Track' => \%Track_of,
        'RecordingStatus' => \%RecordingStatus_of,
    },
    {
        'RecordingToken' => 'ONVIF::Device::Types::RecordingReference',
        'Source' => 'ONVIF::Device::Types::RecordingSourceInformation',
        'EarliestRecording' => 'SOAP::WSDL::XSD::Typelib::Builtin::dateTime',
        'LatestRecording' => 'SOAP::WSDL::XSD::Typelib::Builtin::dateTime',
        'Content' => 'ONVIF::Device::Types::Description',
        'Track' => 'ONVIF::Device::Types::TrackInformation',
        'RecordingStatus' => 'ONVIF::Device::Types::RecordingStatus',
    },
    {

        'RecordingToken' => 'RecordingToken',
        'Source' => 'Source',
        'EarliestRecording' => 'EarliestRecording',
        'LatestRecording' => 'LatestRecording',
        'Content' => 'Content',
        'Track' => 'Track',
        'RecordingStatus' => 'RecordingStatus',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Device::Types::RecordingInformation

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
RecordingInformation from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * RecordingToken


=item * Source


=item * EarliestRecording


=item * LatestRecording


=item * Content


=item * Track


=item * RecordingStatus




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Device::Types::RecordingInformation
   RecordingToken => $some_value, # RecordingReference
   Source =>  { # ONVIF::Device::Types::RecordingSourceInformation
     SourceId =>  $some_value, # anyURI
     Name => $some_value, # Name
     Location => $some_value, # Description
     Description => $some_value, # Description
     Address =>  $some_value, # anyURI
   },
   EarliestRecording =>  $some_value, # dateTime
   LatestRecording =>  $some_value, # dateTime
   Content => $some_value, # Description
   Track =>  { # ONVIF::Device::Types::TrackInformation
     TrackToken => $some_value, # TrackReference
     TrackType => $some_value, # TrackType
     Description => $some_value, # Description
     DataFrom =>  $some_value, # dateTime
     DataTo =>  $some_value, # dateTime
   },
   RecordingStatus => $some_value, # RecordingStatus
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

